/*
 * Decompiled with CFR 0.152.
 */
package ca.bradj.questown.jobs;

import ca.bradj.questown.QT;
import ca.bradj.questown.jobs.ExpirationRules;
import ca.bradj.questown.jobs.JobID;
import ca.bradj.questown.jobs.WorkOutput;
import ca.bradj.questown.jobs.WorkPosition;
import ca.bradj.questown.jobs.declarative.AbstractWorldInteraction;
import ca.bradj.questown.jobs.declarative.Preferred;
import ca.bradj.questown.jobs.declarative.WithReason;
import ca.bradj.questown.jobs.production.ProductionStatus;
import ca.bradj.questown.mc.Util;
import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.function.Supplier;
import org.jetbrains.annotations.Nullable;

public class JobLogic<EXTRA, TOWN, POS> {
    private int worked = 0;
    private int ticksWithoutNextJob = 0;
    private WorkPosition<POS> workSpot;
    private boolean grabbingInsertedSupplies;
    private boolean grabbedInsertedSupplies;
    private boolean wrappingUp;
    private int ticksSinceStart;
    private int noSuppliesTicks;
    private boolean settingUp = true;

    public boolean hasWorkedRecently() {
        return this.worked > 0;
    }

    public boolean isWrappingUp() {
        return this.wrappingUp;
    }

    @Nullable
    public WorkPosition<POS> workSpot() {
        return this.workSpot;
    }

    public boolean isGrabbingInsertedSupplies() {
        return this.grabbingInsertedSupplies;
    }

    public void tick(EXTRA extra, Supplier<ProductionStatus> computeState, JobID entityCurrentJob, boolean isEntityInJobSite, boolean isSeekingWork, boolean hasInsertedAtLeastOneIngredient, boolean hasAnyItems, ExpirationRules expiration, JobDetails details, JLWorld<EXTRA, TOWN, POS> worldBeforeTick, BiFunction<TOWN, POS, Integer> getState, int workRecently) {
        if (!hasAnyItems && computeState.get().isDroppingLoot()) {
            worldBeforeTick.changeToNextJob();
            return;
        }
        if (this.ticksWithoutNextJob > 500) {
            QT.JOB_LOGGER.debug("{} gave up waiting for different work after {} ticks ({})", (Object)entityCurrentJob.rootId(), (Object)this.ticksWithoutNextJob, (Object)entityCurrentJob.jobId());
            worldBeforeTick.changeJob(expiration.noSuppliesFallbackFn().apply(entityCurrentJob));
            return;
        }
        ++this.ticksSinceStart;
        ProductionStatus status = computeState.get();
        if (this.ticksSinceStart % 200 == 0 && status.isExtractingProduct()) {
            worldBeforeTick.registerUnmetNeeds(status, Util.orNull(this.workSpot, WorkPosition::jobBlock), worldBeforeTick.hasInsertedSupplies());
        }
        if (status.isDroppingLoot() && worldBeforeTick.tryDropLoot()) {
            this.workSpot = null;
            return;
        }
        this.noSuppliesTicks = ImmutableList.of((Object)ProductionStatus.NO_SUPPLIES, (Object)ProductionStatus.NO_JOBSITE).contains((Object)status) ? ++this.noSuppliesTicks : (status.isWorkingOnProduction() && this.workSpot == null ? ++this.noSuppliesTicks : 0);
        if (this.setup(details.workRequiredAtFirstState(), worldBeforeTick)) {
            return;
        }
        this.worked = Math.max(0, this.worked - 1);
        if (this.grabbingInsertedSupplies) {
            if (worldBeforeTick.tryGrabbingInsertedSupplies()) {
                this.grabbingInsertedSupplies = false;
                this.grabbedInsertedSupplies = true;
                worldBeforeTick.clearInsertedSupplies();
            }
            return;
        }
        if (this.grabbedInsertedSupplies) {
            worldBeforeTick.changeToNextJob();
            ++this.ticksWithoutNextJob;
            return;
        }
        WorkPosition<POS> workSpot = worldBeforeTick.getWorkSpot();
        if (workSpot == null && (long)this.ticksSinceStart > expiration.maxTicks()) {
            JobID fbJov = expiration.maxTicksFallbackFn().apply(entityCurrentJob);
            QT.JOB_LOGGER.debug("Reached max ticks for {}. Falling back to {}.", (Object)entityCurrentJob, (Object)fbJov);
            worldBeforeTick.changeJob(fbJov);
            return;
        }
        long maxNoSupplyTicks = expiration.maxInitialTicksWithoutSuppliesOrJobSite();
        if (hasInsertedAtLeastOneIngredient) {
            maxNoSupplyTicks = expiration.maxTicksWithoutSuppliesOrJobSite();
        }
        if ((long)this.noSuppliesTicks > maxNoSupplyTicks) {
            QT.JOB_LOGGER.debug("{} gave up waiting for ingredients after {} ticks (job: {})", (Object)entityCurrentJob.rootId(), (Object)this.noSuppliesTicks, (Object)entityCurrentJob.jobId());
            this.grabbingInsertedSupplies = true;
            if (status == ProductionStatus.NO_SUPPLIES) {
                worldBeforeTick.registerUnmetNeeds(status, Util.orNull(workSpot, WorkPosition::jobBlock), worldBeforeTick.hasInsertedSupplies());
            } else if (status == ProductionStatus.NO_JOBSITE) {
                worldBeforeTick.registerUnmetRooms();
            }
            return;
        }
        if (isEntityInJobSite && status.isWorkingOnProduction()) {
            this.doTryWorking(extra, status.getProductionState(details.maxState()), isSeekingWork, worldBeforeTick, getState, details.workPause, workRecently);
        }
        if (status.isDroppingLoot() && worldBeforeTick.tryDropLoot()) {
            this.workSpot = null;
            return;
        }
        worldBeforeTick.tryGetSupplies();
        if (this.wrappingUp) {
            worldBeforeTick.changeToNextJob();
            ++this.ticksWithoutNextJob;
        }
    }

    protected boolean setup(@Nullable Integer workRequiredAtFirstState, JLWorld<EXTRA, TOWN, POS> worldBeforeTick) {
        if (!this.settingUp) {
            return false;
        }
        if (workRequiredAtFirstState != null && workRequiredAtFirstState != 0 && worldBeforeTick.setWorkLeftAtFreshState(workRequiredAtFirstState)) {
            this.settingUp = false;
            return true;
        }
        return false;
    }

    private WithReason<Boolean> doTryWorking(EXTRA extra, int productionState, boolean isSeekingWork, JLWorld<EXTRA, TOWN, POS> world, BiFunction<TOWN, POS, Integer> getState, int workPause, int workedRecently) {
        Map<Integer, Collection<WorkPosition<POS>>> workSpots = world.listAllWorkSpots();
        Collection<WorkPosition<POS>> workSpot1 = workSpots.get(productionState);
        if (workSpot1 == null) {
            String problem = "Worker somehow has different status than all existing work spots";
            return WithReason.unformatted(null, problem);
        }
        Preferred<WorkPosition<POS>> allSpots = new Preferred<WorkPosition<POS>>(this.workSpot, workSpot1);
        if (allSpots.isEmpty()) {
            return WithReason.unformatted(null, "No workspots");
        }
        WorkOutput<TOWN, WorkPosition<POS>> work = world.getHandle().tryWorking(extra, allSpots);
        this.setWorkSpot(work.spot());
        if (work.worked()) {
            boolean finishedWork;
            this.worked = workedRecently + workPause;
            world.setLookTarget(work.spot().jobBlock());
            boolean hasWork = !isSeekingWork;
            Integer stateAfterWork = getState.apply(work.town(), work.spot().jobBlock());
            boolean bl = finishedWork = productionState > 0 && stateAfterWork.equals(0);
            if (hasWork && finishedWork) {
                if (!this.wrappingUp) {
                    world.registerHeldItemsAsFoundLoot();
                }
                this.wrappingUp = true;
            }
        }
        return WithReason.unformatted(this.wrappingUp, "If worked");
    }

    protected void setWorkSpot(WorkPosition<POS> spot) {
        if (this.workSpot != null && this.workSpot.equals(spot)) {
            return;
        }
        QT.JOB_LOGGER.debug("Villager is targeting workspot {}", spot);
        this.workSpot = spot;
    }

    public static interface JLWorld<EXTRA, TOWN, POS> {
        public void changeJob(JobID var1);

        public WorkPosition<POS> getWorkSpot();

        public boolean tryGrabbingInsertedSupplies();

        public boolean tryDropLoot();

        public void tryGetSupplies();

        public Map<Integer, Collection<WorkPosition<POS>>> listAllWorkSpots();

        public void setLookTarget(POS var1);

        public void registerHeldItemsAsFoundLoot();

        public AbstractWorldInteraction<EXTRA, POS, ?, ?, TOWN> getHandle();

        public void changeToNextJob();

        public boolean setWorkLeftAtFreshState(int var1);

        public void clearInsertedSupplies();

        public void registerUnmetNeeds(ProductionStatus var1, @Nullable POS var2, boolean var3);

        public boolean hasInsertedSupplies();

        public void registerUnmetRooms();
    }

    public record JobDetails(int maxState, @Nullable Integer workRequiredAtFirstState, int workPause) {
    }
}

