/*
 * Decompiled with CFR 0.152.
 */
package ca.bradj.questown.jobs;

import ca.bradj.questown.QT;
import ca.bradj.questown.blocks.TakeFn;
import ca.bradj.questown.core.Config;
import ca.bradj.questown.core.UtilClean;
import ca.bradj.questown.core.init.items.ItemsInit;
import ca.bradj.questown.integration.minecraft.MCContainer;
import ca.bradj.questown.integration.minecraft.MCHeldItem;
import ca.bradj.questown.integration.minecraft.MCTownItem;
import ca.bradj.questown.jobs.DefaultInventoryStateProvider;
import ca.bradj.questown.jobs.EntityCurrentJobSite;
import ca.bradj.questown.jobs.HeldItem;
import ca.bradj.questown.jobs.IStatus;
import ca.bradj.questown.jobs.ImmutableSnapshot;
import ca.bradj.questown.jobs.Item;
import ca.bradj.questown.jobs.ItemsHolder;
import ca.bradj.questown.jobs.Job;
import ca.bradj.questown.jobs.JobID;
import ca.bradj.questown.jobs.JobsClean;
import ca.bradj.questown.jobs.JournalItemList;
import ca.bradj.questown.jobs.RoomRecipeMatchUtils;
import ca.bradj.questown.jobs.leaver.ContainerTarget;
import ca.bradj.questown.jobs.production.RoomsNeedingVillagerInput;
import ca.bradj.questown.logic.IPredicateCollection;
import ca.bradj.questown.logic.PredicateCollection;
import ca.bradj.questown.mc.Compat;
import ca.bradj.questown.mc.PredicateCollections;
import ca.bradj.questown.mobs.visitor.VisitorMobEntity;
import ca.bradj.questown.town.TownContainers;
import ca.bradj.questown.town.interfaces.RoomsHolder;
import ca.bradj.questown.town.interfaces.TownInterface;
import ca.bradj.questown.town.special.SpecialQuests;
import ca.bradj.questown.town.workstatus.State;
import ca.bradj.roomrecipes.adapter.IRoomRecipeMatch;
import ca.bradj.roomrecipes.adapter.Positions;
import ca.bradj.roomrecipes.adapter.RoomRecipeMatch;
import ca.bradj.roomrecipes.serialization.MCRoom;
import com.google.common.base.Predicates;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Jobs {
    public static ImmutableList<ItemStack> getItems(Job<MCHeldItem, ?, ?> job) {
        ImmutableList.Builder b = ImmutableList.builder();
        Container inventory = job.getInventory();
        for (int i = 0; i < inventory.m_6643_(); ++i) {
            b.add((Object)inventory.m_8020_(i));
        }
        return b.build();
    }

    public static boolean isUnchanged(Container container, ImmutableList<MCHeldItem> items) {
        for (int i = 0; i < container.m_6643_(); ++i) {
            if (container.m_8020_(i).m_150930_(((MCHeldItem)items.get(i)).get().get())) continue;
            return false;
        }
        return true;
    }

    public static boolean isCloseTo(@NotNull BlockPos entityPos, @NotNull BlockPos targetPos) {
        double d = targetPos.m_203198_((double)entityPos.m_123341_(), (double)entityPos.m_123342_(), (double)entityPos.m_123343_());
        return d < 5.0;
    }

    public static void handleItemChanges(Container inventory, ImmutableList<MCHeldItem> items) {
        if (Jobs.isUnchanged(inventory, items)) {
            return;
        }
        for (int i = 0; i < items.size(); ++i) {
            net.minecraft.world.item.Item curItem = inventory.m_8020_(i).m_41720_();
            net.minecraft.world.item.Item newItem = ((MCHeldItem)items.get(i)).get().get();
            if (newItem.equals(curItem)) continue;
            inventory.m_6836_(i, ((MCHeldItem)items.get(i)).get().toMCItemStack());
        }
    }

    public static <H extends HeldItem<H, ?>> boolean addItemIfSlotAvailable(JournalItemList<H> inventory, DefaultInventoryStateProvider<H> invState, H item) {
        if (invState.inventoryIsFull()) {
            return false;
        }
        HeldItem emptySlot = inventory.stream().filter(Item::isEmpty).findFirst().get();
        inventory.set(inventory.indexOf(emptySlot), item);
        return true;
    }

    @Nullable
    public static ContainerTarget<MCContainer, MCTownItem> setupForDropLoot(TownInterface town, ContainerTarget<MCContainer, MCTownItem> currentTarget, BlockPos pos, Collection<MCTownItem> itemsThatMustBeInserted) {
        Supplier<ContainerTarget> find = () -> TownContainers.findClosestMatching(town, MCTownItem::isEmpty, pos, itemsThatMustBeInserted);
        if (currentTarget != null) {
            if (!currentTarget.hasItem(MCTownItem::isEmpty)) {
                currentTarget = find.get();
            }
        } else {
            currentTarget = find.get();
        }
        return currentTarget;
    }

    public static boolean openInventoryAndStatusScreen(ServerPlayer sp, VisitorMobEntity e) {
        e.getTown().getVillagerHandle().showUI(sp, "inventory", e.m_20148_());
        return true;
    }

    public static void getOrCreateItemFromBlock(ServerLevel level, BlockPos b, TakeFn takeFn, MCHeldItem is, boolean nullifyExcess) {
        for (int i = 0; i < Compat.configGet(Config.BASE_MAX_LOOP).get() && !is.isEmpty(); ++i) {
            MCHeldItem oneOf = is.unit();
            if (takeFn == null || !takeFn.Take(oneOf)) {
                if (nullifyExcess) {
                    return;
                }
                level.m_7967_((Entity)new ItemEntity((Level)level, (double)b.m_123341_(), (double)b.m_123342_(), (double)b.m_123343_(), oneOf.toItem().toMCItemStack()));
            }
            is = is.shrink();
        }
    }

    public static boolean townHasSupplies(TownInterface town, ItemsHolder<MCHeldItem> journal, ImmutableList<? extends Predicate<MCTownItem>> isItemNeeded) {
        return town.findMatchingContainer(item -> JobsClean.shouldTakeItem(journal.getCapacity(), isItemNeeded, journal.getItems(), item)) != null;
    }

    public static boolean townHasSpace(TownInterface town) {
        return town.findMatchingContainer(MCTownItem::isEmpty) != null;
    }

    @Nullable
    public static EntityCurrentJobSite<MCRoom> getEntityCurrentJobSite(BlockPos entityBlockPos, RoomsNeedingVillagerInput<MCRoom, ResourceLocation, BlockPos> roomsNeedingIngredientsOrTools, Collection<MCRoom> roomsWithCompletedProduct) {
        EntityCurrentJobSite<MCRoom> in = JobsClean.getEntityCurrentJobSite(Positions.FromBlockPos((BlockPos)entityBlockPos), roomsNeedingIngredientsOrTools, roomsWithCompletedProduct, room -> room.yCoord > entityBlockPos.m_123342_() - 5 && room.yCoord < entityBlockPos.m_123342_() + 5, arg_0 -> ((ResourceLocation)SpecialQuests.FARM).equals(arg_0));
        return in;
    }

    public static boolean hasNonSupplyItems(ItemsHolder<MCHeldItem> journal, ImmutableList<Predicate<MCTownItem>> recipe) {
        return journal.getItems().stream().filter(Predicates.not(Item::isEmpty)).anyMatch(Predicates.not(v -> recipe.stream().anyMatch(z -> z.test(v.get()))));
    }

    public static boolean isUnfinishedTimeWorkPresent(RoomsHolder town, ResourceLocation workRoomId, Function<BlockPos, @Nullable Integer> ticksSource) {
        Collection<RoomRecipeMatch<MCRoom>> rooms = town.getRoomsMatching(workRoomId);
        return rooms.stream().anyMatch(v -> {
            for (Map.Entry e : v.getContainedBlocks().entrySet()) {
                @Nullable Integer apply = (Integer)ticksSource.apply((BlockPos)e.getKey());
                if (apply == null || apply <= 0) continue;
                return true;
            }
            return false;
        });
    }

    public static Collection<Integer> getStatesWithUnfinishedWork(Supplier<Collection<? extends Supplier<Collection<BlockPos>>>> town, Function<BlockPos, State> ticksSource, Predicate<BlockPos> canClaim) {
        Collection<? extends Supplier<Collection<BlockPos>>> rooms = town.get();
        HashSet b = new HashSet();
        rooms.forEach(v -> {
            for (BlockPos e : (Collection)v.get()) {
                State apply;
                if (!canClaim.test(e) || (apply = (State)ticksSource.apply(e)) == null || apply.workLeft() <= 0) continue;
                b.add(apply.processingState());
                return;
            }
        });
        ArrayList b2 = new ArrayList(b);
        Collections.sort(b2);
        return ImmutableList.copyOf(b2);
    }

    public static ImmutableMap<Integer, PredicateCollection<MCTownItem, MCTownItem>> unMC5(ImmutableMap<Integer, Ingredient> toolsRequiredAtStates) {
        ImmutableMap.Builder b = ImmutableMap.builder();
        toolsRequiredAtStates.forEach((k, v) -> b.put(k, PredicateCollection.wrap(new IPredicateCollection<MCTownItem>(){

            @Override
            public boolean isEmpty() {
                return v.m_43947_();
            }

            @Override
            public boolean test(MCTownItem mcTownItem) {
                return false;
            }

            public String toString() {
                return v.m_43942_().toString();
            }
        }, inner -> v.m_43947_(), (inner, item) -> v.test(item.toQTItemStack()), "Ingredient2Predicate")));
        return b.build();
    }

    public static ImmutableMap<Integer, PredicateCollection<MCHeldItem, MCHeldItem>> unMCHeld3(ImmutableMap<Integer, Ingredient> input) {
        ImmutableMap.Builder b = ImmutableMap.builder();
        input.forEach((k, v) -> b.put(k, PredicateCollections.fromMCIngredient2(v)));
        return b.build();
    }

    public static ImmutableMap<Integer, Predicate<MCHeldItem>> unTown(Map<Integer, ? extends Predicate<MCTownItem>> input) {
        ImmutableMap.Builder b = ImmutableMap.builder();
        input.forEach((k, v) -> b.put(k, z -> !z.isEmpty() && v.test(z.get())));
        return b.build();
    }

    public static Collection<RoomRecipeMatch<MCRoom>> roomsWithState(Collection<? extends IRoomRecipeMatch<MCRoom, ResourceLocation, BlockPos, Block>> rooms, Predicate<BlockPos> isCorrectBlock, Predicate<BlockPos> hasCorrectState) {
        return JobsClean.roomsWithState(rooms, isCorrectBlock, hasCorrectState).stream().map(RoomRecipeMatchUtils::unsafe).toList();
    }

    public static ImmutableList<MCHeldItem> getHeldItems(Job<MCHeldItem, ? extends ImmutableSnapshot<MCHeldItem, ?>, ? extends IStatus<?>> job) {
        Container inv = job.getInventory();
        return Jobs.getHeldItems(inv);
    }

    @NotNull
    public static ImmutableList<MCHeldItem> getHeldItems(Container inv) {
        ImmutableList.Builder b = ImmutableList.builder();
        for (int i = 0; i < inv.m_6643_(); ++i) {
            b.add((Object)MCHeldItem.fromMCItemStack(inv.m_8020_(i)));
        }
        return b.build();
    }

    public static JobID getIdFromNetwork(FriendlyByteBuf buf) {
        String rootId = buf.m_130277_();
        String jobId1 = buf.m_130277_();
        return new JobID(rootId, jobId1);
    }

    public static void writeIdToNetwork(FriendlyByteBuf buf, JobID job) {
        buf.m_130070_(job.rootId());
        buf.m_130070_(job.jobId());
    }

    public static ImmutableList<Component> getComponentsForTooltip(JobID job) {
        return ImmutableList.of((Object)Jobs.getRootNameComponent(job), (Object)Compat.literal(job.jobId()));
    }

    @NotNull
    public static Component getRootNameComponent(JobID job) {
        return Compat.translatable("jobs." + job.rootId());
    }

    public static String getNiceString(ImmutableList<JobID> value) {
        return value.stream().map(JobID::toNiceString).collect(Collectors.joining(","));
    }

    public static boolean tryDropLoot(LootDropper<MCHeldItem> dropper, BlockPos entityPos, ContainerTarget<? extends ContainerTarget.Container<MCTownItem>, MCTownItem> target) {
        UUID ownerUUID = dropper.UUID();
        if (!dropper.hasAnyLootToDrop()) {
            QT.JOB_LOGGER.trace("{} is not dropping because they only have food", (Object)ownerUUID);
            return false;
        }
        boolean farFromChest = !Jobs.isCloseTo(entityPos, target.getBlockPos());
        List snapshot = Lists.reverse((List)ImmutableList.copyOf(dropper.getItemsForDrop()));
        for (MCHeldItem mct : snapshot) {
            if (mct.isEmpty()) continue;
            if (mct.isLocked()) {
                QT.JOB_LOGGER.trace("Villager is not putting away {} because it is locked", (Object)mct.toShortString());
                continue;
            }
            if (((net.minecraft.world.item.Item)ItemsInit.KNOWLEDGE.get()).equals(mct.get().get())) {
                dropper.removeItem(mct);
                continue;
            }
            if (farFromChest) continue;
            QT.JOB_LOGGER.debug("Villager {} is putting {} in {} [{}]", (Object)UtilClean.truncateMiddle(ownerUUID.toString()), (Object)mct.getShortName(), (Object)target.getBlockPos(), (Object)mct.toShortString());
            boolean added = false;
            for (int i = 0; i < target.size() && !added; ++i) {
                if (!target.getItem(i).isEmpty()) continue;
                if (dropper.removeItem(mct)) {
                    target.setItem(i, mct.toItem());
                }
                added = true;
            }
            if (added) continue;
            QT.JOB_LOGGER.debug("Nope. No space for {}", (Object)mct.toShortString());
        }
        return true;
    }

    public static interface LootDropper<I> {
        public UUID UUID();

        public boolean shouldHoldAllItems();

        public boolean hasAnyLootToDrop();

        public Iterable<I> getItemsForDrop();

        public boolean removeItem(I var1);
    }
}

