/*
 * Decompiled with CFR 0.152.
 */
package ca.bradj.questown.jobs;

import ca.bradj.questown.jobs.GathererStatuses;
import ca.bradj.questown.jobs.HeldItem;
import ca.bradj.questown.jobs.Item;
import ca.bradj.questown.jobs.leaver.ContainerTarget;
import ca.bradj.questown.jobs.production.ProductionStatus;
import ca.bradj.questown.town.TownState;
import ca.bradj.questown.town.VillagerDataCollectionHolder;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Optional;
import java.util.Stack;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ProductionTimeWarper {
    public static <C extends ContainerTarget.Container<I>, I extends Item<I>, H extends HeldItem<H, I>> Collection<H> dropIntoContainers(ImmutableList<H> itemz, @NotNull ImmutableList<ContainerTarget<C, I>> containers) {
        Stack stack = new Stack();
        itemz.stream().filter(v -> !v.isEmpty() && !v.isLocked()).forEach(stack::add);
        block0: for (ContainerTarget container : containers) {
            if (stack.isEmpty()) {
                return ImmutableList.of();
            }
            if (container.isFull()) continue;
            for (int i = 0; i < container.size(); ++i) {
                if (!container.getItem(i).isEmpty()) continue;
                container.setItem(i, ((HeldItem)stack.pop()).get());
                if (stack.isEmpty()) continue block0;
            }
        }
        if (stack.isEmpty()) {
            return ImmutableList.of();
        }
        return ImmutableList.copyOf(stack);
    }

    public static <I extends Item<I>, H extends HeldItem<H, I>, TOWN extends TownState<?, I, H, ?, TOWN>> TOWN simulateDropLoot(TOWN inState, ProductionStatus status, int villagerIndex, Supplier<H> emptyFactory) {
        Collection<H> items = ProductionTimeWarper.getHeldItems(inState, villagerIndex);
        Result r = new Result(status, ImmutableList.copyOf(items));
        Function<ImmutableList, Collection> dropFn = itemz -> ProductionTimeWarper.dropIntoContainers(itemz, inState.containers);
        r = ProductionTimeWarper.simulateDropLoot(r, dropFn, emptyFactory);
        return (TOWN)((TownState)inState.withVillagerData(villagerIndex, ((TownState.VillagerData)inState.villagers.get(villagerIndex)).withItems(r.items())));
    }

    public static <H extends HeldItem<H, ?>> Collection<H> getHeldItems(VillagerDataCollectionHolder<H> mcTownState, int villagerIndex) {
        TownState.VillagerData<H> vil = mcTownState.getVillager(villagerIndex);
        return vil.journal.items();
    }

    @Nullable
    public static <I extends Item<I>, H extends HeldItem<H, I>, TOWN extends TownState<?, I, H, ?, TOWN>> TOWN simulateCollectSupplies(TOWN inState, int processingState, int villagerIndex, Map<Integer, ? extends Predicate<H>> ingrRequiredAtStates, Map<Integer, ? extends Predicate<H>> toolsRequiredAtStates, Function<I, H> grabber) {
        Predicate<H> fingr;
        Map.Entry<TOWN, Item> removeResult;
        Predicate<H> ingr = ingrRequiredAtStates.get(processingState);
        if (ingr == null) {
            Predicate<H> toolchk = toolsRequiredAtStates.get(processingState);
            if (toolchk == null) {
                throw new IllegalStateException("No ingredients or tools required at state " + processingState + ". We shouldn't be collecting.");
            }
            ingr = toolchk;
        }
        if ((removeResult = inState.withContainerItemRemoved(arg_0 -> ProductionTimeWarper.lambda$simulateCollectSupplies$2(fingr = ingr, grabber, arg_0))) == null) {
            return null;
        }
        TownState outState = (TownState)removeResult.getKey();
        TownState.VillagerData<HeldItem> villager = (TownState.VillagerData<HeldItem>)outState.villagers.get(villagerIndex);
        if ((villager = villager.withAddedItem((HeldItem)grabber.apply(removeResult.getValue()))) == null) {
            return null;
        }
        return (TOWN)((TownState)outState.withVillagerData(villagerIndex, villager));
    }

    static <I extends Item<I>, H extends HeldItem<H, I>> Result<H> simulateExtractProduct(ProductionStatus status, ImmutableList<H> heldItems, ItemToEntityMover<I, H> taker, Supplier<I> remover) {
        Optional<HeldItem> foundEmpty = heldItems.stream().filter(Item::isEmpty).findFirst();
        if (foundEmpty.isPresent()) {
            int idx = heldItems.indexOf((Object)foundEmpty.get());
            ArrayList<H> outItems = new ArrayList<H>(heldItems);
            outItems.set(idx, taker.copyFromTownWithoutRemoving((Item)remover.get()));
            return new Result(status, ImmutableList.copyOf(outItems));
        }
        throw new IllegalStateException(String.format("Got extract product with full inventory: %s", heldItems));
    }

    static <I extends Item<I>, H extends HeldItem<H, I> & Item<H>> Result<H> simulateDropLoot(Result<H> input, Function<ImmutableList<H>, ? extends Collection<H>> addToTownOrReturn, Supplier<H> emptyFactory) {
        if (input.items.isEmpty() || input.items.stream().allMatch(rec$ -> ((Item)rec$).isEmpty())) {
            throw new IllegalStateException("Got DROP_LOOT with empty inventory");
        }
        ImmutableList unlockedItems = ImmutableList.copyOf(input.items.stream().filter(v -> !v.isLocked()).toList());
        Iterator undeposited = addToTownOrReturn.apply(unlockedItems).stream().filter(Predicate.not(rec$ -> ((Item)rec$).isEmpty())).iterator();
        ImmutableList.Builder b = ImmutableList.builder();
        for (HeldItem item : input.items) {
            if (item.isLocked()) {
                b.add((Object)item);
                continue;
            }
            if (undeposited.hasNext()) {
                b.add((Object)((HeldItem)undeposited.next()));
                continue;
            }
            b.add((Object)((HeldItem)emptyFactory.get()));
        }
        return new Result(input.status, b.build());
    }

    public static long getNextDaySegment(long currentGameTime, long upTo) {
        if (currentGameTime == upTo) {
            return currentGameTime + 1L;
        }
        long daysPassed = currentGameTime / 24000L;
        long i = 24000L * daysPassed + ProductionTimeWarper.getNextSingleDaySegment(currentGameTime);
        return i;
    }

    private static long getNextSingleDaySegment(long currentGameTime) {
        long timeOfDay = currentGameTime % 24000L;
        if (timeOfDay < 10L) {
            return timeOfDay + 1L;
        }
        if (timeOfDay < 6000L) {
            return 6000L;
        }
        if (timeOfDay < 6010L) {
            return timeOfDay + 1L;
        }
        if (timeOfDay < 11500L) {
            return 11500L;
        }
        if (timeOfDay < 11510L) {
            return timeOfDay + 1L;
        }
        if (timeOfDay < 22000L) {
            return 22000L;
        }
        if (timeOfDay < 22010L) {
            return timeOfDay + 1L;
        }
        return 24000L;
    }

    private static /* synthetic */ boolean lambda$simulateCollectSupplies$2(Predicate fingr, Function grabber, Item i) {
        return fingr.test((HeldItem)grabber.apply(i));
    }

    public record Result<H>(ProductionStatus status, ImmutableList<H> items) {
    }

    public static interface ItemToEntityMover<I extends Item<I>, H extends HeldItem<H, I>> {
        public H copyFromTownWithoutRemoving(I var1);
    }

    public static interface Town<I extends Item<I>, H extends HeldItem<H, I>>
    extends GathererStatuses.TownStateProvider {
        public ImmutableList<H> depositItems(ImmutableList<H> var1);
    }

    public record JobNeeds<I>(ImmutableMap<Integer, Predicate<I>> ingredients) {
    }
}

