/*
 * Decompiled with CFR 0.152.
 */
package ca.bradj.questown.jobs;

import ca.bradj.questown.core.UtilClean;
import ca.bradj.questown.jobs.DeclarativeJobChecks;
import ca.bradj.questown.jobs.JobsClean;
import ca.bradj.questown.jobs.production.RoomsNeedingVillagerInput;
import ca.bradj.questown.logic.PredicateCollection;
import ca.bradj.questown.town.workstatus.State;
import ca.bradj.roomrecipes.adapter.IRoomRecipeMatch;
import ca.bradj.roomrecipes.adapter.RoomRecipeMatch;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;

public class RoomsStatusLogic {
    public static <EXTRA, RL, POS, HELD_ITEM, TOWN_ITEM, ROOM, MATCH extends IRoomRecipeMatch<ROOM, RL, POS, ?>> RoomsNeedingVillagerInput<ROOM, RL, POS> compute(Collection<MATCH> jobRooms, Function<POS, State> getJobBlockState, Predicate<POS> canClaim, Predicate<POS> isJobBlock, DeclarativeJobChecks<EXTRA, HELD_ITEM, TOWN_ITEM, RoomRecipeMatch<ROOM>, POS> checks, Function<MATCH, Collection<POS>> getContainedBlocks, int maxState) {
        HashMap b = new HashMap();
        for (Map.Entry<Integer, PredicateCollection<HELD_ITEM, HELD_ITEM>> e : checks.getAllRequiredIngredients().entrySet()) {
            Integer state = e.getKey();
            PredicateCollection<HELD_ITEM, HELD_ITEM> ingrs = e.getValue();
            if (ingrs.isEmpty()) {
                b.put(state, new ArrayList());
                break;
            }
            Collection<MATCH> matches = RoomsStatusLogic.roomsWithState(jobRooms, getJobBlockState, state, isJobBlock, s -> true);
            Integer stateQty = checks.getQuantityForStep(state, null);
            ArrayList<MATCH> rwwcbd = RoomsStatusLogic.getRoomsWhereWorkCanBeDone(getJobBlockState, canClaim, matches, stateQty, getContainedBlocks);
            UtilClean.addAllOrInitializeList(b, state, rwwcbd.stream().map(v -> new RoomsNeedingVillagerInput.NVIRoom(v, false)).toList());
        }
        HashMap<Integer, Object> stateTools = new HashMap<Integer, Object>();
        boolean requiresTools = false;
        Map<Integer, PredicateCollection<TOWN_ITEM, TOWN_ITEM>> rt = checks.getAllRequiredTools();
        if (rt.values().stream().anyMatch(v -> !v.isEmpty())) {
            for (int i = 0; i < maxState; ++i) {
                PredicateCollection<TOWN_ITEM, TOWN_ITEM> tool = RoomsStatusLogic.getToolOrDefault(rt, i);
                if (!tool.isEmpty()) {
                    requiresTools = true;
                }
                stateTools.put(i, tool);
            }
        }
        Set statesRequiringTools = stateTools.keySet();
        for (Integer state : statesRequiringTools) {
            for (int i = 0; i <= state; ++i) {
                Collection<MATCH> list = RoomsStatusLogic.roomsWithState(jobRooms, getJobBlockState, i, isJobBlock, s -> true);
                UtilClean.addAllOrInitializeList(b, state, list.stream().map(v -> new RoomsNeedingVillagerInput.NVIRoom(v, false)).toList());
            }
        }
        if (!requiresTools) {
            for (int i = 0; i < maxState; ++i) {
                Collection<MATCH> workable = RoomsStatusLogic.roomsWithState(jobRooms, getJobBlockState, i, isJobBlock, State::hasWorkLeft);
                UtilClean.addAllOrInitializeList(b, i, workable.stream().map(v -> new RoomsNeedingVillagerInput.NVIRoom(v, true)).toList());
            }
        }
        return new RoomsNeedingVillagerInput(ImmutableMap.copyOf(b));
    }

    private static <ROOM, POS, MATCH extends IRoomRecipeMatch<ROOM, ?, POS, ?>> Collection<MATCH> roomsWithState(Collection<MATCH> rooms, Function<POS, State> getJobBlockState, Integer state, Predicate<POS> isJobBlock, Predicate<State> extraCheck) {
        return JobsClean.roomsWithState(rooms, isJobBlock, bp -> {
            State jbs = (State)getJobBlockState.apply(bp);
            if (jbs == null) {
                return false;
            }
            return state.equals(jbs.processingState()) && extraCheck.test(jbs);
        });
    }

    private static <COLL extends PredicateCollection<?, ?>> COLL getToolOrDefault(Map<Integer, COLL> checks, int i) {
        PredicateCollection noToolDefined = PredicateCollection.empty("no tool defined");
        return (COLL)checks.getOrDefault(i, noToolDefined);
    }

    @NotNull
    private static <MATCH, POS> ArrayList<MATCH> getRoomsWhereWorkCanBeDone(Function<POS, State> work, Predicate<POS> canClaim, Collection<MATCH> matches, Integer stateQty, Function<MATCH, Collection<POS>> getContainedBlocks) {
        Stream<Object> roomz = matches.stream().filter(room -> {
            for (Object e : (Collection)getContainedBlocks.apply(room)) {
                State jobBlockState = (State)work.apply(e);
                if (jobBlockState == null || !canClaim.test(e) || jobBlockState.ingredientCount() >= stateQty) continue;
                return true;
            }
            return false;
        });
        ArrayList value = Lists.newArrayList(roomz.toList());
        return value;
    }
}

