/*
 * Decompiled with CFR 0.152.
 */
package ca.bradj.questown.jobs;

import ca.bradj.questown.core.Config;
import ca.bradj.questown.integration.minecraft.MCHeldItem;
import ca.bradj.questown.integration.minecraft.MCTownItem;
import ca.bradj.questown.integration.minecraft.MCTownState;
import ca.bradj.questown.jobs.DeclarativeJob;
import ca.bradj.questown.jobs.DeclarativeJobChecks;
import ca.bradj.questown.jobs.DeclarativeJobs;
import ca.bradj.questown.jobs.ExpirationRules;
import ca.bradj.questown.jobs.IStatus;
import ca.bradj.questown.jobs.ImmutableSnapshot;
import ca.bradj.questown.jobs.Job;
import ca.bradj.questown.jobs.JobID;
import ca.bradj.questown.jobs.Jobs;
import ca.bradj.questown.jobs.MCTownStateWorldInteraction;
import ca.bradj.questown.jobs.SimpleSnapshot;
import ca.bradj.questown.jobs.Work;
import ca.bradj.questown.jobs.WorkDescription;
import ca.bradj.questown.jobs.WorkLocation;
import ca.bradj.questown.jobs.WorkSpecialRules;
import ca.bradj.questown.jobs.WorkStates;
import ca.bradj.questown.jobs.WorkWorldInteractions;
import ca.bradj.questown.jobs.declarative.SoundInfo;
import ca.bradj.questown.jobs.declarative.nomc.WorkSeekerJob;
import ca.bradj.questown.jobs.fetcher.FetcherHack;
import ca.bradj.questown.jobs.gatherer.GathererTools;
import ca.bradj.questown.jobs.production.ProductionStatus;
import ca.bradj.questown.logic.PredicateCollection;
import ca.bradj.questown.town.Claim;
import ca.bradj.questown.town.Warper;
import ca.bradj.roomrecipes.adapter.RoomRecipeMatch;
import ca.bradj.roomrecipes.serialization.MCRoom;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import org.apache.commons.lang3.function.TriFunction;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class WorksBehaviour {
    public static Warper<ServerLevel, MCTownState> productionWarper(BlockPos townPos, JobID id, WarpInput warpInput, boolean prioritizeExtraction, Function<MCTownStateWorldInteraction.Inputs, Claim> claimSpots, int pauseForAction, WorkStates states, BiFunction<ServerLevel, Collection<MCHeldItem>, Iterable<MCHeldItem>> resultGenerator, Map<ProductionStatus, Collection<String>> specialRules) {
        MCTownStateWorldInteraction wi = new MCTownStateWorldInteraction(townPos, id, warpInput.villagerIndex(), pauseForAction, states.maxState(), WorksBehaviour.fromStates(states), resultGenerator, claimSpots, specialRules);
        return DeclarativeJobs.warper(wi, states.maxState(), prioritizeExtraction);
    }

    private static DeclarativeJobChecks<MCTownStateWorldInteraction.Inputs, MCHeldItem, MCTownItem, RoomRecipeMatch<MCRoom>, BlockPos> fromStates(WorkStates states) {
        return new DeclarativeJobChecks<MCTownStateWorldInteraction.Inputs, MCHeldItem, MCTownItem, RoomRecipeMatch<MCRoom>, BlockPos>((Map<Integer, PredicateCollection<MCHeldItem, MCHeldItem>>)Jobs.unMCHeld3(states.ingredientsRequired()), (Map<Integer, Integer>)states.ingredientQtyRequired(), (Map<Integer, PredicateCollection<MCTownItem, MCTownItem>>)Jobs.unMC5(states.toolsRequired()), (Map<Integer, Integer>)states.workRequired(), (Map<Integer, Integer>)states.timeRequired(), (Predicate<RoomRecipeMatch<MCRoom>>)((Predicate<RoomRecipeMatch>)r -> true), b -> true);
    }

    public static BiFunction<ServerLevel, Collection<MCHeldItem>, Iterable<MCHeldItem>> noOutput() {
        return (s, j) -> ImmutableSet.of();
    }

    public static WorkSpecialRules standardProductionRules() {
        return new WorkSpecialRules((ImmutableMap<ProductionStatus, Collection<String>>)ImmutableMap.of(), (ImmutableList<String>)ImmutableList.of((Object)"prioritize_extraction", (Object)"shared_work_status"));
    }

    public static Function<TownData, ImmutableSet<MCTownItem>> standardProductionResult(Supplier<ItemStack> result) {
        return t -> {
            ItemStack i = (ItemStack)result.get();
            return i == null ? ImmutableSet.of() : ImmutableSet.of((Object)MCTownItem.fromMCItemStack(i));
        };
    }

    public static WorkDescription standardDescription(Supplier<@Nullable ItemStack> result) {
        return new WorkDescription(WorksBehaviour.standardProductionResult(result), result.get());
    }

    public static WorkDescription noResultDescription() {
        return new WorkDescription(td -> ImmutableSet.of((Object)MCTownItem.Air()), null);
    }

    public static Work productionWork(ItemStack icon, JobID jobId, JobID parentId, WorkDescription description, WorkLocation location, WorkStates state, WorkWorldInteractions world, WorkSpecialRules special, @Nullable SoundInfo workSound) {
        return WorksBehaviour.productionWork(parentId, icon, jobId, description, location, state, world, special, workSound, WorksBehaviour.productionExpiration());
    }

    public static Work productionWork(JobID parentID, ItemStack icon, JobID jobId, WorkDescription description, WorkLocation location, WorkStates states, WorkWorldInteractions world, WorkSpecialRules special, @Nullable SoundInfo workSound, ExpirationRules expiration) {
        return new Work(jobId, parentID, icon, uuid -> new DeclarativeJob((UUID)uuid, 6, jobId, location, states.maxState(), world.actionDuration(), states.ingredientsRequired(), states.ingredientQtyRequired(), states.toolsRequired(), states.workRequired(), states.timeRequired(), special.specialStatusRules(), special.specialGlobalRules(), expiration, world.resultGenerator()::generate, workSound), WorksBehaviour.productionJobSnapshot(jobId), location.isJobBlock(), location.shouldInitializeWorkState(), location.baseRoom(), ProductionStatus.FACTORY.idle(), description.currentlyPossibleResults(), description.initialRequest(), items -> WorksBehaviour.getProductionNeeds(jobId, states, items), warpInput -> WorksBehaviour.productionWarper(warpInput.townFlagPos(), jobId, warpInput, special.containsGlobal("prioritize_extraction"), inputs -> {
            if (!special.containsGlobal("claim_spot")) {
                return null;
            }
            return new Claim(inputs.vUUID(), (Long)Config.BLOCK_CLAIMS_TICK_LIMIT.get());
        }, world.actionDuration(), states, world.resultGenerator()::generate, special.specialStatusRules()), 1, world.resultGenerator().isResultAlwaysEmpty());
    }

    @NotNull
    private static List<Ingredient> getProductionNeeds(JobID jobId, WorkStates states, List<MCHeldItem> heldItems) {
        if (FetcherHack.isFetcher(jobId)) {
            return FetcherHack.getProductionNeeds(heldItems);
        }
        return WorksBehaviour.getProductionNeeds(states.ingredientsRequired(), states.toolsRequired());
    }

    @NotNull
    public static ExpirationRules productionExpiration() {
        return new ExpirationRules(() -> Config.MAX_INITIAL_TICKS_WITHOUT_SUPPLIES.get(), () -> Config.MAX_TICKS_WITHOUT_SUPPLIES.get(), WorkSeekerJob::getIDForRoot, () -> 3000L, jobId -> jobId);
    }

    @NotNull
    public static SnapshotFunc productionJobSnapshot(JobID id) {
        return (jobId, status, items) -> new SimpleSnapshot(id, ProductionStatus.fromNumber(status), items);
    }

    @NotNull
    public static List<Ingredient> getProductionNeeds(ImmutableMap<Integer, Ingredient> ing, ImmutableMap<Integer, Ingredient> tools) {
        ImmutableList.Builder b = ImmutableList.builder();
        ing.values().forEach(arg_0 -> ((ImmutableList.Builder)b).add(arg_0));
        tools.values().forEach(arg_0 -> ((ImmutableList.Builder)b).add(arg_0));
        return b.build();
    }

    public record WarpInput(int villagerIndex, BlockPos townFlagPos) {
    }

    public static interface JobFunc
    extends Function<UUID, Job<MCHeldItem, ? extends ImmutableSnapshot<MCHeldItem, ?>, ? extends IStatus<?>>> {
    }

    public static interface SnapshotFunc
    extends TriFunction<JobID, String, ImmutableList<MCHeldItem>, ImmutableSnapshot<MCHeldItem, ?>> {
    }

    public record TownData(Function<GathererTools.LootTablePrefix, ImmutableSet<MCTownItem>> allKnownGatherItemsFn) {
    }
}

