/*
 * Decompiled with CFR 0.152.
 */
package ca.bradj.questown.jobs.declarative;

import ca.bradj.questown.jobs.WorkSpot;
import ca.bradj.questown.jobs.WorkedSpot;
import ca.bradj.questown.jobs.declarative.WorkChecks;
import ca.bradj.questown.logic.PredicateCollection;
import ca.bradj.questown.town.workstatus.State;
import java.util.function.BiConsumer;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractWorkWI<POS, EXTRA, ITEM, TOWN> {
    private final BiConsumer<EXTRA, WorkSpot<Integer, POS>> preStateChangeCallback;
    private final WorkChecks<EXTRA, ITEM> checks;

    public AbstractWorkWI(WorkChecks<EXTRA, ITEM> checks, BiConsumer<EXTRA, WorkSpot<Integer, POS>> preStateChangeCallback) {
        this.checks = checks;
        this.preStateChangeCallback = preStateChangeCallback;
    }

    public TOWN tryWork(EXTRA extra, WorkedSpot<POS> ws, boolean degradeTool) {
        TOWN updatedTown;
        POS bp = ws.workPosition();
        Integer curState = ws.state();
        int nextStepWork = this.checks.getWorkForStep(curState + 1, 0);
        Integer nextStepTime = this.checks.getTimeForStep(extra, curState + 1);
        if (nextStepTime == null) {
            nextStepTime = 0;
        }
        boolean didWork = (updatedTown = this.applyWork(extra, bp, curState, nextStepWork, nextStepTime)) != null;
        PredicateCollection<ITEM, ?> itemBooleanFunction = this.checks.getToolsForStep(curState);
        if (degradeTool && didWork && itemBooleanFunction != null) {
            return this.degradeTool(extra, updatedTown, itemBooleanFunction);
        }
        return updatedTown;
    }

    protected abstract TOWN degradeTool(EXTRA var1, @Nullable TOWN var2, PredicateCollection<ITEM, ?> var3);

    @Nullable
    private TOWN applyWork(EXTRA extra, POS bp, int curState, int nextStepWork, int nextStepTime) {
        State oldState = this.getJobBlockState(extra, bp);
        if (oldState == null) {
            oldState = this.initForState(curState);
        }
        State bs = oldState.decrWork(this.getWorkSpeedOf10(extra));
        if (oldState.hasWorkLeft() && oldState.equals(bs)) {
            return null;
        }
        if (!bs.hasWorkLeft()) {
            this.preStateChangeCallback.accept(extra, new WorkSpot<Integer, POS>(bp, curState, 0, bp));
            bs = bs.incrProcessing().setWorkLeft(nextStepWork).setCount(0);
        }
        if (nextStepTime <= 0) {
            return this.setJobBlockState(extra, bp, bs);
        }
        return this.setJobBlockStateWithTimer(extra, bp, bs, nextStepTime);
    }

    protected abstract TOWN setJobBlockStateWithTimer(EXTRA var1, POS var2, State var3, int var4);

    protected abstract TOWN setJobBlockState(EXTRA var1, POS var2, State var3);

    protected abstract State getJobBlockState(EXTRA var1, POS var2);

    protected abstract int getWorkSpeedOf10(EXTRA var1);

    private State initForState(Integer curState) {
        int work = this.checks.getWorkForStep(curState, 0);
        return State.fresh().setWorkLeft(work).setProcessing(curState);
    }
}

