/*
 * Decompiled with CFR 0.152.
 */
package ca.bradj.questown.jobs.declarative;

import ca.bradj.questown.QT;
import ca.bradj.questown.items.EffectMetaItem;
import ca.bradj.questown.items.KnowledgeMetaItem;
import ca.bradj.questown.jobs.DeclarativeJobChecks;
import ca.bradj.questown.jobs.HeldItem;
import ca.bradj.questown.jobs.Item;
import ca.bradj.questown.jobs.JobID;
import ca.bradj.questown.jobs.WorkOutput;
import ca.bradj.questown.jobs.WorkPosition;
import ca.bradj.questown.jobs.WorkSpot;
import ca.bradj.questown.jobs.WorkedSpot;
import ca.bradj.questown.jobs.declarative.AbstractItemWI;
import ca.bradj.questown.jobs.declarative.AbstractWorkWI;
import ca.bradj.questown.jobs.declarative.InsertResult;
import ca.bradj.questown.jobs.declarative.ItemWorkChecks;
import ca.bradj.questown.jobs.declarative.NeedsRegistrations;
import ca.bradj.questown.jobs.declarative.Preferred;
import ca.bradj.questown.jobs.declarative.WithReason;
import ca.bradj.questown.jobs.production.ProductionStatus;
import ca.bradj.questown.logic.PredicateCollection;
import ca.bradj.questown.mc.Util;
import ca.bradj.questown.town.AbstractWorkStatusStore;
import ca.bradj.questown.town.Claim;
import ca.bradj.questown.town.interfaces.ImmutableWorkStateContainer;
import ca.bradj.questown.town.workstatus.State;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import org.apache.logging.log4j.util.TriConsumer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractWorldInteraction<EXTRA, POS, INNER_ITEM extends Item<INNER_ITEM>, HELD_ITEM extends HeldItem<HELD_ITEM, INNER_ITEM>, TOWN>
implements AbstractWorkStatusStore.InsertionRules<HELD_ITEM> {
    private final AbstractItemWI<POS, EXTRA, HELD_ITEM, TOWN> itemWI;
    private final AbstractWorkWI<POS, EXTRA, INNER_ITEM, TOWN> workWI;
    private final NeedsRegistrations<POS, EXTRA> needsReg;
    protected final int villagerIndex;
    private final Function<EXTRA, Claim> claimSpots;
    protected final DeclarativeJobChecks<EXTRA, HELD_ITEM, INNER_ITEM, ?, POS> checks;
    private final JobID jobId;
    protected int ticksSinceLastAction;
    public final int interval;
    protected final int maxState;
    private final List<Consumer<JobID>> jobCompletedListeners = new ArrayList<Consumer<JobID>>();
    private WithReason<@Nullable WorkPosition<POS>> workspot = new WithReason<Object>(null, "Never set");
    private final ImmutableMap<ProductionStatus, Collection<String>> specialRules;
    private final List<BiConsumer<EXTRA, POS>> extractionListeners = new ArrayList<BiConsumer<EXTRA, POS>>();

    public <S, T> AbstractWorldInteraction(JobID jobId, int villagerIndex, int interval, int maxState, DeclarativeJobChecks<EXTRA, HELD_ITEM, INNER_ITEM, ?, POS> checks, Function<EXTRA, Claim> claimSpots, Map<ProductionStatus, Collection<String>> specialRules) {
        this.jobId = jobId;
        if (checks.isInsufficient()) {
            QT.JOB_LOGGER.error("{} requires no tools, work, time, or ingredients. This will lead to strange game behaviour.", (Object)jobId);
        }
        this.needsReg = new NeedsRegistrations<Object, Object>(this::registerUnmetRoom, this::registerUnmetNeed, this::getJobBlockState);
        this.checks = checks;
        this.villagerIndex = villagerIndex;
        this.interval = interval;
        this.maxState = maxState;
        this.specialRules = ImmutableMap.copyOf(specialRules);
        final AbstractWorldInteraction self = this;
        ItemWorkChecks<EXTRA, HELD_ITEM, INNER_ITEM> itemChecks = this.asItemChecks();
        this.itemWI = new AbstractItemWI<POS, EXTRA, HELD_ITEM, TOWN>(villagerIndex, itemChecks, claimSpots){

            @Override
            protected TOWN setHeldItem(EXTRA uxtra, TOWN tuwn, int villagerIndex, int itemIndex, HELD_ITEM item) {
                return self.setHeldItem(uxtra, tuwn, villagerIndex, itemIndex, item);
            }

            @Override
            protected Collection<HELD_ITEM> getHeldItems(EXTRA extra, int villagerIndex) {
                return self.getHeldItems(extra, villagerIndex);
            }

            @Override
            protected ImmutableWorkStateContainer<POS, TOWN> getWorkStatuses(EXTRA extra) {
                return self.getWorkStatuses(extra);
            }

            @Override
            protected boolean canInsertItem(EXTRA extra, HELD_ITEM item, POS bp) {
                return self.canInsertItem(extra, item, bp);
            }
        };
        this.workWI = new AbstractWorkWI<POS, EXTRA, INNER_ITEM, TOWN>(itemChecks, this::preStateChangeHooks){

            @Override
            protected TOWN degradeTool(EXTRA extra, @Nullable TOWN tuwn, PredicateCollection<INNER_ITEM, ?> heldItemBooleanFunction) {
                return self.degradeTool(extra, tuwn, heldItemBooleanFunction);
            }

            @Override
            protected TOWN setJobBlockStateWithTimer(EXTRA extra, POS bp, State bs, int nextStepTime) {
                return AbstractWorldInteraction.this.getWorkStatuses(extra).setJobBlockStateWithTimer(bp, bs, nextStepTime);
            }

            @Override
            protected TOWN setJobBlockState(EXTRA extra, POS bp, State bs) {
                return AbstractWorldInteraction.this.getWorkStatuses(extra).setJobBlockState(bp, bs);
            }

            @Override
            protected State getJobBlockState(EXTRA extra, POS bp) {
                return self.getWorkStatuses(extra).getJobBlockState(bp);
            }

            @Override
            protected int getWorkSpeedOf10(EXTRA extra) {
                return self.getWorkSpeedOf10(extra);
            }
        };
        this.claimSpots = claimSpots;
    }

    private ItemWorkChecks<EXTRA, HELD_ITEM, INNER_ITEM> asItemChecks() {
        return new ItemWorkChecks<EXTRA, HELD_ITEM, INNER_ITEM>(){

            @Override
            public boolean isWorkRequiredAtStep(int action) {
                return AbstractWorldInteraction.this.checks.isWorkRequiredAtStep(action);
            }

            @Override
            @Nullable
            public Integer getQuantityForStep(int i, @Nullable Integer orDefault) {
                return AbstractWorldInteraction.this.checks.getQuantityForStep(i, orDefault);
            }

            @Override
            @Nullable
            public PredicateCollection<HELD_ITEM, HELD_ITEM> getIngredientsForStep(int i) {
                return AbstractWorldInteraction.this.checks.getIngredientsForStep(i);
            }

            @Override
            public int getWorkForStep(int stepState, int orDefault) {
                return AbstractWorldInteraction.this.checks.getWorkForStep(stepState, orDefault);
            }

            @Override
            @Nullable
            public Integer getWorkForStep(int stepState) {
                return AbstractWorldInteraction.this.checks.getWorkForStep(stepState);
            }

            @Override
            @Nullable
            public Integer getTimeForStep(EXTRA extra, int stepState) {
                Integer timeForStep = AbstractWorldInteraction.this.checks.getTimeForStep(extra, stepState);
                if (timeForStep == null) {
                    return null;
                }
                return AbstractWorldInteraction.this.getAffectedTime(extra, timeForStep);
            }

            @Override
            public int getTimeForStep(EXTRA extra, int stepState, int orDefault) {
                @Nullable Integer v = this.getTimeForStep(extra, stepState);
                return v == null ? 0 : v;
            }

            @Override
            public PredicateCollection<INNER_ITEM, ?> getToolsForStep(Integer curState) {
                return AbstractWorldInteraction.this.checks.getToolsForStep(curState);
            }
        };
    }

    protected TOWN tryGiveItems(EXTRA inputs, Iterable<HELD_ITEM> newItemsSource, POS sourcePos) {
        Function<TOWN, TOWN> reset = this.getResetFunc(inputs, sourcePos);
        Stack<HeldItem> stack = new Stack<HeldItem>();
        this.iterate(newItemsSource, stack::push);
        TOWN ts = this.getTown(inputs);
        if (stack.isEmpty()) {
            QT.JOB_LOGGER.error("No results during extraction phase. That's probably a bug. Town State: {}", ts);
            return reset.apply(ts);
        }
        boolean gotAll = false;
        int i = -1;
        for (HeldItem item : this.getHeldItems(inputs, this.villagerIndex)) {
            ++i;
            if (!item.isEmpty()) continue;
            HeldItem newItem = (HeldItem)stack.pop();
            if (this.isMulti(newItem.get())) {
                stack.push((HeldItem)newItem.shrink());
            }
            if (this.isInstanze(newItem.get(), KnowledgeMetaItem.class)) {
                ts = this.withKnowledge(inputs, ts, newItem);
            } else if (this.isInstanze(newItem.get(), EffectMetaItem.class)) {
                ts = this.withEffectApplied(inputs, ts, newItem);
            } else {
                HeldItem unit = (HeldItem)newItem.unit();
                ts = this.postExtractHook(inputs, unit);
                ts = this.setHeldItem(inputs, ts, this.villagerIndex, i, unit);
                QT.VILLAGER_LOGGER.debug("Villager took {}", (Object)unit.toShortString());
            }
            if (!stack.isEmpty()) continue;
            gotAll = true;
            break;
        }
        if (!gotAll) {
            QT.VILLAGER_LOGGER.debug("Villager ran out of room before extracting all possible items");
        }
        return reset.apply(ts);
    }

    protected abstract void iterate(Iterable<HELD_ITEM> var1, Function<HELD_ITEM, HELD_ITEM> var2);

    @NotNull
    private Function<TOWN, TOWN> getResetFunc(EXTRA inputs, POS workSpot) {
        Function<Object, Object> reset = ts -> {
            ts = this.setJobBlockState(inputs, ts, workSpot, State.fresh());
            this.getWorkStatuses(inputs).clearClaim(workSpot);
            return ts;
        };
        return reset;
    }

    protected abstract int getWorkSpeedOf10(EXTRA var1);

    protected abstract int getAffectedTime(EXTRA var1, Integer var2);

    protected abstract TOWN setHeldItem(EXTRA var1, TOWN var2, int var3, int var4, HELD_ITEM var5);

    protected abstract TOWN degradeTool(EXTRA var1, @Nullable TOWN var2, PredicateCollection<INNER_ITEM, ?> var3);

    protected abstract boolean canInsertItem(EXTRA var1, HELD_ITEM var2, POS var3);

    protected abstract ImmutableWorkStateContainer<POS, TOWN> getWorkStatuses(EXTRA var1);

    public WorkOutput<TOWN, WorkPosition<POS>> tryWorking(EXTRA extra, Preferred<WorkPosition<POS>> workSpots) {
        ArrayList<WorkPosition<POS>> shuffled = this.shuffle(extra, workSpots.alternates());
        if (workSpots.preferredValue() != null) {
            shuffled.removeIf(v -> v.equals(workSpots.preferredValue()));
            shuffled.add(0, workSpots.preferredValue());
        }
        for (WorkPosition<POS> workSpot : shuffled) {
            WorkOutput<TOWN, WorkPosition<POS>> v2 = this.tryWorking(extra, workSpot);
            if (v2 == null || !v2.worked() && !v2.claimed()) continue;
            return this.getWithSurfaceInteractionPos(extra, v2);
        }
        return this.getWithSurfaceInteractionPos(extra, new WorkOutput<Object, WorkPosition>(false, false, null, (WorkPosition)ImmutableList.copyOf(shuffled).get(0)));
    }

    protected abstract WorkOutput<TOWN, WorkPosition<POS>> getWithSurfaceInteractionPos(EXTRA var1, WorkOutput<TOWN, WorkPosition<POS>> var2);

    protected abstract ArrayList<WorkPosition<POS>> shuffle(EXTRA var1, Collection<WorkPosition<POS>> var2);

    @Nullable
    public @Nullable WorkOutput<@Nullable TOWN, WorkPosition<POS>> tryWorking(EXTRA extra, WorkPosition<POS> workSpot) {
        int work;
        Collection<HELD_ITEM> items;
        boolean foundTool;
        if (!this.isReady(extra)) {
            return null;
        }
        boolean canClaim = this.getWorkStatuses(extra).canClaim(workSpot.jobBlock(), () -> this.claimSpots.apply(extra));
        ++this.ticksSinceLastAction;
        if (this.ticksSinceLastAction < this.interval) {
            if (canClaim) {
                return new WorkOutput<Object, WorkPosition<POS>>(false, true, null, workSpot);
            }
            return null;
        }
        this.ticksSinceLastAction = 0;
        if (!canClaim) {
            return null;
        }
        WorkOutput<Object, WorkPosition<POS>> vNull = new WorkOutput<Object, WorkPosition<POS>>(false, true, null, workSpot);
        if (!this.isEntityClose(extra, workSpot.jobBlock())) {
            return vNull;
        }
        ImmutableWorkStateContainer<POS, TOWN> workStatuses = this.getWorkStatuses(extra);
        State jobBlockState = workStatuses.getJobBlockState(workSpot.jobBlock());
        int action = Util.withFallbackForNullInput(jobBlockState, State::processingState, 0);
        if (action >= this.maxState && jobBlockState != null && jobBlockState.workLeft() == 0) {
            TOWN ex = this.tryExtractProduct(extra, workSpot.jobBlock());
            return new WorkOutput<TOWN, WorkPosition<POS>>(true, true, ex, workSpot);
        }
        PredicateCollection tool = this.checks.getToolsForStep(action);
        if (tool != null && !tool.isEmpty() && !(foundTool = (items = this.getHeldItems(extra, this.villagerIndex)).stream().anyMatch(i -> tool.test((Object)i.get())))) {
            return vNull;
        }
        TOWN initTown = this.getTown(extra);
        PredicateCollection<HELD_ITEM, HELD_ITEM> ingredientsForStep = this.checks.getIngredientsForStep(action);
        if (ingredientsForStep != null && !ingredientsForStep.isEmpty()) {
            WorkedSpot<POS> wsBefore = this.getCurWorkedSpot(extra, initTown, workSpot.jobBlock());
            InsertResult<TOWN, HELD_ITEM> o = this.itemWI.tryInsertIngredients(extra, ingredientsForStep, wsBefore);
            if (o == null) {
                int quantityWanted = this.checks.getQuantityForStep(action, 0);
                if (jobBlockState != null && jobBlockState.ingredientCount() < quantityWanted) {
                    return new WorkOutput<TOWN, WorkPosition<POS>>(false, true, initTown, workSpot);
                }
            } else {
                TOWN ctx = o.contextAfterInsert();
                HeldItem item = (HeldItem)o.itemBeforeInsert();
                @Nullable TOWN out = this.postInsertHook(ctx, extra, this.getCurWorkedSpot(extra, ctx, workSpot.jobBlock()).withBefore(wsBefore.state()), item, this.maxState);
                if (out == null) {
                    out = ctx;
                }
                return new WorkOutput<TOWN, WorkPosition<POS>>(true, true, out, workSpot);
            }
        }
        if (jobBlockState == null) {
            jobBlockState = State.fresh();
        }
        if (this.checks.isWorkRequiredAtStep(action) && (work = this.checks.getWorkForStep(action, 0)) > 0 && action == 0 && jobBlockState.workLeft() == 0) {
            TOWN town = workStatuses.setJobBlockState(workSpot.jobBlock(), jobBlockState.setWorkLeft(work));
            return new WorkOutput<TOWN, WorkPosition<POS>>(false, true, town, workSpot);
        }
        TOWN town = this.workWI.tryWork(extra, this.getCurWorkedSpot(extra, initTown, workSpot.jobBlock()), jobBlockState.workLeft() <= 1);
        return new WorkOutput<TOWN, WorkPosition<POS>>(town != null, town != null, town, workSpot);
    }

    protected abstract WorkedSpot<POS> getCurWorkedSpot(EXTRA var1, TOWN var2, POS var3);

    protected abstract Collection<HELD_ITEM> getHeldItems(EXTRA var1, int var2);

    @Override
    @Nullable
    public Integer getIngredientQuantityRequiredAtState(int state, @Nullable Integer orDefault) {
        return this.checks.getQuantityForStep(state, 0);
    }

    protected TOWN tryExtractProduct(@NotNull EXTRA inputs, POS position) {
        State s = this.getJobBlockState(inputs, position);
        if (s != null && s.processingState() >= this.maxState) {
            Collection<HELD_ITEM> items;
            Iterable<HELD_ITEM> generatedResult;
            TOWN town = this.preExtractHook(inputs, position);
            if (town != null) {
                Function<TOWN, TOWN> resetFunc = this.getResetFunc(inputs, position);
                town = resetFunc.apply(town);
            } else {
                this.getResetFunc(inputs, position).apply(this.getTown(inputs));
            }
            if (town == null && (town = this.tryGiveItems(inputs, generatedResult = this.getResults(inputs, items = this.getHeldItems(inputs, this.villagerIndex)), position)) != null && ImmutableList.copyOf(generatedResult).stream().anyMatch(v -> !v.isEmpty())) {
                this.extractionListeners.forEach(l -> l.accept(inputs, position));
            }
            if (town != null) {
                this.triggerCompletionAdvancement(inputs, position);
                this.jobCompletedListeners.forEach(r -> r.accept(this.jobId));
            }
            return town;
        }
        return null;
    }

    protected abstract void triggerCompletionAdvancement(EXTRA var1, POS var2);

    private void preStateChangeHooks(EXTRA inputs, WorkSpot<Integer, POS> position) {
        Collection rules = (Collection)this.specialRules.get((Object)ProductionStatus.fromJobBlockStatus(position.action()));
        if (rules == null || rules.isEmpty()) {
            return;
        }
        this.preStateChangeHooks(this.getTown(inputs), rules, inputs, position);
    }

    protected abstract void preStateChangeHooks(@NotNull TOWN var1, Collection<String> var2, EXTRA var3, WorkSpot<Integer, POS> var4);

    @Nullable
    private TOWN postInsertHook(@NotNull TOWN ctx, EXTRA inputs, WorkedSpot<POS> position, HELD_ITEM item, int maxState) {
        ProductionStatus o = ProductionStatus.fromJobBlockStatus(position.previousState(), maxState);
        Collection rules = (Collection)this.specialRules.get((Object)o);
        if (rules == null || rules.isEmpty()) {
            return ctx;
        }
        return this.postInsertHook(this.getTown(inputs), rules, inputs, position, item);
    }

    @Nullable
    protected abstract TOWN postInsertHook(@NotNull TOWN var1, Collection<String> var2, EXTRA var3, WorkedSpot<POS> var4, HELD_ITEM var5);

    @Nullable
    private TOWN preExtractHook(EXTRA inputs, POS position) {
        Collection rules = (Collection)this.specialRules.get((Object)ProductionStatus.EXTRACTING_PRODUCT);
        if (rules == null || rules.isEmpty()) {
            return null;
        }
        return this.preExtractHook(this.getTown(inputs), rules, inputs, position);
    }

    @Nullable
    private TOWN postExtractHook(EXTRA inputs, HELD_ITEM item) {
        Collection rules = (Collection)this.specialRules.get((Object)ProductionStatus.EXTRACTING_PRODUCT);
        if (rules == null || rules.isEmpty()) {
            return null;
        }
        return this.postExtractHook(this.getTown(inputs), rules, inputs, this.getTownPos(inputs), item);
    }

    protected abstract POS getTownPos(EXTRA var1);

    @Nullable
    protected abstract TOWN preExtractHook(TOWN var1, Collection<String> var2, EXTRA var3, POS var4);

    protected abstract TOWN postExtractHook(TOWN var1, Collection<String> var2, EXTRA var3, POS var4, HELD_ITEM var5);

    protected abstract TOWN setJobBlockState(@NotNull EXTRA var1, TOWN var2, POS var3, State var4);

    protected abstract TOWN withEffectApplied(@NotNull EXTRA var1, TOWN var2, HELD_ITEM var3);

    protected abstract TOWN withKnowledge(@NotNull EXTRA var1, TOWN var2, HELD_ITEM var3);

    protected abstract boolean isInstanze(INNER_ITEM var1, Class<?> var2);

    protected abstract boolean isMulti(INNER_ITEM var1);

    protected abstract TOWN getTown(EXTRA var1);

    protected abstract Iterable<HELD_ITEM> getResults(EXTRA var1, Collection<HELD_ITEM> var2);

    protected abstract boolean isEntityClose(EXTRA var1, POS var2);

    protected abstract boolean isReady(EXTRA var1);

    @Nullable
    State getJobBlockState(EXTRA extra, POS bp) {
        return this.itemWI.getWorkStatuses(extra).getJobBlockState(bp);
    }

    public void addItemInsertionListener(TriConsumer<EXTRA, POS, HELD_ITEM> listener) {
        this.itemWI.addItemInsertionListener(listener);
    }

    public void addItemExtractionListener(BiConsumer<EXTRA, POS> listener) {
        this.extractionListeners.add(listener);
    }

    public void removeItemInsertionListener(TriConsumer<EXTRA, POS, HELD_ITEM> listener) {
        this.itemWI.removeItemInsertionListener(listener);
    }

    public void addJobCompletionListener(Consumer<JobID> listener) {
        this.jobCompletedListeners.add(listener);
    }

    public void removeJobCompletionListener(Consumer<JobID> listener) {
        this.jobCompletedListeners.remove(listener);
    }

    public abstract boolean tryGrabbingInsertedSupplies(EXTRA var1);

    public abstract boolean hasInserted(EXTRA var1);

    @Nullable
    public WorkPosition<POS> getWorkSpot() {
        return (WorkPosition)this.workspot.value;
    }

    public void setWorkSpot(WithReason<@Nullable WorkPosition<POS>> o) {
        this.workspot = o;
    }

    @Override
    @Nullable
    public PredicateCollection<HELD_ITEM, ?> getIngredientsRequiredAtState(Integer state) {
        return this.checks.getIngredientsForStep(state);
    }

    public void registerUnmetNeeds(EXTRA extra, @Nullable POS workspot, boolean hasInserted) {
        this.needsReg.addUnmet(extra, workspot, hasInserted);
    }

    protected abstract void registerUnmetNeed(EXTRA var1, NeedsRegistrations.Need var2);

    public void registerUnmetRooms(EXTRA extra) {
        this.needsReg.addUnmetRoom(extra);
    }

    protected abstract void registerUnmetRoom(EXTRA var1);
}

