/*
 * Decompiled with CFR 0.152.
 */
package ca.bradj.questown.jobs.declarative;

import ca.bradj.questown.InventoryFullStrategy;
import ca.bradj.questown.blocks.ExtractedItemAware;
import ca.bradj.questown.blocks.InsertedItemAware;
import ca.bradj.questown.core.advancements.VisitorTrigger;
import ca.bradj.questown.core.init.AdvancementsInit;
import ca.bradj.questown.integration.minecraft.MCHeldItem;
import ca.bradj.questown.integration.minecraft.MCTownItem;
import ca.bradj.questown.items.EffectMetaItem;
import ca.bradj.questown.jobs.DeclarativeJobChecks;
import ca.bradj.questown.jobs.JobID;
import ca.bradj.questown.jobs.Jobs;
import ca.bradj.questown.jobs.WorkOutput;
import ca.bradj.questown.jobs.WorkPosition;
import ca.bradj.questown.jobs.WorkSpot;
import ca.bradj.questown.jobs.WorkedSpot;
import ca.bradj.questown.jobs.declarative.AbstractWorldInteraction;
import ca.bradj.questown.jobs.declarative.MCExtra;
import ca.bradj.questown.jobs.declarative.NeedsRegistrations;
import ca.bradj.questown.jobs.declarative.PostExtractHook;
import ca.bradj.questown.jobs.declarative.PostInsertHook;
import ca.bradj.questown.jobs.declarative.PreExtractHook;
import ca.bradj.questown.jobs.declarative.PreStateChangeHook;
import ca.bradj.questown.jobs.declarative.ProductionJournal;
import ca.bradj.questown.jobs.declarative.SoundInfo;
import ca.bradj.questown.jobs.production.ProductionStatus;
import ca.bradj.questown.logic.PredicateCollection;
import ca.bradj.questown.mc.Compat;
import ca.bradj.questown.mc.Util;
import ca.bradj.questown.mobs.visitor.VisitorMobEntity;
import ca.bradj.questown.town.Claim;
import ca.bradj.questown.town.PoseInPlace;
import ca.bradj.questown.town.interfaces.ImmutableWorkStateContainer;
import ca.bradj.questown.town.workstatus.State;
import ca.bradj.roomrecipes.adapter.RoomRecipeMatch;
import ca.bradj.roomrecipes.serialization.MCRoom;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RealtimeWorldInteraction
extends AbstractWorldInteraction<MCExtra, BlockPos, MCTownItem, MCHeldItem, Boolean> {
    private final BiFunction<MCExtra, NeedsRegistrations.Need, String> getUnmetNeed;
    private final Supplier<String> jobRoom;
    private final Function<MCExtra, BlockPos> townFlagPos;
    private int soundTicksLeft;
    private final ProductionJournal<MCTownItem, MCHeldItem> journal;
    private final BiFunction<ServerLevel, Collection<MCHeldItem>, Iterable<MCHeldItem>> resultGenerator;
    @Nullable
    private final SoundInfo sound;

    public RealtimeWorldInteraction(Function<MCExtra, BlockPos> townFlagPos, ProductionJournal<MCTownItem, MCHeldItem> journal, int maxState, DeclarativeJobChecks<MCExtra, MCHeldItem, MCTownItem, RoomRecipeMatch<MCRoom>, BlockPos> checks, Map<ProductionStatus, Collection<String>> specialRules, BiFunction<ServerLevel, Collection<MCHeldItem>, Iterable<MCHeldItem>> resultGenerator, Function<MCExtra, Claim> claimSpots, BiFunction<MCExtra, NeedsRegistrations.Need, String> getUnmetNeed, Supplier<String> jobRoom, int interval, @Nullable SoundInfo sound) {
        super(journal.getJobId(), -1, interval, maxState, checks, claimSpots, specialRules);
        this.getUnmetNeed = getUnmetNeed;
        this.jobRoom = jobRoom;
        this.journal = journal;
        this.resultGenerator = resultGenerator;
        this.sound = sound;
        super.addItemInsertionListener((extra, bp, item) -> {
            Block block = extra.town().getServerLevel().m_8055_(bp).m_60734_();
            if (block instanceof InsertedItemAware) {
                InsertedItemAware iia = (InsertedItemAware)block;
                iia.handleInsertedItem((MCExtra)extra, (BlockPos)bp, (MCHeldItem)item);
            }
        });
        super.addItemExtractionListener((extra, bp) -> {
            Block block = extra.town().getServerLevel().m_8055_(bp).m_60734_();
            if (block instanceof ExtractedItemAware) {
                ExtractedItemAware iia = (ExtractedItemAware)block;
                iia.handleExtractedItem((MCExtra)extra, (BlockPos)bp);
            }
        });
        this.townFlagPos = townFlagPos;
    }

    private static ImmutableMap<Integer, Function<MCTownItem, Boolean>> stripMC2(ImmutableMap<Integer, Ingredient> toolsRequiredAtStates) {
        ImmutableMap.Builder b = ImmutableMap.builder();
        toolsRequiredAtStates.forEach((k, v) -> b.put(k, z -> v.test(z.toQTItemStack())));
        return b.build();
    }

    private static ImmutableMap<Integer, Function<MCHeldItem, Boolean>> stripMC(ImmutableMap<Integer, Ingredient> ingredientsRequiredAtStates) {
        ImmutableMap.Builder b = ImmutableMap.builder();
        ingredientsRequiredAtStates.forEach((k, v) -> b.put(k, z -> v.test(z.get().toQTItemStack())));
        return b.build();
    }

    @Override
    protected int getWorkSpeedOf10(MCExtra mcExtra) {
        return Math.max(mcExtra.town().getVillagerHandle().getWorkSpeed(mcExtra.entity().m_20148_()), 1);
    }

    @Override
    protected int getAffectedTime(MCExtra mcExtra, Integer timeToAugment) {
        return mcExtra.town().getVillagerHandle().getAffectedTime(mcExtra.entity().m_20148_(), timeToAugment);
    }

    @Override
    protected Boolean setHeldItem(MCExtra uxtra, Boolean tuwn, int villagerIndex, int itemIndex, MCHeldItem item) {
        this.journal.setItem(itemIndex, item);
        return true;
    }

    @Override
    protected Boolean degradeTool(MCExtra mcExtra, Boolean tuwn, PredicateCollection<MCTownItem, ?> toolCheck) {
        Optional<MCHeldItem> foundTool = this.journal.getItems().stream().filter(v -> toolCheck.test(v.get())).findFirst();
        if (foundTool.isPresent()) {
            int idx = this.journal.getItems().indexOf((Object)foundTool.get());
            ItemStack is = foundTool.get().get().toQTItemStack();
            is.m_41622_(1, (LivingEntity)mcExtra.entity(), x -> {});
            this.journal.setItem(idx, MCHeldItem.fromMCItemStack(is));
            return true;
        }
        return null;
    }

    @Override
    protected ImmutableWorkStateContainer<BlockPos, Boolean> getWorkStatuses(MCExtra extra) {
        return extra.work();
    }

    @Override
    protected ArrayList<WorkPosition<BlockPos>> shuffle(MCExtra mcExtra, Collection<WorkPosition<BlockPos>> workSpots) {
        return new ArrayList<WorkPosition<BlockPos>>((Collection<WorkPosition<BlockPos>>)Compat.shuffle(ImmutableList.copyOf(workSpots), mcExtra.town().getServerLevel()));
    }

    @Override
    protected Collection<MCHeldItem> getHeldItems(MCExtra mcExtra, int villagerIndex) {
        return this.journal.getItems();
    }

    @Override
    protected Boolean setJobBlockState(@NotNull MCExtra inputs, Boolean ts, BlockPos position, State state) {
        inputs.work().setJobBlockState(position, state);
        return true;
    }

    @Override
    protected Boolean withEffectApplied(@NotNull MCExtra inputs, Boolean ts, MCHeldItem newItem) {
        ItemStack stack = newItem.get().toQTItemStack();
        ResourceLocation effect = EffectMetaItem.getEffect(stack);
        Long effectExpiry = EffectMetaItem.getEffectExpiry(stack, Util.getTick(inputs.town().getServerLevel()));
        inputs.town().getVillagerHandle().applyEffect(effect, effectExpiry, inputs.entity().m_20148_());
        return null;
    }

    @Override
    protected Boolean withKnowledge(@NotNull MCExtra inputs, Boolean ts, MCHeldItem newItem) {
        inputs.town().getKnowledgeHandle().registerFoundLoots((Collection<MCHeldItem>)ImmutableList.of((Object)newItem));
        return null;
    }

    @Override
    protected boolean isInstanze(MCTownItem mcTownItem, Class<?> clazz) {
        return clazz.isInstance(mcTownItem.get());
    }

    @Override
    protected boolean isMulti(MCTownItem mcTownItem) {
        return mcTownItem.toQTItemStack().m_41613_() > 1;
    }

    @Override
    protected Boolean getTown(MCExtra inputs) {
        return true;
    }

    @Override
    protected Iterable<MCHeldItem> getResults(MCExtra inputs, Collection<MCHeldItem> mcHeldItems) {
        return this.resultGenerator.apply(inputs.town().getServerLevel(), mcHeldItems);
    }

    @Override
    protected boolean canInsertItem(MCExtra mcExtra, MCHeldItem item, BlockPos bp) {
        return mcExtra.work().canInsertItem(item, bp);
    }

    @Override
    @Nullable
    public WorkOutput<Boolean, WorkPosition<BlockPos>> tryWorking(MCExtra mcExtra, WorkPosition<BlockPos> workSpot) {
        @Nullable WorkOutput<@Nullable Boolean, WorkPosition<BlockPos>> o = super.tryWorking(mcExtra, workSpot);
        if (o != null && o.town() != null && o.town().booleanValue()) {
            this.playSound(mcExtra, o.spot().jobBlock());
            mcExtra.entity().m_6674_(InteractionHand.MAIN_HAND);
        }
        return o;
    }

    @Override
    protected WorkedSpot<BlockPos> getCurWorkedSpot(MCExtra mcExtra, Boolean stateSource, BlockPos workSpot) {
        State jobBlockState = this.getJobBlockState(mcExtra, workSpot);
        return new WorkedSpot<BlockPos>(workSpot, Util.withFallbackForNullInput(jobBlockState, State::processingState, 0));
    }

    private void playSound(MCExtra mcExtra, BlockPos pos) {
        int chance;
        if (this.sound == null) {
            return;
        }
        @Nullable SoundEvent s = (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(this.sound.sound());
        int dieRoll = mcExtra.town().getServerLevel().m_213780_().m_188503_(100);
        int n = chance = this.sound.chance() == null ? 10 : this.sound.chance();
        if (dieRoll < chance) {
            int n2 = this.soundTicksLeft = this.sound.duration() == null ? 5 : this.sound.duration();
        }
        if (Math.max(this.soundTicksLeft--, 0) > 0) {
            Compat.playNeutralSound(mcExtra.town().getServerLevel(), pos, s);
        }
    }

    @Override
    protected boolean isEntityClose(MCExtra extra, BlockPos position) {
        return Jobs.isCloseTo(extra.entity().m_20183_(), position);
    }

    @Override
    protected boolean isReady(MCExtra extra) {
        return extra.town() != null && extra.town().getServerLevel() != null;
    }

    @Override
    public boolean tryGrabbingInsertedSupplies(MCExtra mcExtra) {
        VisitorMobEntity.WorkToUndo wtu = mcExtra.entity().getWorkToUndo();
        if (wtu == null) {
            return true;
        }
        return (Boolean)this.tryGiveItems(mcExtra, ImmutableList.of((Object)wtu.item()), wtu.pos());
    }

    @Override
    public boolean hasInserted(MCExtra mcExtra) {
        return mcExtra.entity().getWorkToUndo() != null;
    }

    @Override
    protected void registerUnmetNeed(MCExtra mcExtra, NeedsRegistrations.Need need) {
        ServerLevel serverLevel = mcExtra.town().getServerLevel();
        if (serverLevel == null) {
            throw new UnsupportedOperationException("Cannot run without server level");
        }
        String apply = this.getUnmetNeed.apply(mcExtra, need);
        if (apply == null) {
            return;
        }
        mcExtra.town().getEconomicsHandle().registerUnmetNeed(Util.getTick(serverLevel), mcExtra.entity().m_20148_(), apply);
    }

    @Override
    protected void registerUnmetRoom(MCExtra mcExtra) {
        ServerLevel serverLevel = mcExtra.town().getServerLevel();
        if (serverLevel == null) {
            throw new UnsupportedOperationException("Cannot run without server level");
        }
        mcExtra.town().getEconomicsHandle().registerUnmetRoom(Util.getTick(serverLevel), mcExtra.entity().m_20148_(), this.jobRoom.get());
    }

    public void clearInsertedSupplies(MCExtra extra) {
        extra.entity().clearWorkToUndo();
    }

    @Override
    @Nullable
    protected Boolean preExtractHook(Boolean didAnything, Collection<String> rules, MCExtra inputs, BlockPos position) {
        VisitorMobEntity.WorkToUndo workToUndo = inputs.entity().getWorkToUndo();
        return PreExtractHook.run(didAnything, rules, inputs.town().getServerLevel(), (in, i, s) -> {
            inputs.entity().tryGiveItem((MCHeldItem)i, (InventoryFullStrategy)((Object)s));
            return in;
        }, (in, up) -> {
            inputs.town().getVillagerHandle().fillHunger(inputs.entity().m_20148_(), up.floatValue());
            return in;
        }, position, Util.orNull(workToUndo, v -> v.item().get().get()), () -> inputs.town().getVillagerHandle().clearPoseRequests(inputs.entity().m_20148_()));
    }

    @Override
    protected Boolean postExtractHook(Boolean aBoolean, Collection<String> rules, MCExtra inputs, BlockPos position, MCHeldItem extractedItem) {
        return PostExtractHook.run(aBoolean, inputs.town().getTownFlagBasePos(), rules, inputs.town().getServerLevel(), position, (town, itemData) -> {
            CompoundTag t = extractedItem.get().toMCItemStack().m_41784_();
            itemData.forEach((arg_0, arg_1) -> ((CompoundTag)t).m_128405_(arg_0, arg_1));
            return town;
        });
    }

    @Override
    @NotNull
    protected Boolean postInsertHook(@NotNull Boolean aBoolean, Collection<String> rules, MCExtra inputs, WorkedSpot<BlockPos> position, MCHeldItem item) {
        return PostInsertHook.run(aBoolean, rules, inputs.town().getServerLevel(), position, item.get().toMCItemStack(), t -> {
            inputs.town().getVillagerHandle().clearBlockOfProgress(inputs.entity().m_20148_());
            return true;
        }, inputs.entity().m_20148_());
    }

    @Override
    protected void preStateChangeHooks(@NotNull Boolean ctx, Collection<String> rules, MCExtra inputs, WorkSpot<Integer, BlockPos> position) {
        PreStateChangeHook.run(rules, pose -> inputs.town().getVillagerHandle().requestPose(inputs.entity().m_20148_(), new PoseInPlace((Pose)pose, RealtimeWorldInteraction.decideSpot(rules, position))), jobId -> inputs.town().getVillagerHandle().changeJobForVillager(inputs.entity().m_20148_(), (JobID)jobId, false));
    }

    private static BlockPos decideSpot(Collection<String> rules, WorkSpot<Integer, BlockPos> position) {
        if (rules.contains("prefer_interaction_stand_on_top")) {
            return position.workPos().jobBlock().m_7494_();
        }
        return position.workPos().entityFeetPos();
    }

    @Override
    protected WorkOutput<Boolean, WorkPosition<BlockPos>> getWithSurfaceInteractionPos(MCExtra mcExtra, WorkOutput<Boolean, WorkPosition<BlockPos>> v) {
        return Util.workWithSurfaceInteractionPos(mcExtra.town().getServerLevel(), v);
    }

    @Override
    protected void iterate(Iterable<MCHeldItem> newItemsSource, Function<MCHeldItem, MCHeldItem> push) {
        Util.iterate(newItemsSource, push::apply);
    }

    @Override
    protected BlockPos getTownPos(MCExtra inputs) {
        return this.townFlagPos.apply(inputs);
    }

    @Override
    protected void triggerCompletionAdvancement(MCExtra inputs, BlockPos position) {
        AdvancementsInit.VISITOR_TRIGGER.triggerForNearestPlayer(inputs.town().getServerLevel(), VisitorTrigger.Triggers.FirstJobDone, position);
    }
}

