/*
 * Decompiled with CFR 0.152.
 */
package ca.bradj.questown.jobs.declarative;

import ca.bradj.questown.blocks.HospitalBedBlock;
import ca.bradj.questown.core.Config;
import ca.bradj.questown.integration.minecraft.MCHeldItem;
import ca.bradj.questown.jobs.ExpirationRules;
import ca.bradj.questown.jobs.JobID;
import ca.bradj.questown.jobs.ResultGenerator;
import ca.bradj.questown.jobs.Work;
import ca.bradj.questown.jobs.WorkLocation;
import ca.bradj.questown.jobs.WorkSpecialRules;
import ca.bradj.questown.jobs.WorkStates;
import ca.bradj.questown.jobs.WorkWorldInteractions;
import ca.bradj.questown.jobs.WorksBehaviour;
import ca.bradj.questown.jobs.declarative.nomc.WorkSeekerJob;
import ca.bradj.questown.jobs.production.ProductionStatus;
import ca.bradj.questown.mc.Compat;
import ca.bradj.questown.mc.Util;
import ca.bradj.questown.town.special.SpecialQuests;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.Collection;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.block.BedBlock;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.properties.BedPart;
import net.minecraft.world.level.block.state.properties.Property;

public class ResterWork {
    public static final String ID = "resting";
    public static final int BLOCK_STATE_NEED_BED = 0;
    public static final int BLOCK_STATE_NEED_REST = 1;
    public static final int BLOCK_STATE_DONE = 2;
    public static final int MAX_STATE = 2;
    public static final ImmutableMap<Integer, Ingredient> INGREDIENTS_REQUIRED_AT_STATES = ImmutableMap.of();
    public static final ImmutableMap<Integer, Integer> INGREDIENT_QTY_REQUIRED_AT_STATES = ImmutableMap.of();
    public static final ImmutableMap<Integer, Ingredient> TOOLS_REQUIRED_AT_STATES = ImmutableMap.of();
    public static final ImmutableMap<Integer, Integer> WORK_REQUIRED_AT_STATES = ImmutableMap.of((Object)0, (Object)1);
    public static final ImmutableMap<Integer, Integer> TIME_REQUIRED_AT_STATES = ImmutableMap.of((Object)1, (Object)2000);
    private static final Collection<ItemStack> RESULTS = ImmutableList.of((Object)Items.f_41852_.m_7968_());
    public static final int PAUSE_FOR_ACTION = 10;

    public static Work asWork(String rootId) {
        return WorksBehaviour.productionWork(null, Blocks.f_50029_.m_5456_().m_7968_(), new JobID(rootId, ID), WorksBehaviour.noResultDescription(), new WorkLocation(ctx -> ResterWork.isBed(ctx.blockInfo(), ctx.blockPos()), ResterWork::isBed, SpecialQuests.CLINIC), new WorkStates(2, Util.constant(INGREDIENTS_REQUIRED_AT_STATES), Util.constant(INGREDIENT_QTY_REQUIRED_AT_STATES), Util.constant(TOOLS_REQUIRED_AT_STATES), Util.constant(WORK_REQUIRED_AT_STATES), Util.constant(TIME_REQUIRED_AT_STATES)), new WorkWorldInteractions(10, new ResultGenerator<MCHeldItem>(){

            @Override
            public Iterable<MCHeldItem> generate(ServerLevel level, Collection<MCHeldItem> heldItems) {
                return MCHeldItem.fromMCItemStacks(RESULTS);
            }

            @Override
            public boolean isResultAlwaysEmpty() {
                return true;
            }
        }), new WorkSpecialRules((ImmutableMap<ProductionStatus, Collection<String>>)ImmutableMap.of((Object)ProductionStatus.fromJobBlockStatus(0), (Object)ImmutableList.of((Object)"lie_on_workspot"), (Object)ProductionStatus.EXTRACTING_PRODUCT, (Object)ImmutableList.of((Object)"clear_pose")), (ImmutableList<String>)ImmutableList.of((Object)"claim_spot", (Object)"work_in_evening", (Object)"prefer_interaction_stand_on_top")), null, new ExpirationRules(() -> Long.MAX_VALUE, () -> Long.MAX_VALUE, jobId -> jobId, Compat.configGet(Config.MAX_TICKS_WITHOUT_DINING_TABLE), WorkSeekerJob::getIDForRoot));
    }

    private static boolean isBed(WorkLocation.BlockInfo i, BlockPos p) {
        boolean isBlock = WorkLocation.isBlock(HospitalBedBlock.class).test(i, p);
        return isBlock && ((BedPart)i.state(p).m_61143_((Property)BedBlock.f_49440_)).equals((Object)BedPart.HEAD);
    }

    public static JobID getIdForRoot(String rootId) {
        return new JobID(rootId, ID);
    }

    public static boolean isResting(JobID jobName) {
        return ID.equals(jobName.jobId());
    }
}

