/*
 * Decompiled with CFR 0.152.
 */
package ca.bradj.questown.jobs.declarative;

import ca.bradj.questown.jobs.Item;
import ca.bradj.questown.jobs.declarative.InventoryHandle;
import ca.bradj.questown.jobs.declarative.ItemCountMismatch;
import java.util.Collection;

public class ValidatedInventoryHandle<X extends Item<X>>
implements InventoryHandle<X> {
    InventoryHandle<X> delegate;

    public ValidatedInventoryHandle(InventoryHandle<X> delegate, int inventorySize) throws ItemCountMismatch {
        this(delegate, inventorySize, false);
    }

    public static <X extends Item<X>> ValidatedInventoryHandle<X> unvalidated(InventoryHandle<X> delegate) {
        try {
            return new ValidatedInventoryHandle<X>(delegate, 0, true);
        }
        catch (ItemCountMismatch e) {
            throw new RuntimeException(e);
        }
    }

    private ValidatedInventoryHandle(InventoryHandle<X> delegate, int inventorySize, boolean skipValidation) throws ItemCountMismatch {
        this.delegate = delegate;
        if (skipValidation) {
            return;
        }
        int found = 0;
        for (Item x : delegate.getItems()) {
            if (x == null) {
                throw new ItemCountMismatch(inventorySize);
            }
            if (++found <= inventorySize) continue;
            throw new ItemCountMismatch(inventorySize);
        }
        if (found < inventorySize) {
            throw new ItemCountMismatch(inventorySize);
        }
    }

    @Override
    public Collection<X> getItems() {
        return this.delegate.getItems();
    }

    @Override
    public void set(int ii, X shrink) {
        this.delegate.set(ii, shrink);
    }
}

