/*
 * Decompiled with CFR 0.152.
 */
package ca.bradj.questown.jobs.declarative;

import ca.bradj.questown.jobs.IStatus;
import java.util.function.Function;

public class WithReason<S> {
    public final S value;
    public final String reason;

    public WithReason(S value, String reason) {
        this.value = value;
        this.reason = reason;
    }

    public WithReason(S value, String format, Object ... args) {
        this(value, String.format(format, args));
    }

    public static <X> WithReason<X> unformatted(X value, String message) {
        return new WithReason<X>(value, message);
    }

    public static <X> X orNull(WithReason<X> newStatus) {
        if (newStatus == null) {
            return null;
        }
        return (X)newStatus.value;
    }

    public static <STATUS extends IStatus<STATUS>> boolean isSame(STATUS value, WithReason<STATUS> withReason) {
        if (withReason == null) {
            return value == null;
        }
        return ((IStatus)withReason.value).equals(value);
    }

    public static WithReason<Boolean> bool(boolean test, String messageIfTrue, String messageIfFalse, Object ... argsForBothMessages) {
        if (test) {
            return new WithReason<Boolean>(true, messageIfTrue, argsForBothMessages);
        }
        return new WithReason<Boolean>(false, messageIfFalse, argsForBothMessages);
    }

    public static <T> WithReason<T> always(T val, String msg, Object ... msgArgs) {
        return new WithReason<T>(val, msg, msgArgs);
    }

    public WithReason<S> wrap(String s) {
        return new WithReason<S>(this.value, String.format("%s: %s", s, this.reason));
    }

    public <T> WithReason<T> map(Function<S, T> fn) {
        return new WithReason<T>(fn.apply(this.value), this.reason);
    }

    public S value() {
        return this.value;
    }

    public String reason() {
        return this.reason;
    }

    public String toString() {
        return String.valueOf(this.value == null ? "null" : this.value) + " because " + this.reason;
    }
}

