/*
 * Decompiled with CFR 0.152.
 */
package ca.bradj.questown.jobs.declarative;

import ca.bradj.questown.core.Config;
import ca.bradj.questown.integration.minecraft.MCHeldItem;
import ca.bradj.questown.integration.minecraft.MCTownItem;
import ca.bradj.questown.jobs.DeclarativeJob;
import ca.bradj.questown.jobs.DeclarativeJobChecks;
import ca.bradj.questown.jobs.EntityLocStateProvider;
import ca.bradj.questown.jobs.ExpirationRules;
import ca.bradj.questown.jobs.IProductionStatusFactory;
import ca.bradj.questown.jobs.Job;
import ca.bradj.questown.jobs.JobID;
import ca.bradj.questown.jobs.JobTownProvider;
import ca.bradj.questown.jobs.ServerJobsRegistry;
import ca.bradj.questown.jobs.Signals;
import ca.bradj.questown.jobs.Work;
import ca.bradj.questown.jobs.WorkLocation;
import ca.bradj.questown.jobs.WorksBehaviour;
import ca.bradj.questown.jobs.declarative.MCExtra;
import ca.bradj.questown.jobs.declarative.NeedsRegistrations;
import ca.bradj.questown.jobs.declarative.ProductionJournal;
import ca.bradj.questown.jobs.declarative.RealtimeWorldInteraction;
import ca.bradj.questown.jobs.declarative.SoundInfo;
import ca.bradj.questown.jobs.production.ProductionStatus;
import ca.bradj.questown.town.Claim;
import ca.bradj.questown.town.interfaces.TownInterface;
import ca.bradj.questown.town.special.SpecialQuests;
import ca.bradj.roomrecipes.adapter.RoomRecipeMatch;
import ca.bradj.roomrecipes.serialization.MCRoom;
import com.google.common.collect.ImmutableMap;
import java.util.Collection;
import java.util.Map;
import java.util.UUID;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.item.crafting.Ingredient;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class WorkSeekerJob
extends DeclarativeJob {
    public static final ImmutableMap<Integer, Ingredient> INGREDIENTS_REQUIRED_AT_STATES = ImmutableMap.of();
    public static final ImmutableMap<Integer, Integer> INGREDIENT_QTY_REQUIRED_AT_STATES = ImmutableMap.of();
    public static final ImmutableMap<Integer, Ingredient> TOOLS_REQUIRED_AT_STATES = ImmutableMap.of();
    public static final ImmutableMap<Integer, Integer> WORK_REQUIRED_AT_STATES = ImmutableMap.of((Object)0, (Object)0, (Object)1, (Object)1);
    public static final ImmutableMap<Integer, Integer> TIME_REQUIRED_AT_STATES = ImmutableMap.of((Object)0, (Object)0, (Object)1, (Object)0);
    private static final String WORK_ID = "seeking_work";
    private boolean registeredUnmet = false;

    public WorkSeekerJob(UUID ownerUUID, int inventoryCapacity, String rootId) {
        super(ownerUUID, inventoryCapacity, new JobID(rootId, WORK_ID), new WorkLocation(ctx -> true, (i, p) -> true, SpecialQuests.JOB_BOARD), 1, 0, INGREDIENTS_REQUIRED_AT_STATES, INGREDIENT_QTY_REQUIRED_AT_STATES, TOOLS_REQUIRED_AT_STATES, WORK_REQUIRED_AT_STATES, TIME_REQUIRED_AT_STATES, (ImmutableMap<ProductionStatus, Collection<String>>)ImmutableMap.of(), WorksBehaviour.standardProductionRules().specialGlobalRules(), ExpirationRules.never(), WorksBehaviour.noOutput(), SoundInfo.guaranteed(SoundEvents.f_11713_.m_11660_(), 100));
    }

    @Override
    @NotNull
    protected RealtimeWorldInteraction initWorldInteraction(int maxState, DeclarativeJobChecks<MCExtra, MCHeldItem, MCTownItem, RoomRecipeMatch<MCRoom>, BlockPos> checks, BiFunction<ServerLevel, Collection<MCHeldItem>, Iterable<MCHeldItem>> resultGenerator, Map<ProductionStatus, Collection<String>> specialRules, Function<MCExtra, Claim> claimSpots, BiFunction<MCExtra, NeedsRegistrations.Need, String> needs, Supplier<String> location, int interval, @Nullable SoundInfo sound) {
        return new RealtimeWorldInteraction(t -> t.town().getTownFlagBasePos(), (ProductionJournal)this.journal, maxState, checks, specialRules, resultGenerator, claimSpots, (x, need) -> {
            Work w = ServerJobsRegistry.getRandomWork(x.town().getServerLevel(), this.getId().rootId(), x.town().getVillagerHandle()::isUnlocked);
            Job job = (Job)w.jobFunc.apply(this.ownerUUID);
            if (job instanceof DeclarativeJob) {
                DeclarativeJob dj = (DeclarativeJob)job;
                String ingredient = dj.getIngredient(0);
                if (ingredient == null) {
                    return dj.getTool(0);
                }
                return ingredient;
            }
            return null;
        }, location, interval, sound){
            private long getWorkCooldown;
            {
                this.getWorkCooldown = 0L;
            }

            @Override
            protected Boolean tryExtractProduct(@NotNull MCExtra extra, BlockPos position) {
                --this.getWorkCooldown;
                if (this.getWorkCooldown > 0L) {
                    return false;
                }
                if (!extra.town().changeJobForVisitorFromBoard(WorkSeekerJob.this.ownerUUID, WorkSeekerJob.this.getId())) {
                    this.getWorkCooldown = (Long)Config.WORK_SEEKER_COOLDOWN.get();
                }
                return true;
            }
        };
    }

    @Override
    @NotNull
    protected Supplier<ProductionStatus> getStateComputer(TownInterface town, IProductionStatusFactory<ProductionStatus> statusFactory, JobTownProvider<MCRoom> jtp, EntityLocStateProvider<MCRoom> elp) {
        return () -> {
            Supplier<ProductionStatus> sc = super.getStateComputer(town, statusFactory, jtp, elp);
            return switch (super.getSignal()) {
                default -> throw new IncompatibleClassChangeError();
                case Signals.MORNING, Signals.NOON, Signals.UNDEFINED -> {
                    if (town.getVillagerHandle().hasBlockOfProgress(this.ownerUUID)) {
                        town.changeJobForVisitorFromBoard(this.ownerUUID, this.getId());
                    }
                    if (town.getPossibleWork().getFor(this.getId()).isEmpty()) {
                        if (!this.registeredUnmet && !((ProductionStatus)statusFactory.noWorkPossible()).equals(((ProductionJournal)this.journal).getStatus())) {
                            ((ProductionJournal)this.journal).changeStatus((ProductionStatus)statusFactory.noWorkPossible());
                            town.getPossibleWork().invalidate();
                            this.registeredUnmet = true;
                        }
                        yield (ProductionStatus)statusFactory.noWorkPossible();
                    }
                    yield sc.get();
                }
                case Signals.EVENING, Signals.NIGHT -> sc.get();
            };
        };
    }
}

