/*
 * Decompiled with CFR 0.152.
 */
package ca.bradj.questown.jobs.gatherer;

import ca.bradj.questown.QT;
import ca.bradj.questown.core.Config;
import ca.bradj.questown.core.init.TagsInit;
import ca.bradj.questown.core.init.items.ItemsInit;
import ca.bradj.questown.integration.minecraft.MCHeldItem;
import ca.bradj.questown.items.KnowledgeMetaItem;
import ca.bradj.questown.items.QTNBT;
import ca.bradj.questown.jobs.JobID;
import ca.bradj.questown.jobs.ResultGenerator;
import ca.bradj.questown.jobs.Work;
import ca.bradj.questown.jobs.WorkSpecialRules;
import ca.bradj.questown.jobs.WorkStates;
import ca.bradj.questown.jobs.WorkWorldInteractions;
import ca.bradj.questown.jobs.WorksBehaviour;
import ca.bradj.questown.jobs.declarative.SoundInfo;
import ca.bradj.questown.jobs.gatherer.GathererTools;
import ca.bradj.questown.jobs.gatherer.GathererUnmappedNoToolWorkQtrDay;
import ca.bradj.questown.jobs.gatherer.Loots;
import ca.bradj.questown.jobs.gatherer.NewLeaverWork;
import ca.bradj.questown.jobs.production.ProductionStatus;
import ca.bradj.questown.mc.Util;
import ca.bradj.questown.town.special.SpecialQuests;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.Collection;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import org.jetbrains.annotations.NotNull;

public class ExplorerWork {
    public static final JobID ID = new JobID("gatherer", "explore");
    public static final int BLOCK_STATE_NEED_FOOD = 0;
    public static final int BLOCK_STATE_NEED_PAPER = 1;
    public static final int BLOCK_STATE_NEED_ROAM = 2;
    public static final int BLOCK_STATE_DONE = 3;
    public static final int MAX_STATE = 3;
    public static final ImmutableMap<Integer, Ingredient> INGREDIENTS_REQUIRED_AT_STATES = ImmutableMap.of((Object)0, (Object)Ingredient.m_204132_(TagsInit.Items.VILLAGER_FOOD), (Object)1, (Object)Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42516_}));
    public static final ImmutableMap<Integer, Integer> INGREDIENT_QTY_REQUIRED_AT_STATES = ImmutableMap.of((Object)0, (Object)1, (Object)1, (Object)1);
    public static final ImmutableMap<Integer, Ingredient> TOOLS_REQUIRED_AT_STATES = ImmutableMap.of();
    public static final ImmutableMap<Integer, Integer> WORK_REQUIRED_AT_STATES = ImmutableMap.of();
    public static final ItemStack RESULT = ((Item)ItemsInit.GATHERER_MAP.get()).m_7968_();
    private static final boolean TIMER_SHARING = false;
    public static final ImmutableMap<ProductionStatus, Collection<String>> SPECIAL_RULES = ImmutableMap.of((Object)ProductionStatus.fromJobBlockStatus(2), (Object)ImmutableList.of((Object)"remove_from_world"), (Object)ProductionStatus.FACTORY.waitingForTimedState(), (Object)ImmutableList.of((Object)"remove_from_world"));
    public static final ResourceLocation JOB_SITE = SpecialQuests.TOWN_GATE;

    private static Iterable<MCHeldItem> getFromLootTables(ServerLevel level, Collection<MCHeldItem> items) {
        ItemStack map = ((Item)ItemsInit.GATHERER_MAP.get()).m_7968_();
        ImmutableList biomes = ImmutableList.of((Object)new ResourceLocation("dark_forest"), (Object)new ResourceLocation("desert"), (Object)new ResourceLocation("forest"), (Object)new ResourceLocation("jungle"), (Object)new ResourceLocation("mushroom_fields"), (Object)new ResourceLocation("savanna"), (Object)new ResourceLocation("taiga"));
        ResourceLocation biome = (ResourceLocation)biomes.get(level.m_213780_().m_188503_(biomes.size()));
        QTNBT.putString(map, "biome", biome.toString());
        ImmutableList.Builder list = ImmutableList.builder();
        list.add((Object)MCHeldItem.fromTown(map));
        ImmutableList all = NewLeaverWork.getAllParameters();
        if (all.isEmpty()) {
            all = ImmutableList.of((Object)new GathererTools.LootTableParameters(GathererTools.NO_TOOL_TABLE_PREFIX, GathererTools.NO_TOOL_LOOT_TABLE_DEFAULT));
        }
        GathererTools.LootTableParameters lootParams = (GathererTools.LootTableParameters)all.get(level.m_213780_().m_188503_(all.size()));
        @NotNull List<MCHeldItem> knowledge = Loots.getFromLootTables(level, 1, 1, lootParams, biome);
        QT.JOB_LOGGER.debug("Presenting knowledge of item to explorer: {} [prefix: {}, biome: {}]", (Object)knowledge.get(0), (Object)lootParams.prefix(), (Object)biome);
        list.add((Object)KnowledgeMetaItem.wrap(knowledge.get(0), lootParams.prefix(), biome));
        ImmutableList realList = list.build();
        QT.JOB_LOGGER.debug("Presenting items to explorer: {}", (Object)realList);
        return realList;
    }

    public static Work asWork() {
        return WorksBehaviour.productionWork(((Item)ItemsInit.GATHERER_MAP.get()).m_7968_(), ID, GathererUnmappedNoToolWorkQtrDay.ID, WorksBehaviour.standardDescription(() -> RESULT), SpecialQuests.TOWN_GATE_LOCATION, new WorkStates(3, Util.constant(INGREDIENTS_REQUIRED_AT_STATES), Util.constant(INGREDIENT_QTY_REQUIRED_AT_STATES), Util.constant(TOOLS_REQUIRED_AT_STATES), Util.constant(WORK_REQUIRED_AT_STATES), (ImmutableMap<Integer, Supplier<Integer>>)ImmutableMap.of((Object)2, () -> Config.GATHERER_TIME_REQUIRED_BASELINE.get())), new WorkWorldInteractions(0, new ResultGenerator<MCHeldItem>(){

            @Override
            public Iterable<MCHeldItem> generate(ServerLevel level, Collection<MCHeldItem> heldItems) {
                return ExplorerWork.getFromLootTables(level, heldItems);
            }

            @Override
            public boolean isResultAlwaysEmpty() {
                return false;
            }
        }), new WorkSpecialRules(SPECIAL_RULES, NewLeaverWork.standardRules()), new SoundInfo(SoundEvents.f_11678_.m_11660_(), 100, 100));
    }
}

