/*
 * Decompiled with CFR 0.152.
 */
package ca.bradj.questown.jobs.leaver;

import ca.bradj.questown.blocks.entity.ItemAccepting;
import ca.bradj.questown.jobs.Item;
import ca.bradj.questown.jobs.leaver.RankBoost;
import ca.bradj.roomrecipes.adapter.Positions;
import ca.bradj.roomrecipes.core.space.Position;
import com.google.common.collect.ImmutableList;
import java.util.AbstractMap;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ContainerTarget<C extends Container<I>, I extends Item<I>> {
    public static net.minecraft.world.Container REMOVED = new net.minecraft.world.Container(){

        public int m_6643_() {
            return 0;
        }

        public boolean m_7983_() {
            return true;
        }

        public ItemStack m_8020_(int p_18941_) {
            return ItemStack.f_41583_;
        }

        public ItemStack m_7407_(int p_18942_, int p_18943_) {
            return ItemStack.f_41583_;
        }

        public ItemStack m_8016_(int p_18951_) {
            return ItemStack.f_41583_;
        }

        public void m_6836_(int p_18944_, ItemStack p_18945_) {
        }

        public void m_6596_() {
        }

        public boolean m_6542_(Player p_18946_) {
            return false;
        }

        public void m_6211_() {
        }
    };
    private final Position interactPosition;
    private final Consumer<I> associate;
    private final float rankingBoost;
    private final Predicate<I> canAccept;
    private final ValidCheck check;
    Position position;
    int yPosition;
    Container<I> container;

    public int size() {
        return this.container.size();
    }

    public I getItem(int index) {
        return this.container.getItem(index);
    }

    public void setItem(int index, I item) {
        this.container.setItem(index, item);
    }

    public boolean isFull() {
        return this.container.isFull();
    }

    public BlockPos getBlockPos() {
        return Positions.ToBlock((Position)this.getPosition(), (int)this.getYPosition());
    }

    public String toShortString(boolean includeAir) {
        return this.container.toShortString(includeAir);
    }

    public String toShortString() {
        return this.toShortString(true);
    }

    @Nullable
    public Map.Entry<ContainerTarget<C, I>, I> withItemRemoved(Predicate<I> itemCheck) {
        for (int i = 0; i < this.container.size(); ++i) {
            if (!itemCheck.test(this.container.getItem(i))) continue;
            I itm = this.container.getItem(i);
            this.container.removeItem(i);
            return new AbstractMap.SimpleEntry(new ContainerTarget<C, I>(this.position, this.yPosition, this.interactPosition, this.container, this.check, this.associate, this.canAccept, this.rankingBoost), itm.unit());
        }
        return null;
    }

    public float getRankingBoost() {
        return this.rankingBoost;
    }

    public boolean canAccept(I item) {
        return this.canAccept.test(item);
    }

    public ImmutableList<I> getItems() {
        ImmutableList.Builder b = ImmutableList.builder();
        for (int i = 0; i < this.container.size(); ++i) {
            I item = this.container.getItem(i);
            this.associate.accept(item);
            b.add(item);
        }
        return b.build();
    }

    public ContainerTarget(Position position, int yPosition, Position interactionPosition, @NotNull Container<I> container, ValidCheck check, Consumer<I> associate, @Nullable Predicate<I> canAccept, float rankingBoost) {
        this.position = position;
        this.yPosition = yPosition;
        this.interactPosition = interactionPosition;
        this.container = container;
        this.check = check;
        this.associate = associate;
        this.canAccept = canAccept;
        this.rankingBoost = rankingBoost;
    }

    public Position getPosition() {
        return this.position;
    }

    public Position getInteractPosition() {
        return this.interactPosition;
    }

    public int getYPosition() {
        return this.yPosition;
    }

    public Container<I> getContainer() {
        return this.container;
    }

    public boolean hasItem(CheckFn<I> c) {
        for (int i = 0; i < this.container.size(); ++i) {
            if (!c.Matches(this.container.getItem(i))) continue;
            return true;
        }
        return false;
    }

    public boolean isStillValid() {
        return this.check.IsStillValid();
    }

    public String toString() {
        return "ContainerTarget{position=" + String.valueOf(this.position) + ", container=" + String.valueOf(this.container) + "}";
    }

    @Deprecated(since="0.0.9", forRemoval=false)
    public static interface Container<I extends Item<I>>
    extends ItemAccepting<I> {
        public int size();

        public I getItem(int var1);

        public I removeItem(int var1);

        public boolean isFull();

        public String toShortString();

        public String toShortString(boolean var1);

        public boolean canAcceptIfSpaceAllows(I var1);

        public RankBoost getItemAcceptanceRankBoost();
    }

    public static interface ValidCheck {
        public boolean IsStillValid();
    }

    public static interface CheckFn<I extends Item> {
        public boolean Matches(I var1);
    }
}

