/*
 * Decompiled with CFR 0.152.
 */
package ca.bradj.questown.jobs.production;

import ca.bradj.questown.QT;
import ca.bradj.questown.core.advancements.RoomTrigger;
import ca.bradj.questown.core.init.AdvancementsInit;
import ca.bradj.questown.integration.minecraft.MCContainer;
import ca.bradj.questown.integration.minecraft.MCHeldItem;
import ca.bradj.questown.integration.minecraft.MCTownItem;
import ca.bradj.questown.jobs.Containers;
import ca.bradj.questown.jobs.EntityInvStateProvider;
import ca.bradj.questown.jobs.IProductionStatusFactory;
import ca.bradj.questown.jobs.Job;
import ca.bradj.questown.jobs.Jobs;
import ca.bradj.questown.jobs.JobsClean;
import ca.bradj.questown.jobs.Journal;
import ca.bradj.questown.jobs.JournalItemsListener;
import ca.bradj.questown.jobs.LockSlot;
import ca.bradj.questown.jobs.LockSlotHaver;
import ca.bradj.questown.jobs.SignalSource;
import ca.bradj.questown.jobs.Signals;
import ca.bradj.questown.jobs.Snapshot;
import ca.bradj.questown.jobs.StatusListener;
import ca.bradj.questown.jobs.SupplyItemStatus;
import ca.bradj.questown.jobs.WorkLocation;
import ca.bradj.questown.jobs.WorkPosition;
import ca.bradj.questown.jobs.declarative.MCExtra;
import ca.bradj.questown.jobs.declarative.WithReason;
import ca.bradj.questown.jobs.leaver.ContainerTarget;
import ca.bradj.questown.jobs.production.IProductionStatus;
import ca.bradj.questown.jobs.production.RoomsNeedingVillagerInput;
import ca.bradj.questown.logic.PredicateCollection;
import ca.bradj.questown.mc.Compat;
import ca.bradj.questown.mc.Util;
import ca.bradj.questown.town.Claim;
import ca.bradj.questown.town.TownContainers;
import ca.bradj.questown.town.interfaces.TownInterface;
import ca.bradj.questown.town.interfaces.WorkStatusHandle;
import ca.bradj.questown.town.workstatus.State;
import ca.bradj.roomrecipes.adapter.Positions;
import ca.bradj.roomrecipes.adapter.RoomRecipeMatch;
import ca.bradj.roomrecipes.core.space.Position;
import ca.bradj.roomrecipes.serialization.MCRoom;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerListener;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.inventory.DataSlot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.phys.Vec3;
import org.apache.logging.log4j.Marker;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ProductionJob<STATUS extends IProductionStatus<STATUS>, SNAPSHOT extends Snapshot<MCHeldItem>, JOURNAL extends Journal<STATUS, MCHeldItem, SNAPSHOT>>
implements Job<MCHeldItem, SNAPSHOT, STATUS>,
LockSlotHaver,
ContainerListener,
JournalItemsListener<MCHeldItem>,
Jobs.LootDropper<MCHeldItem>,
SignalSource {
    @Nullable
    private Long lastDropTick = null;
    @Nullable
    private Long secondLastDropTick = null;
    private final Marker marker;
    private final ArrayList<DataSlot> locks = new ArrayList();
    protected final Container inventory;
    protected final JOURNAL journal;
    protected final IProductionStatusFactory<STATUS> statusFactory;
    protected final Supplier<Claim> claimSupplier;
    private final WorkLocation location;
    protected ContainerTarget<MCContainer, MCTownItem> successTarget;
    protected ContainerTarget<MCContainer, MCTownItem> suppliesTarget;
    private boolean dropping;
    protected final UUID ownerUUID;
    protected RoomsNeedingVillagerInput<MCRoom, ResourceLocation, BlockPos> roomsNeedingIngredientsOrTools;
    public final ImmutableMap<STATUS, Collection<String>> specialRules;
    public final ImmutableList<String> specialGlobalRules;
    @Nullable
    protected BlockPos lookTarget;
    private BlockPos jobSite;

    @Nullable
    public BlockPos getJobSite(TownInterface town) {
        if (this.jobSite == null || Compat.nextRandomInt(town.getServerLevel(), 200) == 0) {
            ServerLevel sl = town.getServerLevel();
            if (sl == null) {
                return null;
            }
            WithReason<@Nullable BlockPos> js = this.findJobSite(town, this.roomsNeedingIngredientsOrTools, this.getWorkStatusHandle(town)::getJobBlockState, bp -> this.isValidWalkTarget(town, (BlockPos)bp), this::isJobBlock, bp -> bp.m_121945_(Compat.getRandomHorizontal(sl)));
            this.jobSite = js.value();
            if (this.jobSite != null) {
                AdvancementsInit.ROOM_TRIGGER.triggerForNearestPlayer(town.getServerLevel(), RoomTrigger.Triggers.FirstJobBlock, this.jobSite);
            }
        }
        return this.jobSite;
    }

    protected abstract boolean isJobBlock(BlockPos var1);

    protected boolean isValidWalkTarget(TownInterface town, BlockPos bp) {
        @Nullable ServerLevel sl = town.getServerLevel();
        if (sl == null) {
            return false;
        }
        Material footMaterial = sl.m_8055_(bp).m_60767_();
        boolean footSpotBlocked = footMaterial.m_76333_();
        BlockState torsoMaterial = sl.m_8055_(bp.m_7494_());
        boolean torsoSpotBlocked = torsoMaterial.m_60767_().m_76333_();
        BlockState groundMaterial = sl.m_8055_(bp.m_7495_());
        boolean groundSpotSolid = groundMaterial.m_60767_().m_76333_();
        return groundSpotSolid && !footSpotBlocked && !torsoSpotBlocked;
    }

    @Override
    public abstract Signals getSignal();

    protected void clearJobSite() {
        this.jobSite = null;
    }

    public boolean isDropping() {
        return this.dropping;
    }

    public ProductionJob(UUID ownerUUID, int inventoryCapacity, Marker logMarker, BiFunction<Integer, SignalSource, JOURNAL> journalInit, IProductionStatusFactory<STATUS> sFac, ImmutableMap<STATUS, Collection<String>> specialRules, ImmutableList<String> specialGlobalRules, Supplier<Claim> claimSupplier, WorkLocation location) {
        SimpleContainer sc = new SimpleContainer(inventoryCapacity){

            public int m_6893_() {
                return 1;
            }
        };
        this.ownerUUID = ownerUUID;
        this.specialGlobalRules = specialGlobalRules;
        this.marker = logMarker;
        this.inventory = sc;
        sc.m_19164_((ContainerListener)this);
        for (int i = 0; i < inventoryCapacity; ++i) {
            this.locks.add(new LockSlot(i, this));
        }
        this.journal = (Journal)journalInit.apply(inventoryCapacity, this);
        this.journal.addItemListener(this);
        this.statusFactory = sFac;
        this.specialRules = specialRules;
        this.claimSupplier = claimSupplier;
        this.location = location;
    }

    @Override
    public Function<Void, Void> addStatusListener(StatusListener o) {
        return this.journal.addStatusListener(o);
    }

    @Override
    public void removeStatusListener(StatusListener o) {
        this.journal.removeStatusListener(o);
    }

    @Override
    public Collection<? extends Runnable> notifyListenersOfNewJob(Function<StatusListener, Runnable> listenToNewJob) {
        return this.journal.notifyListenersOfNewJob(listenToNewJob);
    }

    @Override
    public STATUS getStatus() {
        return (STATUS)((IProductionStatus)this.journal.getStatus());
    }

    @Override
    public boolean isWorking() {
        return this.isInitialized() && this.getStatus().isWorkingOnProduction();
    }

    @Override
    public String getStatusToSyncToClient() {
        return ((IProductionStatus)this.journal.getStatus()).name();
    }

    @Override
    public void itemsChanged(ImmutableList<MCHeldItem> items) {
        Jobs.handleItemChanges(this.inventory, items);
    }

    @Override
    public UUID UUID() {
        return this.ownerUUID;
    }

    @Override
    public boolean isJumpingAllowed(BlockState onBlock) {
        return true;
    }

    @Override
    public boolean shouldHoldAllItems() {
        return !this.journal.hasAnyLootToDrop();
    }

    @Override
    public boolean hasAnyLootToDrop() {
        return this.journal.hasAnyLootToDrop();
    }

    @Override
    public Iterable<MCHeldItem> getItemsForDrop() {
        return this.journal.getItems();
    }

    @Override
    public boolean removeItem(MCHeldItem mct) {
        return this.journal.removeItem((MCHeldItem)mct);
    }

    protected abstract Map<Integer, SupplyItemStatus> getSupplyItemStatus();

    protected boolean tryDropLoot(Long currentTick, BlockPos entityPos) {
        if (this.successTarget == null) {
            return false;
        }
        if (!Jobs.isCloseTo(entityPos, this.successTarget.getBlockPos())) {
            return false;
        }
        if (!((IProductionStatus)this.journal.getStatus()).isDroppingLoot()) {
            return false;
        }
        if (this.dropping) {
            QT.JOB_LOGGER.debug(this.marker, "Trying to drop too quickly");
        }
        this.dropping = Jobs.tryDropLoot(this, entityPos, this.successTarget);
        if (this.dropping) {
            this.secondLastDropTick = this.lastDropTick;
            this.lastDropTick = currentTick;
        }
        return this.dropping;
    }

    @NotNull
    protected ImmutableList<PredicateCollection<MCTownItem, ?>> convertToCleanFns(Map<Integer, ? extends Collection<?>> statusMap) {
        Optional<Integer> first = statusMap.entrySet().stream().filter(v -> !((Collection)v.getValue()).isEmpty()).map(Map.Entry::getKey).findFirst();
        if (first.isEmpty()) {
            return ImmutableList.of();
        }
        return this.getRecipe(first.get());
    }

    protected abstract ImmutableList<PredicateCollection<MCTownItem, ?>> getRecipe(Integer var1);

    @Override
    public BlockPos getLook() {
        return this.lookTarget;
    }

    @Override
    @Nullable
    public BlockPos getTarget(BlockPos entityBlockPos, Vec3 entityPos, TownInterface town) {
        @Nullable ServerLevel sl = town.getServerLevel();
        if (sl == null) {
            return null;
        }
        IProductionStatus status = (IProductionStatus)this.journal.getStatus();
        return this.doGetTarget(entityBlockPos, entityPos, town, status, sl);
    }

    @Nullable
    private BlockPos doGetTarget(BlockPos entityBlockPos, Vec3 entityPos, TownInterface town, STATUS status, @NotNull ServerLevel sl) {
        if (status.isGoingToJobsite()) {
            BlockPos jobSite1 = this.getJobSite(town);
            this.setLookTarget(jobSite1);
            return jobSite1;
        }
        if (status.isWorkingOnProduction() || status.isWaitingForTimers()) {
            WorkPosition<BlockPos> productionSpot = this.findProductionSpot(sl);
            if (productionSpot != null) {
                this.setLookTarget(productionSpot.jobBlock());
                return productionSpot.entityFeetPos();
            }
            QT.JOB_LOGGER.debug("Production spot was null somehow");
            return null;
        }
        if (status.isDroppingLoot()) {
            this.successTarget = this.getDropTargetForLoot(entityBlockPos, town);
            if (this.successTarget != null) {
                this.setLookTarget(this.successTarget.getBlockPos());
                return Positions.ToBlock((Position)this.successTarget.getInteractPosition(), (int)this.successTarget.getYPosition());
            }
        }
        this.setupForGetSupplies(town, entityBlockPos, Util.getTick(sl));
        if (this.suppliesTarget != null) {
            this.setLookTarget(this.suppliesTarget.getBlockPos());
            return Positions.ToBlock((Position)this.suppliesTarget.getInteractPosition(), (int)this.suppliesTarget.getYPosition());
        }
        if (this.shouldDisappear(town, entityPos)) {
            return entityBlockPos;
        }
        return null;
    }

    @Nullable
    protected ContainerTarget<MCContainer, MCTownItem> getDropTargetForLoot(BlockPos entityBlockPos, TownInterface town) {
        ImmutableList.Builder b = ImmutableList.builder();
        for (MCHeldItem item : this.journal.getItems()) {
            if (item.isEmpty()) continue;
            b.add((Object)item.toItem());
        }
        return Jobs.setupForDropLoot(town, this.successTarget, entityBlockPos, (Collection<MCTownItem>)b.build());
    }

    protected void setLookTarget(BlockPos jobSite1) {
        this.lookTarget = jobSite1;
    }

    @Nullable
    protected abstract WorkPosition<BlockPos> findProductionSpot(ServerLevel var1);

    protected abstract WithReason<@Nullable BlockPos> findJobSite(TownInterface var1, RoomsNeedingVillagerInput<MCRoom, ResourceLocation, BlockPos> var2, Function<BlockPos, State> var3, Predicate<BlockPos> var4, Predicate<BlockPos> var5, Function<BlockPos, BlockPos> var6);

    public abstract RoomsNeedingVillagerInput<MCRoom, ResourceLocation, BlockPos> roomsNeedingIngredientsOrTools(TownInterface var1, Function<BlockPos, State> var2, Predicate<BlockPos> var3);

    protected WorkStatusHandle<BlockPos, MCHeldItem> getWorkStatusHandle(TownInterface town) {
        WorkStatusHandle<BlockPos, MCHeldItem> work = this.specialGlobalRules.contains((Object)"shared_work_status") ? town.getWorkStatusHandle(null) : town.getWorkStatusHandle(this.ownerUUID);
        return work;
    }

    protected abstract void tick(MCExtra var1, WorkStatusHandle<BlockPos, MCHeldItem> var2, LivingEntity var3, Direction var4, RoomsNeedingVillagerInput<MCRoom, ResourceLocation, BlockPos> var5, IProductionStatusFactory<STATUS> var6);

    protected void setupForGetSupplies(TownInterface town, BlockPos pos, Long currentTick) {
        ContainerTarget.CheckFn<MCTownItem> checkFn = item -> JobsClean.shouldTakeItem(this.journal.getCapacity(), this.cleanRooms(), this.journal.getItems(), item);
        Supplier<ContainerTarget> find = () -> {
            Predicate<RoomRecipeMatch<MCRoom>> includeRoom = this::shouldCheckContainerForSupplies;
            List<ContainerTarget<MCContainer, MCTownItem>> chests = Containers.get(town, includeRoom, this::isJobBlock, js -> this.location.baseRoom().equals(js), false);
            List<ContainerTarget> closeChests = chests.stream().sorted(Comparator.comparingDouble(a -> TownContainers.comparison(pos, a))).toList();
            for (ContainerTarget chest : closeChests) {
                if (!chest.hasItem(checkFn) || !this.shouldUseBlockForSupplies(currentTick, chest.getBlockPos())) continue;
                return chest;
            }
            return null;
        };
        ContainerTarget st = find.get();
        if (st != null) {
            this.suppliesTarget = st;
        }
        if (this.suppliesTarget != null) {
            QT.JOB_LOGGER.trace(this.marker, "Located supplies at {}", (Object)this.suppliesTarget.getPosition());
        }
    }

    private boolean shouldUseBlockForSupplies(Long currentTick, BlockPos b) {
        if (this.suppliesTarget == null) {
            return true;
        }
        Predicate<Long> isRecent = tick -> this.isRecentTick(currentTick, (Long)tick);
        boolean droppedSuppliesRecently = isRecent.test(this.lastDropTick) && isRecent.test(this.secondLastDropTick);
        boolean grabbedSuppliesRecently = this.grabbedSuppliesRecently(isRecent);
        if (droppedSuppliesRecently && grabbedSuppliesRecently) {
            return !this.suppliesTarget.getBlockPos().equals((Object)b);
        }
        return true;
    }

    protected boolean isRecentTick(Long referenceTick, @Nullable Long testedTick) {
        return testedTick != null && testedTick > referenceTick - 50L;
    }

    protected abstract boolean grabbedSuppliesRecently(Predicate<Long> var1);

    protected abstract boolean shouldCheckContainerForSupplies(RoomRecipeMatch<MCRoom> var1);

    protected abstract Collection<? extends Predicate<MCTownItem>> cleanRooms();

    @Override
    public boolean shouldDisappear(TownInterface town, Vec3 entityPosition) {
        Collection<String> rules = Util.getOrDefault(this.specialRules, this.getStatus(), ImmutableList.of());
        for (String rule : rules) {
            if (rule == null || !"remove_from_world".equals(rule)) continue;
            return true;
        }
        return false;
    }

    @Override
    public Container getInventory() {
        return this.inventory;
    }

    @Override
    public ImmutableList<Boolean> getSlotLockStatuses() {
        return this.journal.getSlotLockStatuses();
    }

    @Override
    public void lockSlot(int slotIndex) {
    }

    @Override
    public void unlockSlot(int slotIndex) {
    }

    @Override
    public DataSlot getLockSlot(int i) {
        return this.locks.get(i);
    }

    @Override
    public void initializeItems(Iterable<MCHeldItem> mcTownItemStream) {
        this.journal.setItems(mcTownItemStream);
    }

    @Override
    public SNAPSHOT getJournalSnapshot() {
        return (SNAPSHOT)((Snapshot)this.journal.getSnapshot());
    }

    @Override
    public void initialize(ServerLevel level, Snapshot<MCHeldItem> journal) {
        this.journal.initialize(journal);
    }

    @Override
    public boolean isInitialized() {
        return this.journal.isInitialized();
    }

    @Override
    public boolean shouldBeNoClip(TownInterface town, BlockPos blockPos) {
        return false;
    }

    @Override
    public boolean addToEmptySlot(MCHeldItem i) {
        return this.journal.addItemIfSlotAvailable((MCHeldItem)i);
    }

    public void m_5757_(Container p_18983_) {
        if (Jobs.isUnchanged(p_18983_, this.journal.getItems())) {
            return;
        }
        ImmutableList.Builder b = ImmutableList.builder();
        for (int i = 0; i < p_18983_.m_6643_(); ++i) {
            ItemStack item = p_18983_.m_8020_(i);
            MCHeldItem mcHeldItem = MCHeldItem.fromMCItemStack(item);
            if (this.locks.get(i).m_6501_() == 1) {
                mcHeldItem = mcHeldItem.locked();
            }
            b.add((Object)mcHeldItem);
        }
        this.journal.setItemsNoUpdateNoCheck(b.build());
    }

    protected EntityInvStateProvider<Integer> defaultEntityInvProvider() {
        return new EntityInvStateProvider<Integer>(){

            @Override
            public boolean inventoryFull() {
                return ProductionJob.this.journal.isInventoryFull();
            }

            @Override
            public boolean hasNonSupplyItems() {
                Set<Integer> statesToFeed = ProductionJob.this.roomsNeedingIngredientsOrTools.getNonEmptyStates();
                ImmutableList allFillableRecipes = ImmutableList.copyOf(statesToFeed.stream().flatMap(v -> ProductionJob.this.getRecipe((Integer)v).stream()).toList());
                return Jobs.hasNonSupplyItems(ProductionJob.this.journal, (ImmutableList<Predicate<MCTownItem>>)allFillableRecipes);
            }

            @Override
            public Map<Integer, SupplyItemStatus> getSupplyItemStatus() {
                return ProductionJob.this.getSupplyItemStatus();
            }
        };
    }

    @Override
    public boolean canStopWorkingAtAnyTime() {
        Object status = this.getStatus();
        ImmutableList importantStauses = ImmutableList.of(((IProductionStatus)status)::isExtractingProduct, ((IProductionStatus)status)::isWaitingForTimers);
        boolean mustKeepWorking = importantStauses.stream().anyMatch(Supplier::get);
        return !mustKeepWorking;
    }

    public static interface TestFn<S, I> {
        public boolean test(Map<S, Boolean> var1, I var2);

        public boolean testAssumeNeeded(I var1);
    }

    public static interface RecipeProvider {
        public ImmutableList<PredicateCollection<MCTownItem, ?>> getRecipe(int var1);
    }
}

