/*
 * Decompiled with CFR 0.152.
 */
package ca.bradj.questown.jobs.production;

import ca.bradj.questown.core.UtilClean;
import ca.bradj.questown.gui.SessionUniqueOrdinals;
import ca.bradj.questown.jobs.IStatusFactory;
import ca.bradj.questown.jobs.production.IProductionStatus;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.Nullable;

public class ProductionStatus
implements IProductionStatus<ProductionStatus> {
    private final int value;
    public static final int firstNonCustomIndex = 10;
    private static int nextIndex = 10;
    private static final Map<Integer, ProductionStatus> allStatuses = new HashMap<Integer, ProductionStatus>();
    public static final ProductionStatus DROPPING_LOOT;
    public static final ProductionStatus NO_SPACE;
    public static final ProductionStatus GOING_TO_JOB;
    public static final ProductionStatus NO_SUPPLIES;
    public static final ProductionStatus COLLECTING_SUPPLIES;
    public static final ImmutableList<ProductionStatus> MOVING_STATUSES;
    public static final ProductionStatus IDLE;
    public static final ProductionStatus EXTRACTING_PRODUCT;
    public static final ProductionStatus RELAXING;
    public static final ProductionStatus WAITING_FOR_TIMED_STATE;
    public static final ProductionStatus NO_JOBSITE;
    public static final ProductionStatus NO_WORK_POSSIBLE;
    public static final IStatusFactory<ProductionStatus> FACTORY;
    public final String name;

    private static ProductionStatus register(ProductionStatus ps) {
        allStatuses.put(ps.value, ps);
        return SessionUniqueOrdinals.register(ps);
    }

    public static ImmutableSet<ProductionStatus> allStatuses() {
        return ImmutableSet.copyOf(allStatuses.values());
    }

    public static ProductionStatus fromJobBlockStatus(int s) {
        return ProductionStatus.fromJobBlockStatus(s, Integer.MAX_VALUE);
    }

    public static ProductionStatus fromJobBlockStatus(int s, int maxState) {
        if (s >= 10) {
            throw new IllegalStateException("Not a valid job block status: " + s);
        }
        if (s == maxState) {
            return EXTRACTING_PRODUCT;
        }
        return new ProductionStatus("state:" + s, s);
    }

    private ProductionStatus(String name, int i) {
        this.value = i;
        this.name = name;
    }

    public static ProductionStatus fromNumber(String s) {
        int i = Integer.parseInt(s);
        return UtilClean.getOrDefault2(allStatuses, i, () -> new ProductionStatus(s, i));
    }

    @Override
    public IStatusFactory<ProductionStatus> getFactory() {
        return FACTORY;
    }

    @Override
    public boolean isGoingToJobsite() {
        return GOING_TO_JOB.equals(this);
    }

    @Override
    public boolean isWorkingOnProduction() {
        return this.isExtractingProduct() || this.value < 10;
    }

    @Override
    public boolean isExtractingProduct() {
        return EXTRACTING_PRODUCT.equals(this);
    }

    @Override
    public boolean isWaitingForTimers() {
        return WAITING_FOR_TIMED_STATE.equals(this);
    }

    @Override
    public boolean shouldBeMoving() {
        return MOVING_STATUSES.contains((Object)this);
    }

    @Override
    public boolean isDroppingLoot() {
        return DROPPING_LOOT.equals(this);
    }

    @Override
    public boolean isCollectingSupplies() {
        return COLLECTING_SUPPLIES.equals(this);
    }

    @Override
    public String name() {
        return Integer.toString(this.value);
    }

    @Override
    public String nameV2() {
        if (this.value < 10) {
            return Integer.toString(this.value);
        }
        return this.name;
    }

    @Override
    public boolean isUnset() {
        return this.value < 0;
    }

    @Override
    public boolean isAllowedToTakeBreaks() {
        if (this.isWorkingOnProduction()) {
            return false;
        }
        return !ImmutableList.of((Object)GOING_TO_JOB, (Object)DROPPING_LOOT, (Object)COLLECTING_SUPPLIES, (Object)EXTRACTING_PRODUCT, (Object)WAITING_FOR_TIMED_STATE).contains((Object)this);
    }

    @Override
    public boolean isBusy() {
        return !this.isAllowedToTakeBreaks();
    }

    @Override
    @Nullable
    public String getCategoryId() {
        if (this.isWorkingOnProduction()) {
            return null;
        }
        return "production";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ProductionStatus that = (ProductionStatus)o;
        return this.value == that.value;
    }

    public int hashCode() {
        return Objects.hash(this.value);
    }

    public int getProductionState(int maxState) {
        if (this.value == ProductionStatus.EXTRACTING_PRODUCT.value) {
            return maxState;
        }
        if (this.value >= 10) {
            throw new IllegalStateException("Invalid production status: " + this.value);
        }
        return this.value;
    }

    public String toString() {
        return "ProductionStatus{value=" + this.value + ", name='" + this.name + "'}";
    }

    static {
        for (int i = 0; i < 10; ++i) {
            SessionUniqueOrdinals.register(ProductionStatus.fromJobBlockStatus(i));
        }
        DROPPING_LOOT = ProductionStatus.register(new ProductionStatus("DROPPING_LOOT", nextIndex++));
        NO_SPACE = ProductionStatus.register(new ProductionStatus("NO_SPACE", nextIndex++));
        GOING_TO_JOB = ProductionStatus.register(new ProductionStatus("GOING_TO_JOB", nextIndex++));
        NO_SUPPLIES = ProductionStatus.register(new ProductionStatus("NO_SUPPLIES", nextIndex++));
        COLLECTING_SUPPLIES = ProductionStatus.register(new ProductionStatus("COLLECTING_SUPPLIES", nextIndex++));
        MOVING_STATUSES = ImmutableList.of((Object)GOING_TO_JOB, (Object)DROPPING_LOOT, (Object)COLLECTING_SUPPLIES);
        IDLE = ProductionStatus.register(new ProductionStatus("IDLE", nextIndex++));
        EXTRACTING_PRODUCT = ProductionStatus.register(new ProductionStatus("EXTRACTING_PRODUCT", nextIndex++));
        RELAXING = ProductionStatus.register(new ProductionStatus("RELAXING", nextIndex++));
        WAITING_FOR_TIMED_STATE = ProductionStatus.register(new ProductionStatus("WAITING_FOR_TIMED_STATE", nextIndex++));
        NO_JOBSITE = ProductionStatus.register(new ProductionStatus("NO_JOBSITE", nextIndex++));
        NO_WORK_POSSIBLE = ProductionStatus.register(new ProductionStatus("NO_WORK_POSSIBLE", nextIndex++));
        FACTORY = new IStatusFactory<ProductionStatus>(){

            @Override
            public ProductionStatus droppingLoot() {
                return DROPPING_LOOT;
            }

            @Override
            public ProductionStatus noSpace() {
                return NO_SPACE;
            }

            @Override
            public ProductionStatus goingToJobSite() {
                return GOING_TO_JOB;
            }

            @Override
            public ProductionStatus noJobSite() {
                return NO_JOBSITE;
            }

            @Override
            public ProductionStatus noSupplies() {
                return NO_SUPPLIES;
            }

            @Override
            public ProductionStatus collectingSupplies() {
                return COLLECTING_SUPPLIES;
            }

            @Override
            public ProductionStatus idle() {
                return IDLE;
            }

            @Override
            public ProductionStatus extractingProduct() {
                return EXTRACTING_PRODUCT;
            }

            @Override
            public ProductionStatus relaxing() {
                return RELAXING;
            }

            @Override
            public ProductionStatus waitingForTimedState() {
                return WAITING_FOR_TIMED_STATE;
            }

            @Override
            public ProductionStatus noWorkPossible() {
                return NO_WORK_POSSIBLE;
            }
        };
    }
}

