/*
 * Decompiled with CFR 0.152.
 */
package ca.bradj.questown.jobs.special;

import ca.bradj.questown.QT;
import ca.bradj.questown.integration.jobs.AfterInsertItemEvent;
import ca.bradj.questown.integration.jobs.JobPhaseModifier;
import ca.bradj.questown.mc.Compat;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.IItemHandler;
import org.jetbrains.annotations.Nullable;

public class AddItemToContainerSpecialRule
extends JobPhaseModifier {
    @Override
    @Nullable
    public <CONTEXT> CONTEXT afterInsertItem(CONTEXT ctxInput, AfterInsertItemEvent<CONTEXT> event) {
        CONTEXT ctxOut = super.afterInsertItem(ctxInput, event);
        BlockPos ws = event.workSpot().workPosition();
        BlockEntity be = event.level().m_7702_(ws);
        LazyOptional cap = be.getCapability(ForgeCapabilities.ITEM_HANDLER);
        if (cap == null || !cap.isPresent()) {
            QT.JOB_LOGGER.error("Work spot cannot accept items. " + this.getClass().getName() + " will not succeed.");
            return ctxOut;
        }
        Optional res = cap.resolve();
        if (res.isEmpty()) {
            QT.JOB_LOGGER.error("Work spot cannot accept items. " + this.getClass().getName() + " will not succeed. (2)");
            return ctxOut;
        }
        int amount = 1;
        if (!Compat.insertInNextOpenSlot((IItemHandler)res.get(), event.inserted(), amount)) {
            QT.JOB_LOGGER.error("Item lost due to not enough space in target container @ {}: {}", (Object)ws, (Object)event.inserted());
        }
        return ctxOut;
    }
}

