/*
 * Decompiled with CFR 0.152.
 */
package ca.bradj.questown.jobs.special;

import ca.bradj.questown.InventoryFullStrategy;
import ca.bradj.questown.QT;
import ca.bradj.questown.integration.jobs.BeforeExtractEvent;
import ca.bradj.questown.integration.jobs.JobPhaseModifier;
import ca.bradj.questown.integration.minecraft.MCHeldItem;
import ca.bradj.questown.mc.Compat;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.BushBlock;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.Nullable;

public class DestroyBushSpecialRule
extends JobPhaseModifier {
    public <X> X beforeExtract(X context, BeforeExtractEvent<X> event) {
        BlockPos pos;
        ServerLevel level = event.level();
        BlockState bs = level.m_8055_(pos = event.workSpot());
        if (!(bs.m_60734_() instanceof BushBlock)) {
            QT.JOB_LOGGER.error("Block at {} is not a bush. Special rule failed to apply. [{}]", (Object)pos, (Object)bs);
            return null;
        }
        List drops = BushBlock.m_49869_((BlockState)bs, (ServerLevel)level, (BlockPos)pos, null);
        X nextContext = context;
        X outContext = null;
        for (ItemStack i : drops) {
            @Nullable X o = event.entity().tryGiveItem(nextContext, MCHeldItem.fromMCItemStack(i), InventoryFullStrategy.DROP_ON_GROUND);
            if (o == null) continue;
            nextContext = o;
            outContext = o;
        }
        level.m_7471_(pos, true);
        Compat.playNeutralSound(level, pos, SoundEvents.f_11988_);
        return outContext;
    }
}

