/*
 * Decompiled with CFR 0.152.
 */
package ca.bradj.questown.jobs.special;

import ca.bradj.questown.InventoryFullStrategy;
import ca.bradj.questown.QT;
import ca.bradj.questown.integration.jobs.BeforeExtractEvent;
import ca.bradj.questown.integration.jobs.JobPhaseModifier;
import ca.bradj.questown.integration.minecraft.MCHeldItem;
import ca.bradj.questown.mc.Compat;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.CropBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.Nullable;

public class HarvestCropSpecialRule
extends JobPhaseModifier {
    public <X> X beforeExtract(X context, BeforeExtractEvent<X> event) {
        BlockPos cropBlock;
        ServerLevel level = event.level();
        BlockState bs = level.m_8055_(cropBlock = event.workSpot());
        Block block = bs.m_60734_();
        if (!(block instanceof CropBlock)) {
            QT.JOB_LOGGER.error("Block at {} is not a crop. Special rule failed to apply. [{}]", (Object)cropBlock, (Object)bs);
            return null;
        }
        CropBlock cb = (CropBlock)block;
        if (!cb.m_52307_(bs)) {
            QT.JOB_LOGGER.error("Crop block at {} is not full age. Special rule failed to apply. [{}]", (Object)cropBlock, (Object)bs);
            return null;
        }
        List drops = CropBlock.m_49869_((BlockState)bs, (ServerLevel)level, (BlockPos)cropBlock, null);
        X nextContext = context;
        X outContext = null;
        for (ItemStack i : drops) {
            @Nullable X o = event.entity().tryGiveItem(nextContext, MCHeldItem.fromMCItemStack(i), InventoryFullStrategy.DROP_ON_GROUND);
            if (o == null) continue;
            nextContext = o;
            outContext = o;
        }
        bs = (BlockState)bs.m_61124_((Property)CropBlock.f_52244_, (Comparable)Integer.valueOf(0));
        level.m_7731_(cropBlock, bs, 10);
        Compat.playNeutralSound(level, cropBlock, SoundEvents.f_11838_);
        return outContext;
    }
}

