/*
 * Decompiled with CFR 0.152.
 */
package ca.bradj.questown.jobs.special;

import ca.bradj.questown.integration.jobs.BeforeInitEvent;
import ca.bradj.questown.integration.jobs.JobPhaseModifier;
import ca.bradj.questown.jobs.special.WorkSpotFromHeldItemSpecialRule;
import ca.bradj.questown.mc.Compat;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.Container;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.ChestBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.IItemHandler;
import org.jetbrains.annotations.Nullable;

public class RequireTwoFreeSpotsSpecialRule
extends JobPhaseModifier {
    @Override
    public void beforeInit(BeforeInitEvent bxEvent) {
        super.beforeInit(bxEvent);
        bxEvent.jobBlockCheckReplacer().accept(before -> ctx -> {
            BlockEntity entity = bxEvent.level().get().m_7702_(ctx.blockPos());
            if (entity == null) {
                return false;
            }
            LazyOptional itemHandler = entity.getCapability(Compat.ITEM_HANDLER);
            if (!itemHandler.isPresent()) {
                return false;
            }
            Optional resolve = itemHandler.resolve();
            if (resolve.isEmpty()) {
                return false;
            }
            IItemHandler handler = (IItemHandler)resolve.get();
            if (RequireTwoFreeSpotsSpecialRule.hasTwoFreeSlots(handler.getSlots(), arg_0 -> ((IItemHandler)handler).getStackInSlot(arg_0))) {
                return before.test(ctx);
            }
            return false;
        });
        bxEvent.supplyRoomCheckReplacer().accept(before -> (heldItems, room) -> {
            @Nullable BlockPos jBlock = WorkSpotFromHeldItemSpecialRule.getJobBlockPositionFromHeldItems(heldItems);
            for (Map.Entry b : room.getContainedBlocks().entrySet()) {
                ServerLevel serverLevel;
                ChestBlock cb;
                Container cont;
                if (jBlock != null && !jBlock.equals(b.getKey())) {
                    return before.test(heldItems, room);
                }
                Object patt2306$temp = b.getValue();
                if (!(patt2306$temp instanceof ChestBlock) || (cont = ChestBlock.m_51511_((ChestBlock)(cb = (ChestBlock)patt2306$temp), (BlockState)(serverLevel = bxEvent.level().get()).m_8055_((BlockPos)b.getKey()), (Level)serverLevel, (BlockPos)((BlockPos)b.getKey()), (boolean)true)) == null || !RequireTwoFreeSpotsSpecialRule.hasTwoFreeSlots(cont.m_6643_(), arg_0 -> ((Container)cont).m_8020_(arg_0))) continue;
                return before.test(heldItems, room);
            }
            return false;
        });
    }

    private static boolean hasTwoFreeSlots(int slots, Function<Integer, ItemStack> getStack) {
        int emptySpots = 0;
        for (int i = 0; i < slots; ++i) {
            if (getStack.apply(i).m_41619_()) {
                ++emptySpots;
            }
            if (emptySpots <= 1) continue;
            return true;
        }
        return false;
    }
}

