/*
 * Decompiled with CFR 0.152.
 */
package ca.bradj.questown.jobs.special;

import ca.bradj.questown.core.UtilClean;
import ca.bradj.questown.integration.jobs.AfterDropLootEvent;
import ca.bradj.questown.integration.jobs.BeforeInitEvent;
import ca.bradj.questown.integration.jobs.BeforeTickEvent;
import ca.bradj.questown.integration.jobs.JobPhaseModifier;
import ca.bradj.questown.integration.minecraft.MCHeldItem;
import ca.bradj.questown.items.StockRequestItem;
import ca.bradj.questown.jobs.production.RoomsNeedingVillagerInput;
import ca.bradj.roomrecipes.adapter.IRoomRecipeMatch;
import ca.bradj.roomrecipes.serialization.MCRoom;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class WorkSpotFromHeldItemSpecialRule
extends JobPhaseModifier {
    @Override
    public void beforeTick(BeforeTickEvent bxEvent) {
        super.beforeTick(bxEvent);
        @Nullable MCRoom room = WorkSpotFromHeldItemSpecialRule.getRoomFromHeldItems(bxEvent.heldItems());
        @Nullable BlockPos pos = WorkSpotFromHeldItemSpecialRule.getJobBlockPositionFromHeldItems(bxEvent.heldItems());
        if (room == null || pos == null) {
            return;
        }
        bxEvent.replaceRoomCheck().accept(before -> {
            HashMap<Integer, ImmutableList> b = new HashMap<Integer, ImmutableList>();
            int state = bxEvent.getJobBlockState().apply(pos).processingState();
            Collection<RoomsNeedingVillagerInput.NVIRoom<MCRoom, ResourceLocation, BlockPos>> stateRooms = UtilClean.getOrDefaultCollection(b, state, new ArrayList(), true);
            stateRooms.add(WorkSpotFromHeldItemSpecialRule.match(bxEvent, pos, room));
            b.put(state, ImmutableList.copyOf(stateRooms));
            return new RoomsNeedingVillagerInput(ImmutableMap.copyOf(b));
        });
    }

    @Override
    public void beforeInit(BeforeInitEvent bxEvent) {
        super.beforeInit(bxEvent);
        bxEvent.jobBlockCheckReplacer().accept(old -> ctx -> {
            @Nullable BlockPos block = WorkSpotFromHeldItemSpecialRule.getJobBlockPositionFromHeldItems(ctx.heldItems().get());
            if (block == null) {
                return old.test(ctx);
            }
            return block.equals((Object)ctx.blockPos());
        });
        bxEvent.supplyRoomCheckReplacer().accept(old -> (heldItems, match) -> {
            @Nullable MCRoom room = WorkSpotFromHeldItemSpecialRule.getRoomFromHeldItems(heldItems);
            if (room == null) {
                return old.test(heldItems, match);
            }
            return !((MCRoom)match.room).equals((Object)room);
        });
    }

    @NotNull
    private static RoomsNeedingVillagerInput.NVIRoom<MCRoom, ResourceLocation, BlockPos> match(final BeforeTickEvent bxEvent, final @Nullable BlockPos pos, final @Nullable MCRoom room) {
        return new RoomsNeedingVillagerInput.NVIRoom<MCRoom, ResourceLocation, BlockPos>(new IRoomRecipeMatch<MCRoom, ResourceLocation, BlockPos, Object>(){

            public ImmutableList<ResourceLocation> getRecipeIDs() {
                return ImmutableList.of((Object)bxEvent.locInfo().baseRoom());
            }

            public MCRoom getRoom() {
                return room;
            }

            public ImmutableMap<BlockPos, Object> getContainedBlocks() {
                return ImmutableMap.of((Object)pos, (Object)true);
            }
        }, false);
    }

    @Nullable
    public static MCRoom getRoomFromHeldItems(Collection<MCHeldItem> mcHeldItems) {
        for (MCHeldItem i : mcHeldItems) {
            MCRoom room;
            if (!(i.get().get() instanceof StockRequestItem) || (room = StockRequestItem.getRoom(i.getItemNBTData())) == null) continue;
            return room;
        }
        return null;
    }

    @Nullable
    public static BlockPos getJobBlockPositionFromHeldItems(Collection<MCHeldItem> mcHeldItems) {
        for (MCHeldItem i : mcHeldItems) {
            BlockPos room;
            if (!(i.get().get() instanceof StockRequestItem) || (room = StockRequestItem.getJobBlock(i.getItemNBTData())) == null) continue;
            return room;
        }
        return null;
    }

    @Override
    @Nullable
    public <CONTEXT> CONTEXT afterDropLoot(CONTEXT ctxInput, AfterDropLootEvent event) {
        CONTEXT ctx = super.afterDropLoot(ctxInput, event);
        ArrayList<MCHeldItem> itemsDropped = new ArrayList<MCHeldItem>();
        for (MCHeldItem mcHeldItem : event.itemsBeforeDrop()) {
            if (event.itemsAfterDrop().contains((Object)mcHeldItem)) continue;
            itemsDropped.add(mcHeldItem);
        }
        @Nullable BlockPos jbp = WorkSpotFromHeldItemSpecialRule.getJobBlockPositionFromHeldItems(itemsDropped);
        if (jbp == null) {
            return ctx;
        }
        event.clearStatus().accept(jbp);
        return ctx;
    }
}

