/*
 * Decompiled with CFR 0.152.
 */
package ca.bradj.questown.logic;

import ca.bradj.questown.QT;
import ca.bradj.questown.core.RecipeItemConfig;
import ca.bradj.questown.mc.Compat;
import ca.bradj.questown.town.special.SpecialQuests;
import ca.bradj.roomrecipes.recipes.RecipesInit;
import ca.bradj.roomrecipes.recipes.RoomRecipe;
import com.electronwill.nightconfig.core.Config;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.gson.JsonObject;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.minecraft.core.NonNullList;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.BedItem;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;

public class RoomRecipes {
    public static Collection<Ingredient> filterSpecialBlocks(Iterable<Ingredient> ingredients) {
        ImmutableList.Builder b = ImmutableList.builder();
        boolean foundBed = false;
        for (Ingredient i : ingredients) {
            if (foundBed) {
                foundBed = false;
                continue;
            }
            if (i.m_43908_()[0].m_41720_() instanceof BedItem) {
                foundBed = true;
            }
            b.add((Object)i);
        }
        return b.build();
    }

    public static Optional<RoomRecipe> getById(Level level, ResourceLocation id) {
        List<RoomRecipe> recipes = RoomRecipes.getAllRecipes(level);
        for (RoomRecipe r : recipes) {
            if (!id.equals((Object)r.m_6423_())) continue;
            return Optional.of(r);
        }
        return Optional.empty();
    }

    @NotNull
    public static List<RoomRecipe> getAllRecipes(Level level) {
        return level.m_7465_().m_44013_(RecipesInit.ROOM);
    }

    public static Component getName(ResourceLocation id) {
        if (id.m_135815_().startsWith("special_quest")) {
            return Compat.translatable(id.m_135815_());
        }
        return Compat.translatable(String.format("room.%s", id.m_135815_()));
    }

    public static Component getName(Optional<ResourceLocation> recipe) {
        return recipe.map(RoomRecipes::getName).orElseGet(() -> Compat.translatable("room.no_recipe"));
    }

    public static Map<ResourceLocation, RoomRecipe> hydrate(RecipeManager recipes, boolean includeSpecial) {
        ImmutableMap.Builder rMapB = ImmutableMap.builder();
        if (includeSpecial) {
            SpecialQuests.SPECIAL_QUESTS.forEach((arg_0, arg_1) -> ((ImmutableMap.Builder)rMapB).put(arg_0, arg_1));
        } else {
            rMapB.put((Object)SpecialQuests.FARM, (Object)SpecialQuests.SPECIAL_QUESTS.get(SpecialQuests.FARM));
        }
        List allRecipesFor = recipes.m_44013_(RecipesInit.ROOM);
        allRecipesFor.forEach(v -> rMapB.put((Object)v.m_6423_(), v));
        return rMapB.build();
    }

    public static int getRecipeWeight(RoomRecipe recipe, int stopAt) {
        Config allWeights = (Config)RecipeItemConfig.itemWeights.get();
        int weight = 0;
        for (Ingredient in : recipe.m_7527_()) {
            String id;
            if (weight > stopAt) {
                return weight;
            }
            boolean foundWeight = false;
            if (RoomRecipes.getAsJsonObject(in).has("item")) {
                id = RoomRecipes.getAsJsonObject(in).get("item").getAsString();
                if (allWeights.contains(String.format("%s", id))) {
                    weight += allWeights.getInt(id);
                    foundWeight = true;
                } else {
                    QT.QUESTS_LOGGER.error("No weight specified for item. Default of 100 will be used. [{}]", (Object)id);
                }
            }
            if (RoomRecipes.getAsJsonObject(in).has("tag")) {
                id = RoomRecipes.getAsJsonObject(in).get("tag").getAsString();
                String tID = String.format("#%s", id);
                if (allWeights.contains(tID)) {
                    weight += allWeights.getInt(tID);
                    foundWeight = true;
                } else {
                    QT.QUESTS_LOGGER.error("No weight specified for tag. Default of 100 will be used. [{}]", (Object)id);
                }
            }
            if (foundWeight) continue;
            weight += Compat.configGet(ca.bradj.questown.core.Config.DEFAULT_ITEM_WEIGHT).get().intValue();
        }
        return weight;
    }

    private static JsonObject getAsJsonObject(Ingredient js) {
        try {
            return js.m_43942_().getAsJsonObject();
        }
        catch (IllegalStateException e) {
            throw new IllegalStateException("Not a JSON object: " + String.valueOf(js), e);
        }
    }

    public static boolean containsAllTags(Iterable<? extends List<String>> haystack, Iterable<? extends List<String>> needles) {
        boolean found = false;
        for (List<String> list : haystack) {
            boolean iFound = false;
            for (List<String> list2 : needles) {
                if (iFound || !list.containsAll(list2)) continue;
                iFound = true;
            }
            if (iFound) {
                found = true;
                continue;
            }
            return false;
        }
        return found;
    }

    public static RoomRecipe standard(@NotNull ResourceLocation roomId, NonNullList<Ingredient> of) {
        return new RoomRecipe(roomId, of, 1, false);
    }
}

