/*
 * Decompiled with CFR 0.152.
 */
package ca.bradj.questown.logic;

import ca.bradj.questown.jobs.Item;
import ca.bradj.questown.logic.IPredicateCollection;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;

public class TownContainerChecks {
    public static <ITEM extends Item<ITEM>, STATUS> boolean townHasSupplies(Collection<STATUS> statesWithRooms, Map<STATUS, ? extends Predicate<ITEM>> ingredientsRequiredAtStates, Map<STATUS, Integer> ingredientQtyRequiredAtStates, Function<Predicate<ITEM>, Collection<ITEM>> getItemMatchesInTown, Function<Predicate<ITEM>, Collection<ITEM>> getItemMatchesInInventory) {
        boolean anyRequirementsExist = false;
        for (Object level : statesWithRooms) {
            Integer quantityRequired = ingredientQtyRequiredAtStates.get(level);
            if (quantityRequired == null) continue;
            anyRequirementsExist = true;
            Predicate<Item> isUsableItem = item -> {
                Predicate isWorkIngredient = (Predicate)ingredientsRequiredAtStates.get(level);
                if (isWorkIngredient == null) {
                    return false;
                }
                return isWorkIngredient.test(item);
            };
            if (!TownContainerChecks.townHasSuppliesForStage(pred -> {
                ImmutableList.Builder b = ImmutableList.builder();
                b.addAll((Iterable)getItemMatchesInInventory.apply((Predicate)pred));
                b.addAll((Iterable)getItemMatchesInTown.apply((Predicate)pred));
                return b.build();
            }, isUsableItem, quantityRequired, false)) continue;
            return true;
        }
        return !anyRequirementsExist;
    }

    static <ITEM extends Item<ITEM>> boolean townHasSuppliesForStage(Function<Predicate<ITEM>, Collection<ITEM>> itemMatchesInTownOrHand, Predicate<ITEM> initialMatchCriteria, int quantityRequired, boolean mustAllBeSame) {
        Collection<ITEM> matchingItems = itemMatchesInTownOrHand.apply(initialMatchCriteria);
        if (matchingItems.isEmpty()) {
            return false;
        }
        if (!mustAllBeSame) {
            return true;
        }
        for (Item i : matchingItems) {
            Collection<ITEM> sameAsI = itemMatchesInTownOrHand.apply(i::equals);
            Integer reduce = sameAsI.stream().map(Item::quantity).reduce(Integer::sum).orElse(0);
            if (reduce < quantityRequired) continue;
            return true;
        }
        return false;
    }

    public static <ITEM extends Item<ITEM>, STATUS> boolean hasSupplies(Supplier<Set<STATUS>> roomsToGetSuppliesForByState, Map<STATUS, Predicate<ITEM>> ingredientsRequiredAtStates, Map<STATUS, Integer> ingredientQtyRequiredAtStates, Map<STATUS, IPredicateCollection<ITEM>> toolsRequiredAtStates, Function<Predicate<ITEM>, Collection<ITEM>> getItemMatchesInTown, Function<STATUS, Collection<String>> specialRules, Predicate<ITEM> isWorkResult) {
        return TownContainerChecks.hasSupplies(roomsToGetSuppliesForByState, ingredientsRequiredAtStates, ingredientQtyRequiredAtStates, toolsRequiredAtStates, getItemMatchesInTown, i -> ImmutableList.of(), specialRules, isWorkResult);
    }

    public static <ITEM extends Item<ITEM>, STATUS> boolean hasSupplies(Supplier<Set<STATUS>> roomsToGetSuppliesForByState, Map<STATUS, Predicate<ITEM>> ingredientsRequiredAtStates, Map<STATUS, Integer> ingredientQtyRequiredAtStates, Map<STATUS, IPredicateCollection<ITEM>> toolsRequiredAtStates, Function<Predicate<ITEM>, Collection<ITEM>> getItemMatchesInTown, Function<Predicate<ITEM>, Collection<ITEM>> getItemMatchesInInventory, Function<STATUS, Collection<String>> specialRules, Predicate<ITEM> isWorkResult) {
        Set<STATUS> statesWithRooms = roomsToGetSuppliesForByState.get();
        ImmutableMap.Builder oneTool = ImmutableMap.builder();
        toolsRequiredAtStates.forEach((k, v) -> {
            if (!v.isEmpty()) {
                oneTool.put(k, (Object)1);
            }
        });
        boolean townHasTools = TownContainerChecks.townHasTools(statesWithRooms, toolsRequiredAtStates, getItemMatchesInTown, getItemMatchesInInventory, specialRules);
        if (!townHasTools) {
            return false;
        }
        return TownContainerChecks.townHasSupplies(statesWithRooms, ingredientsRequiredAtStates, ingredientQtyRequiredAtStates, getItemMatchesInTown, getItemMatchesInInventory);
    }

    public static <STATUS, ITEM extends Item<ITEM>> boolean townHasTools(Set<STATUS> statesWithRooms, Map<STATUS, IPredicateCollection<ITEM>> toolsRequiredAtStates, Function<Predicate<ITEM>, Collection<ITEM>> getItemMatchesInTown, Function<Predicate<ITEM>, Collection<ITEM>> getItemMatchesInInventory, Function<STATUS, Collection<String>> specialRules) {
        ImmutableMap.Builder oneTool = ImmutableMap.builder();
        toolsRequiredAtStates.forEach((k, v) -> {
            if (!v.isEmpty()) {
                oneTool.put(k, (Object)1);
            }
        });
        return TownContainerChecks.townHasSupplies(statesWithRooms, toolsRequiredAtStates, oneTool.build(), getItemMatchesInTown, getItemMatchesInInventory);
    }
}

