/*
 * Decompiled with CFR 0.152.
 */
package ca.bradj.questown.logic;

import ca.bradj.questown.jobs.production.ProductionStatus;
import ca.bradj.questown.jobs.production.TownNeedsMap;
import ca.bradj.questown.logic.Emptyable;
import ca.bradj.questown.town.workstatus.State;
import ca.bradj.roomrecipes.adapter.RoomWithBlocks;
import ca.bradj.roomrecipes.core.Room;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TownNeeds {
    public static <POS, BLOCK> TownNeedsMap<ProductionStatus> getRoomsNeedingIngredientsOrTools(Map<ProductionStatus, ? extends Emptyable> ingredientsRequiredAtStates, Map<ProductionStatus, Integer> ingredientQtyRequiredAtStates, Map<ProductionStatus, ? extends Emptyable> toolsRequiredAtStates, Function<ProductionStatus, @NotNull Collection<? extends RoomWithBlocks<? extends Room, POS, BLOCK>>> roomsWithState, Map<ProductionStatus, ? extends Collection<? extends Room>> roomsWhereSpecialRulesApply, Function<POS, @Nullable State> states, Predicate<POS> canClaim, Function<ProductionStatus, @Nullable Boolean> hasRequiredTool, int maxState) {
        ImmutableMap.Builder workable = ImmutableMap.builder();
        ImmutableMap.Builder suppliable = ImmutableMap.builder();
        boolean prevToolStatus = true;
        for (int i = 0; i <= maxState; ++i) {
            ArrayList forSuppliable = new ArrayList();
            ArrayList forWorkable = new ArrayList();
            Consumer<Collection> addToSupply = forSuppliable::addAll;
            Consumer<Collection> addToWorks = forWorkable::addAll;
            ProductionStatus s = ProductionStatus.fromJobBlockStatus(i);
            Emptyable ingr = ingredientsRequiredAtStates.get(s);
            Emptyable tool = toolsRequiredAtStates.get(s);
            Collection<Room> specialRooms = TownNeeds.getRooms(roomsWhereSpecialRulesApply, s);
            if (ingr == null && tool == null) {
                workable.put((Object)s, (Object)ImmutableList.copyOf(specialRooms));
                suppliable.put((Object)s, (Object)ImmutableList.copyOf(specialRooms));
                continue;
            }
            boolean iPrev = prevToolStatus;
            Boolean iTool = hasRequiredTool.apply(s);
            boolean hasRequiredToolForStage = prevToolStatus;
            if (iTool != null) {
                prevToolStatus = iTool;
                hasRequiredToolForStage = iTool;
            }
            if (ingr == null) {
                ingr = () -> true;
            }
            if (!hasRequiredToolForStage) {
                addToWorks = x -> {};
            }
            Collection<RoomWithBlocks<Room, POS, BLOCK>> matches = roomsWithState.apply(s);
            int ii = i;
            List<Room> roomz = matches.stream().filter(room -> {
                for (Map.Entry e : room.containedBlocks.entrySet()) {
                    Integer qtyReq;
                    State jobBlockState = (State)states.apply(e.getKey());
                    if (jobBlockState == null || jobBlockState.processingState() != ii || !canClaim.test(e.getKey()) || (qtyReq = (Integer)ingredientQtyRequiredAtStates.get(s)) != null && qtyReq != 0 && jobBlockState.ingredientCount() >= qtyReq) continue;
                    return true;
                }
                return false;
            }).map(v -> (Room)v.room).toList();
            addToWorks.accept(roomz);
            addToSupply.accept(roomz);
            Collection<Room> sr = specialRooms;
            if (sr != null) {
                addToSupply.accept(sr);
                addToWorks.accept(sr);
            }
            workable.put((Object)s, (Object)ImmutableList.copyOf(forWorkable));
            suppliable.put((Object)s, (Object)ImmutableList.copyOf(forSuppliable));
        }
        return new TownNeedsMap<ProductionStatus>((Map<ProductionStatus, ImmutableList<Room>>)workable.build(), (Map<ProductionStatus, ImmutableList<Room>>)suppliable.build());
    }

    private static Collection<Room> getRooms(Map<ProductionStatus, ? extends Collection<? extends Room>> roomsWhereSpecialRulesApply, ProductionStatus s) {
        Collection<? extends Room> x = roomsWhereSpecialRulesApply.get(s);
        if (x == null) {
            return ImmutableList.of();
        }
        ImmutableList.Builder b = ImmutableList.builder();
        x.forEach(arg_0 -> ((ImmutableList.Builder)b).add(arg_0));
        return b.build();
    }
}

