/*
 * Decompiled with CFR 0.152.
 */
package ca.bradj.questown.mc;

import ca.bradj.questown.integration.minecraft.MCHeldItem;
import ca.bradj.questown.integration.minecraft.MCTownItem;
import ca.bradj.questown.logic.IPredicateCollection;
import ca.bradj.questown.logic.MonoPredicateCollection;
import ca.bradj.questown.logic.PredicateCollection;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.function.Predicate;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;

public class PredicateCollections {
    public static PredicateCollection<MCHeldItem, ItemStack> fromMCIngredient(final Ingredient v) {
        return PredicateCollection.wrap(new IPredicateCollection<ItemStack>(){

            @Override
            public boolean isEmpty() {
                return v.m_43947_();
            }

            @Override
            public boolean test(ItemStack itemStack) {
                return v.test(itemStack);
            }
        }, IPredicateCollection::isEmpty, (ingr, item) -> ingr.test(item.get().toQTItemStack()), "MC.Ingredient " + String.valueOf(v.m_43942_()));
    }

    public static PredicateCollection<MCHeldItem, MCHeldItem> fromMCIngredient2(final Ingredient v) {
        return PredicateCollection.wrap(new IPredicateCollection<MCHeldItem>(){

            @Override
            public boolean isEmpty() {
                return v.m_43947_();
            }

            @Override
            public boolean test(MCHeldItem itemStack) {
                return v.test(itemStack.get().toQTItemStack());
            }
        }, IPredicateCollection::isEmpty, Predicate::test, "MC.Ingredient " + String.valueOf(v.m_43942_()));
    }

    public static PredicateCollection<MCTownItem, ?> townify(final PredicateCollection<MCHeldItem, ?> v) {
        return PredicateCollection.wrap(new IPredicateCollection<MCTownItem>(){

            @Override
            public boolean isEmpty() {
                return v.isEmpty();
            }

            @Override
            public boolean test(MCTownItem itemStack) {
                return v.test(MCHeldItem.fromTown(itemStack));
            }

            public String toString() {
                return v.toString();
            }
        }, IPredicateCollection::isEmpty, Predicate::test, "Town-as-Held");
    }

    public static Map<Integer, PredicateCollection<MCHeldItem, ItemStack>> fromMCIngredientMap(ImmutableMap<Integer, Ingredient> in) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        in.forEach((k, v) -> builder.put(k, PredicateCollections.fromMCIngredient(v)));
        return builder.build();
    }

    public static <X> MonoPredicateCollection<X> fromSimple(final Predicate<X> simple) {
        return new MonoPredicateCollection(new IPredicateCollection<X>(){

            @Override
            public boolean isEmpty() {
                return false;
            }

            @Override
            public boolean test(X x) {
                return simple.test(x);
            }
        }, "from simple predicate");
    }

    public static <X> MonoPredicateCollection<X> fromSimpleEqualityCheck(X value) {
        return PredicateCollections.fromSimple(value::equals);
    }
}

