/*
 * Decompiled with CFR 0.152.
 */
package ca.bradj.questown.mobs.visitor;

import ca.bradj.questown.QT;
import ca.bradj.questown.core.Config;
import ca.bradj.questown.jobs.IStatus;
import ca.bradj.questown.jobs.Jobs;
import ca.bradj.questown.jobs.production.IProductionStatus;
import ca.bradj.questown.mc.Compat;
import ca.bradj.questown.mobs.visitor.VisitorMobEntity;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.Brain;
import net.minecraft.world.entity.ai.behavior.Behavior;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import net.minecraft.world.entity.ai.memory.WalkTarget;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.ai.util.DefaultRandomPos;
import net.minecraft.world.level.pathfinder.Path;
import net.minecraft.world.phys.Vec3;

public class MoveToTownTargetSink
extends Behavior<Mob> {
    private static final int MAX_COOLDOWN_BEFORE_RETRYING = 5;
    private int remainingCooldown;
    @Nullable
    private Path path;
    @Nullable
    private BlockPos lastTargetPos;
    private float speedModifier;
    private BlockPos entityPrevPos;
    private int stuckTicks;
    private BlockPos entityPrevPosLastUnstick;
    private int reallyStuckTicks;

    public MoveToTownTargetSink() {
        this(Compat.configGet(Config.WANDER_GIVEUP_TICKS).get(), Compat.configGet(Config.WANDER_GIVEUP_TICKS).get());
    }

    public MoveToTownTargetSink(int p_23573_, int p_23574_) {
        super((Map)ImmutableMap.of((Object)MemoryModuleType.f_26326_, (Object)MemoryStatus.REGISTERED, (Object)MemoryModuleType.f_26377_, (Object)MemoryStatus.VALUE_ABSENT, (Object)MemoryModuleType.f_26370_, (Object)MemoryStatus.VALUE_PRESENT), p_23573_, p_23574_);
    }

    protected boolean doCheckExtraStartConditions(ServerLevel p_23583_, Mob p_23584_) {
        if (this.remainingCooldown > 0) {
            --this.remainingCooldown;
            return false;
        }
        Brain brain = p_23584_.m_6274_();
        WalkTarget walktarget = (WalkTarget)brain.m_21952_(MemoryModuleType.f_26370_).get();
        boolean flag = this.reachedTarget(p_23584_, walktarget);
        if (!flag && this.tryComputePath(p_23584_, walktarget, p_23583_.m_46467_())) {
            this.lastTargetPos = walktarget.m_26420_().m_6675_();
            return true;
        }
        brain.m_21936_(MemoryModuleType.f_26370_);
        if (flag) {
            brain.m_21936_(MemoryModuleType.f_26326_);
        }
        return false;
    }

    protected boolean checkExtraStartConditions(ServerLevel p_23583_, Mob p_23584_) {
        p_23584_.m_21573_().m_26529_(10.0f);
        boolean b = this.doCheckExtraStartConditions(p_23583_, p_23584_);
        p_23584_.m_21573_().m_26566_();
        return b;
    }

    protected boolean canStillUse(ServerLevel p_23586_, Mob p_23587_, long p_23588_) {
        if (this.path != null && this.lastTargetPos != null) {
            Optional optional = p_23587_.m_6274_().m_21952_(MemoryModuleType.f_26370_);
            PathNavigation pathnavigation = p_23587_.m_21573_();
            return !pathnavigation.m_26571_() && optional.isPresent() && !this.reachedTarget(p_23587_, (WalkTarget)optional.get());
        }
        return false;
    }

    protected void stop(ServerLevel p_23601_, Mob p_23602_, long p_23603_) {
        if (p_23602_.m_6274_().m_21874_(MemoryModuleType.f_26370_) && !this.reachedTarget(p_23602_, (WalkTarget)p_23602_.m_6274_().m_21952_(MemoryModuleType.f_26370_).get()) && p_23602_.m_21573_().m_26577_()) {
            this.remainingCooldown = p_23601_.m_213780_().m_188503_(5);
        }
        p_23602_.m_21573_().m_26573_();
        p_23602_.m_6274_().m_21936_(MemoryModuleType.f_26370_);
        p_23602_.m_6274_().m_21936_(MemoryModuleType.f_26377_);
        this.path = null;
    }

    protected void start(ServerLevel p_23609_, Mob p_23610_, long p_23611_) {
        p_23610_.m_6274_().m_21879_(MemoryModuleType.f_26377_, (Object)this.path);
        p_23610_.m_21573_().m_26536_(this.path, (double)this.speedModifier);
    }

    protected void tick(ServerLevel p_23617_, Mob p_23618_, long p_23619_) {
        WalkTarget walktarget;
        Path path = p_23618_.m_21573_().m_26570_();
        Brain brain = p_23618_.m_6274_();
        if (this.path != path) {
            this.path = path;
            brain.m_21879_(MemoryModuleType.f_26377_, (Object)path);
        }
        if (path != null && this.lastTargetPos != null && (walktarget = (WalkTarget)brain.m_21952_(MemoryModuleType.f_26370_).get()).m_26420_().m_6675_().m_123331_((Vec3i)this.lastTargetPos) > 4.0 && this.tryComputePath(p_23618_, walktarget, p_23617_.m_46467_())) {
            this.lastTargetPos = walktarget.m_26420_().m_6675_();
            this.start(p_23617_, p_23618_, p_23619_);
        }
        if (!(p_23618_ instanceof VisitorMobEntity)) {
            return;
        }
        VisitorMobEntity vme = (VisitorMobEntity)p_23618_;
        IStatus<?> iStatus = vme.getStatusForServer();
        if (!(iStatus instanceof IProductionStatus)) {
            return;
        }
        IProductionStatus ps = (IProductionStatus)iStatus;
        if (!ps.shouldBeMoving()) {
            return;
        }
        BlockPos entityBlockPos = p_23618_.m_20183_();
        this.stuckTicks = this.entityPrevPos != null && Jobs.isCloseTo(entityBlockPos, this.entityPrevPos) ? ++this.stuckTicks : 0;
        this.reallyStuckTicks = this.entityPrevPosLastUnstick != null && Jobs.isCloseTo(entityBlockPos, this.entityPrevPosLastUnstick) ? ++this.reallyStuckTicks : 0;
        this.entityPrevPos = entityBlockPos;
        if (this.reallyStuckTicks > 200) {
            Direction unstickTarget = Compat.getRandomHorizontal(p_23617_);
            QT.JOB_LOGGER.debug("Unsticking from {} by pushing MORE in direction {}", (Object)entityBlockPos, (Object)unstickTarget);
            p_23618_.m_5997_((double)(unstickTarget.m_122429_() * 2), (double)(unstickTarget.m_122430_() * 2), (double)(unstickTarget.m_122431_() * 2));
            this.stuckTicks = 0;
            this.reallyStuckTicks = 0;
            brain.m_21936_(MemoryModuleType.f_26377_);
            return;
        }
        if (this.stuckTicks > 100) {
            this.entityPrevPosLastUnstick = entityBlockPos;
            Direction unstickTarget = Compat.getRandomHorizontal(p_23617_);
            QT.JOB_LOGGER.debug("Unsticking from {} by pushing in direction {}", (Object)entityBlockPos, (Object)unstickTarget);
            p_23618_.m_5997_((double)unstickTarget.m_122429_() * 0.5, (double)unstickTarget.m_122430_() * 0.5, (double)unstickTarget.m_122431_() * 0.5);
            this.stuckTicks = 0;
            brain.m_21936_(MemoryModuleType.f_26377_);
        }
    }

    private boolean tryComputePath(Mob p_23593_, WalkTarget p_23594_, long p_23595_) {
        BlockPos blockpos = p_23594_.m_26420_().m_6675_();
        this.path = p_23593_.m_21573_().m_7864_(blockpos, 0);
        this.speedModifier = p_23594_.m_26421_();
        Brain brain = p_23593_.m_6274_();
        if (this.reachedTarget(p_23593_, p_23594_)) {
            brain.m_21936_(MemoryModuleType.f_26326_);
        } else {
            boolean flag;
            boolean bl = flag = this.path != null && this.path.m_77403_();
            if (flag) {
                brain.m_21936_(MemoryModuleType.f_26326_);
            } else if (!brain.m_21874_(MemoryModuleType.f_26326_)) {
                brain.m_21879_(MemoryModuleType.f_26326_, (Object)p_23595_);
            }
            if (this.path != null) {
                return true;
            }
            Vec3 vec3 = DefaultRandomPos.m_148412_((PathfinderMob)((PathfinderMob)p_23593_), (int)10, (int)7, (Vec3)Vec3.m_82539_((Vec3i)blockpos), (double)1.5707963705062866);
            if (vec3 != null) {
                this.path = p_23593_.m_21573_().m_26524_(vec3.f_82479_, vec3.f_82480_, vec3.f_82481_, 0);
                return this.path != null;
            }
        }
        return false;
    }

    private boolean reachedTarget(Mob p_23590_, WalkTarget p_23591_) {
        return p_23591_.m_26420_().m_6675_().m_123333_((Vec3i)p_23590_.m_20183_()) <= p_23591_.m_26422_();
    }
}

