/*
 * Decompiled with CFR 0.152.
 */
package ca.bradj.questown.mobs.visitor;

import ca.bradj.questown.QT;
import ca.bradj.questown.mobs.visitor.VisitorMobEntity;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.ai.behavior.Behavior;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import net.minecraft.world.entity.ai.memory.WalkTarget;

public class TownWalk
extends Behavior<VisitorMobEntity> {
    private static final int REPEAT_BUFFER = 20;
    private static final int PAUSE_TICKS = 100;
    final float walkSpeed;
    private long nextUpdate;
    private BlockPos target;

    public TownWalk(float speedModifier) {
        super((Map)ImmutableMap.of((Object)MemoryModuleType.f_26370_, (Object)MemoryStatus.VALUE_ABSENT, (Object)MemoryModuleType.f_26338_, (Object)MemoryStatus.VALUE_PRESENT, (Object)MemoryModuleType.f_26326_, (Object)MemoryStatus.REGISTERED));
        this.walkSpeed = speedModifier;
    }

    protected boolean checkExtraStartConditions(ServerLevel level, VisitorMobEntity e) {
        if (e.isTickFrozen()) {
            return false;
        }
        if (e.m_6274_().m_21952_(MemoryModuleType.f_26370_).isPresent()) {
            return false;
        }
        if (level.m_46467_() - this.nextUpdate < 20L) {
            return false;
        }
        if (e.shouldStandStill()) {
            return false;
        }
        this.target = e.newWanderTarget();
        if (this.target == null) {
            return false;
        }
        QT.VILLAGER_LOGGER.trace("Visitor has chosen {} as their target [{}]", (Object)this.target, (Object)e.m_20148_());
        return true;
    }

    protected boolean canStillUse(ServerLevel level, VisitorMobEntity entity, long p_22547_) {
        if (entity.job.get().shouldStandStill()) {
            return false;
        }
        Optional since = entity.m_6274_().m_21952_(MemoryModuleType.f_26326_);
        if (since.isEmpty()) {
            entity.m_6274_().m_21879_(MemoryModuleType.f_26326_, (Object)level.m_46468_());
            return true;
        }
        long trying = level.m_46468_() - (Long)since.get();
        if (trying > 100L) {
            QT.VILLAGER_LOGGER.debug("Giving up on target because it took too long to get there");
            return false;
        }
        return true;
    }

    protected void start(ServerLevel lvl, VisitorMobEntity e, long p_23884_) {
        this.nextUpdate = lvl.m_46467_() + (long)lvl.m_213780_().m_188503_(20);
        BlockPos bp = this.target;
        int dist = 0;
        float speed = this.walkSpeed;
        double distToTarget = e.m_20183_().m_123331_((Vec3i)bp);
        if (distToTarget > 500.0) {
            speed *= 1.5f;
        }
        if (distToTarget > 1.0) {
            e.m_6274_().m_21879_(MemoryModuleType.f_26370_, (Object)new WalkTarget(bp, speed, dist));
        }
        e.m_6274_().m_21936_(MemoryModuleType.f_26338_);
        QT.VILLAGER_LOGGER.trace("{} navigating to {}", (Object)e.m_20148_(), (Object)bp);
        e.m_6274_().m_21879_(MemoryModuleType.f_26326_, (Object)lvl.m_46468_());
    }
}

