/*
 * Decompiled with CFR 0.152.
 */
package ca.bradj.questown.mobs.visitor;

import ca.bradj.questown.Questown;
import ca.bradj.questown.mobs.visitor.SpinningCubeLayer;
import ca.bradj.questown.mobs.visitor.VisitorArrowLayer;
import ca.bradj.questown.mobs.visitor.VisitorMobEntity;
import com.google.common.collect.ImmutableList;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.UUID;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.PlayerModel;
import net.minecraft.client.model.geom.ModelLayers;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.HumanoidMobRenderer;
import net.minecraft.client.resources.DefaultPlayerSkin;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Mob;

public class VisitorMobRenderer
extends HumanoidMobRenderer<VisitorMobEntity, PlayerModel<VisitorMobEntity>> {
    static ImmutableList<ResourceLocation> customSkins = ImmutableList.of((Object)Questown.ResourceLocation("textures/entity/1.png"), (Object)Questown.ResourceLocation("textures/entity/2.png"), (Object)Questown.ResourceLocation("textures/entity/3.png"), (Object)Questown.ResourceLocation("textures/entity/4.png"), (Object)Questown.ResourceLocation("textures/entity/5.png"), (Object)Questown.ResourceLocation("textures/entity/6.png"));

    public VisitorMobRenderer(EntityRendererProvider.Context ctx) {
        super(ctx, (HumanoidModel)new PlayerModel(ctx.m_174023_(ModelLayers.f_171166_), true), 0.5f);
        this.m_115326_(new VisitorArrowLayer(ctx, this));
        this.m_115326_(new SpinningCubeLayer(this));
    }

    public ResourceLocation getTextureLocation(VisitorMobEntity entity) {
        UUID uuid = entity.m_20148_();
        return VisitorMobRenderer.getTextureLocation(uuid);
    }

    public static ResourceLocation getTextureLocation(UUID uuid) {
        int index = Math.abs(uuid.hashCode()) % (customSkins.size() + 2);
        if (index < 2) {
            return DefaultPlayerSkin.m_118627_((UUID)uuid);
        }
        return (ResourceLocation)customSkins.get(index - 2);
    }

    public void render(VisitorMobEntity entity, float yaw, float pTicks, PoseStack stack, MultiBufferSource buffer, int light) {
        if (entity.isSitting()) {
            this.renderSiting(entity, yaw, pTicks, stack, buffer, light);
            return;
        }
        super.m_7392_((Mob)entity, yaw, pTicks, stack, buffer, light);
    }

    private void renderSiting(VisitorMobEntity entity, float entityYaw, float partialTicks, PoseStack matrixStack, MultiBufferSource buffer, int packedLight) {
        super.m_7392_((Mob)entity, entityYaw, partialTicks, matrixStack, buffer, packedLight);
        PlayerModel model = (PlayerModel)this.m_7200_();
        model.m_8009_(false);
        model.f_102808_.f_104207_ = true;
        model.f_102809_.f_104207_ = true;
        model.f_102810_.f_104207_ = true;
        model.f_102811_.f_104207_ = true;
        model.f_102812_.f_104207_ = true;
        model.f_102813_.f_104207_ = true;
        model.f_102814_.f_104207_ = true;
        model.f_102810_.f_104203_ = 1.4f;
        model.f_102810_.f_104201_ = 10.0f;
        model.f_102811_.f_104203_ = -0.5f;
        model.f_102811_.f_104204_ = -0.1f;
        model.f_102811_.f_104205_ = -1.5f;
        model.f_102811_.f_104201_ = 11.0f;
        model.f_102812_.f_104203_ = -0.5f;
        model.f_102812_.f_104204_ = 0.1f;
        model.f_102812_.f_104205_ = 1.5f;
        model.f_102812_.f_104201_ = 11.0f;
        model.f_102813_.f_104203_ = -1.5f;
        model.f_102813_.f_104201_ = 18.0f;
        model.f_102814_.f_104203_ = -1.5f;
        model.f_102814_.f_104201_ = 18.0f;
    }
}

