/*
 * Decompiled with CFR 0.152.
 */
package ca.bradj.questown.town;

import ca.bradj.questown.QT;
import ca.bradj.questown.logic.PredicateCollection;
import ca.bradj.questown.town.Claim;
import ca.bradj.questown.town.interfaces.WorkStatusHandle;
import ca.bradj.questown.town.workstatus.State;
import ca.bradj.roomrecipes.core.Room;
import ca.bradj.roomrecipes.core.space.InclusiveSpace;
import ca.bradj.roomrecipes.core.space.Position;
import ca.bradj.roomrecipes.logic.InclusiveSpaces;
import com.google.common.collect.ImmutableMap;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Supplier;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractWorkStatusStore<POS, ITEM, ROOM extends Room, TICK_SOURCE>
implements WorkStatusHandle<POS, ITEM> {
    private final Map<POS, Function<State, Boolean>> cascading = new HashMap<POS, Function<State, Boolean>>();
    private final BiFunction<ROOM, Position, Collection<POS>> posFactory;
    private final BiFunction<TICK_SOURCE, POS, Boolean> airCheck;
    private final BiFunction<TICK_SOURCE, POS, @Nullable State> defaultStateFactory;
    private final BiFunction<TICK_SOURCE, POS, @Nullable Function<State, Boolean>> cascadingBlockRevealer;
    private final HashSet<ROOM> rooms = new HashSet();
    private final HashMap<POS, State> jobStatuses = new HashMap();
    private final HashMap<POS, Long> timeJobStatuses = new HashMap();
    private final HashMap<POS, Claim> claims = new HashMap();
    int curIdx = 0;

    public AbstractWorkStatusStore(BiFunction<ROOM, Position, Collection<POS>> posFactory, BiFunction<TICK_SOURCE, POS, Boolean> airCheck, BiFunction<TICK_SOURCE, POS, @Nullable State> defaultStateFactory, BiFunction<TICK_SOURCE, POS, @Nullable Function<State, Boolean>> cascadingBlockRevealer) {
        this.posFactory = posFactory;
        this.airCheck = airCheck;
        this.defaultStateFactory = defaultStateFactory;
        this.cascadingBlockRevealer = cascadingBlockRevealer;
    }

    @Override
    public State getJobBlockState(POS bp) {
        return this.jobStatuses.get(bp);
    }

    @Override
    public Boolean setJobBlockState(POS bp, State bs) {
        this.modifyJobBlockState(bp, (p, s) -> bs);
        return true;
    }

    private void modifyJobBlockState(POS pos, BiFunction<POS, State, State> mutator) {
        State newV = this.jobStatuses.compute(pos, (p, s) -> (State)mutator.apply((Object)p, (State)s));
        QT.FLAG_LOGGER.debug("Job state set to {} at {}", (Object)newV.toShortString(), pos);
        if (this.cascading.containsKey(pos) && !this.cascading.get(pos).apply(newV).booleanValue()) {
            this.cascading.remove(pos);
        }
    }

    @Override
    public Boolean setJobBlockStateWithTimer(POS bp, State bs, int ticksToNextState) {
        this.setJobBlockState((Object)bp, bs);
        Long cur = this.timeJobStatuses.get(bp);
        if (cur != null && cur > 0L) {
            QT.FLAG_LOGGER.error("Clobbered time on block at {} from {} to {}", bp, (Object)cur, (Object)ticksToNextState);
        }
        QT.BLOCK_LOGGER.debug("Timer added to {} at {} ({} to next state)", (Object)bs.toShortString(), bp, (Object)ticksToNextState);
        this.timeJobStatuses.put(bp, Long.valueOf(ticksToNextState));
        return true;
    }

    @Override
    public Boolean clearState(POS bp) {
        this.timeJobStatuses.remove(bp);
        this.jobStatuses.remove(bp);
        QT.BLOCK_LOGGER.debug("Removed state from {}", bp);
        return true;
    }

    @Override
    @Nullable
    public Integer getTimeToNextState(POS bp) {
        Long value = this.timeJobStatuses.get(bp);
        return value == null ? null : Integer.valueOf(Math.toIntExact(value));
    }

    @Override
    public void clearAllTimers() {
        this.timeJobStatuses.keySet().forEach(k -> this.timeJobStatuses.put(k, 1L));
    }

    @Override
    public boolean canInsertItem(ITEM item, POS bp) {
        return this.jobStatuses.containsKey(bp);
    }

    public void tick(TICK_SOURCE tickSource, Collection<ROOM> allRooms, long ticksSinceLast) {
        this.rooms.addAll(allRooms);
        if (this.rooms.isEmpty()) {
            return;
        }
        this.curIdx = (this.curIdx + 1) % this.rooms.size();
        this.doTick(tickSource, (Room)this.rooms.toArray()[this.curIdx], ticksSinceLast);
    }

    private void doTick(TICK_SOURCE tickSource, ROOM o, long ticksSinceLast) {
        this.timeJobStatuses.forEach((k, v) -> this.timeJobStatuses.compute(k, (kk, vv) -> vv == null ? null : Long.valueOf(vv - ticksSinceLast)));
        this.claims.forEach((k, v) -> this.claims.compute(k, (kk, vv) -> {
            if (vv == null) {
                return null;
            }
            return vv.ticked();
        }));
        ImmutableMap.copyOf(this.timeJobStatuses).entrySet().stream().filter(e -> (Long)e.getValue() <= 0L).forEach(e -> {
            QT.BLOCK_LOGGER.debug("Timer at {} expired. Moving to next state", e.getKey());
            this.modifyJobBlockState(e.getKey(), (pos, state) -> state.incrProcessing());
            this.timeJobStatuses.remove(e.getKey());
        });
        for (InclusiveSpace s : o.getSpaces()) {
            for (Position p : InclusiveSpaces.getAllEnclosedPositions((InclusiveSpace)s)) {
                this.posFactory.apply(o, p).forEach(pp -> {
                    Function<State, Boolean> cas;
                    if (this.jobStatuses.containsKey(pp)) {
                        if (this.airCheck.apply(tickSource, pp).booleanValue()) {
                            QT.BLOCK_LOGGER.debug("Block is gone from {}. Clearing status.", pp);
                            this.jobStatuses.remove(pp);
                        }
                        return;
                    }
                    State def = this.defaultStateFactory.apply(tickSource, pp);
                    if (def != null) {
                        this.jobStatuses.put(pp, def);
                    }
                    if ((cas = this.cascadingBlockRevealer.apply(tickSource, pp)) != null) {
                        this.cascading.put(pp, cas);
                        if (!cas.apply(def == null ? State.fresh() : def).booleanValue()) {
                            this.cascading.remove(pp);
                        }
                    }
                });
            }
        }
    }

    @Override
    public ImmutableMap<POS, State> getAll() {
        return ImmutableMap.copyOf(this.jobStatuses);
    }

    @Override
    public boolean claimSpot(POS bp, Claim claim) {
        if (this.doClaimSpot(bp, claim)) {
            QT.JOB_LOGGER.debug("Spot {} claimed: {}", bp, (Object)claim);
            return true;
        }
        return false;
    }

    private boolean doClaimSpot(POS bp, Claim claim) {
        Claim c = this.claims.get(bp);
        if (c == null) {
            this.claims.put(bp, claim);
            return true;
        }
        if (c.owner().equals(claim.owner())) {
            this.claims.put(bp, claim);
            return true;
        }
        return false;
    }

    @Override
    public void clearClaim(POS position) {
        Claim claim = this.claims.remove(position);
        QT.JOB_LOGGER.debug("Claim {} released: {}", position, (Object)claim);
    }

    @Override
    public boolean canClaim(POS position, Supplier<Claim> makeClaim) {
        Claim prevClaim = this.claims.get(position);
        if (prevClaim == null) {
            return true;
        }
        Claim newClaim = makeClaim.get();
        return prevClaim.owner().equals(newClaim.owner());
    }

    public static interface InsertionRules<ITEM> {
        @Nullable
        public PredicateCollection<ITEM, ?> getIngredientsRequiredAtState(Integer var1);

        @Nullable
        public Integer getIngredientQuantityRequiredAtState(int var1, @Nullable Integer var2);
    }
}

