/*
 * Decompiled with CFR 0.152.
 */
package ca.bradj.questown.town;

import ca.bradj.questown.InventoryFullStrategy;
import ca.bradj.questown.QT;
import ca.bradj.questown.Questown;
import ca.bradj.questown.blocks.TownFlagSubBlocks;
import ca.bradj.questown.core.Config;
import ca.bradj.questown.core.VillagerUUID;
import ca.bradj.questown.core.advancements.ApproachTownTrigger;
import ca.bradj.questown.core.advancements.RoomTrigger;
import ca.bradj.questown.core.advancements.VisitorTrigger;
import ca.bradj.questown.core.init.AdvancementsInit;
import ca.bradj.questown.core.init.TilesInit;
import ca.bradj.questown.core.init.items.ItemsInit;
import ca.bradj.questown.gui.FlagTabsEmbedding;
import ca.bradj.questown.integration.minecraft.MCContainer;
import ca.bradj.questown.integration.minecraft.MCHeldItem;
import ca.bradj.questown.integration.minecraft.MCTownItem;
import ca.bradj.questown.integration.minecraft.MCTownState;
import ca.bradj.questown.integration.minecraft.TownStateSerializer;
import ca.bradj.questown.jobs.JobID;
import ca.bradj.questown.jobs.ServerJobsRegistry;
import ca.bradj.questown.jobs.Signals;
import ca.bradj.questown.jobs.WorksBehaviour;
import ca.bradj.questown.jobs.declarative.BOPDepositorWork;
import ca.bradj.questown.jobs.declarative.ResterWork;
import ca.bradj.questown.jobs.declarative.nomc.WorkSeekerJob;
import ca.bradj.questown.jobs.gatherer.GathererTools;
import ca.bradj.questown.jobs.leaver.ContainerTarget;
import ca.bradj.questown.jobs.requests.WorkRequest;
import ca.bradj.questown.logic.RoomRecipes;
import ca.bradj.questown.mc.Compat;
import ca.bradj.questown.mc.Util;
import ca.bradj.questown.mobs.visitor.VisitorMobEntity;
import ca.bradj.questown.roomrecipes.Matches;
import ca.bradj.questown.town.InitPair;
import ca.bradj.questown.town.NoMCEconomics;
import ca.bradj.questown.town.TownContainers;
import ca.bradj.questown.town.TownFlagInitialization;
import ca.bradj.questown.town.TownFlagInitializationImpl;
import ca.bradj.questown.town.TownFlagMenus;
import ca.bradj.questown.town.TownFlagState;
import ca.bradj.questown.town.TownFlagTileData;
import ca.bradj.questown.town.TownFlags;
import ca.bradj.questown.town.TownHealingHandle;
import ca.bradj.questown.town.TownKnowledgeStore;
import ca.bradj.questown.town.TownKnownBiomes;
import ca.bradj.questown.town.TownMessages;
import ca.bradj.questown.town.TownPois;
import ca.bradj.questown.town.TownPossibleWork;
import ca.bradj.questown.town.TownQuests;
import ca.bradj.questown.town.TownQuestsHandle;
import ca.bradj.questown.town.TownRooms;
import ca.bradj.questown.town.TownRoomsHandle;
import ca.bradj.questown.town.TownState;
import ca.bradj.questown.town.TownVillagerHandle;
import ca.bradj.questown.town.TownVillagers;
import ca.bradj.questown.town.TownWorkHandle;
import ca.bradj.questown.town.TownWorkStatusStore;
import ca.bradj.questown.town.TownWorldInteraction;
import ca.bradj.questown.town.WorkHandle;
import ca.bradj.questown.town.interfaces.KnowledgeHolder;
import ca.bradj.questown.town.interfaces.QuestsHolder;
import ca.bradj.questown.town.interfaces.RoomsHolder;
import ca.bradj.questown.town.interfaces.TownInterface;
import ca.bradj.questown.town.interfaces.VillagerHolder;
import ca.bradj.questown.town.interfaces.WorkStatusHandle;
import ca.bradj.questown.town.quests.MCAsapRewards;
import ca.bradj.questown.town.quests.MCMorningRewards;
import ca.bradj.questown.town.quests.MCQuest;
import ca.bradj.questown.town.quests.MCReward;
import ca.bradj.questown.town.quests.Quest;
import ca.bradj.questown.town.special.SpecialQuests;
import ca.bradj.roomrecipes.adapter.Positions;
import ca.bradj.roomrecipes.adapter.RoomRecipeMatch;
import ca.bradj.roomrecipes.core.space.InclusiveSpace;
import ca.bradj.roomrecipes.core.space.Position;
import ca.bradj.roomrecipes.recipes.ActiveRecipes;
import ca.bradj.roomrecipes.recipes.RoomRecipe;
import ca.bradj.roomrecipes.serialization.MCRoom;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonParser;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Queue;
import java.util.Set;
import java.util.Stack;
import java.util.UUID;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.IItemHandler;
import org.apache.logging.log4j.util.Strings;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TownFlagBlockEntity
extends BlockEntity
implements TownInterface,
ActiveRecipes.ChangeListener<MCRoom, RoomRecipeMatch<MCRoom>>,
TownPois.Listener {
    private final TownKnownBiomes biomes = new TownKnownBiomes();
    TownHealingHandle healing = new TownHealingHandle();
    private final TownFlagInitialization initializer;
    private int preferredBuffer;
    private boolean isMorning = false;
    private final NoMCEconomics economics = new NoMCEconomics();
    private int ticksWithoutQuests;
    int bopCount = 0;
    private LazyOptional<IItemHandler> itemHandler = LazyOptional.of(() -> new IItemHandler(){

        public int getSlots() {
            return 64;
        }

        @NotNull
        public ItemStack getStackInSlot(int i) {
            if (i >= TownFlagBlockEntity.this.bopCount) {
                return ItemStack.f_41583_;
            }
            return new ItemStack((ItemLike)ItemsInit.BLOCK_OF_PROGRESS.get());
        }

        @NotNull
        public ItemStack insertItem(int i, @NotNull ItemStack itemStack, boolean simulate) {
            if (!this.isItemValid(i, itemStack)) {
                return itemStack;
            }
            itemStack.m_41774_(1);
            if (!simulate) {
                ++TownFlagBlockEntity.this.bopCount;
                QT.FLAG_LOGGER.debug("Flag now contains {} BOPs", (Object)TownFlagBlockEntity.this.bopCount);
            }
            return itemStack;
        }

        @NotNull
        public ItemStack extractItem(int i, int i1, boolean b) {
            return ItemStack.f_41583_;
        }

        public int getSlotLimit(int i) {
            return 1;
        }

        public boolean isItemValid(int i, @NotNull ItemStack itemStack) {
            if (i >= this.getSlots()) {
                return false;
            }
            if (i < TownFlagBlockEntity.this.bopCount) {
                return false;
            }
            return itemStack.m_150930_((Item)ItemsInit.BLOCK_OF_PROGRESS.get());
        }
    });
    private static Map<String, InitPair> initPairs;
    public static final String ID = "flag_base_block_entity";
    private boolean stopped = true;
    final TownQuests quests = new TownQuests();
    final TownFlagSubBlocks subBlocks = new TownFlagSubBlocks(this.m_58899_());
    final TownPois pois = new TownPois(this.subBlocks);
    final MCMorningRewards morningRewards = new MCMorningRewards(this);
    private final MCAsapRewards asapRewards = new MCAsapRewards();
    private final UUID uuid = UUID.randomUUID();
    private final TownFlagState state = new TownFlagState(this);
    public long advancedTimeOnTick = -1L;
    boolean isInitializedQuests = false;
    private boolean everScanned = false;
    private boolean changed = false;
    private final ArrayList<UUID> assignedFarmers = new ArrayList();
    private final ArrayList<Integer> times = new ArrayList();
    final TownWorkStatusStore jobHandle = new TownWorkStatusStore();
    private final Map<UUID, TownWorkStatusStore> jobHandles = new HashMap<UUID, TownWorkStatusStore>();
    final TownWorkHandle workHandle = new TownWorkHandle(this.subBlocks, this.m_58899_());
    private final Stack<Long> mornings = new Stack();
    private final LinkedBlockingQueue<Function<TownFlagBlockEntity, Boolean>> initializers = new LinkedBlockingQueue();
    final TownKnowledgeStore knowledgeHandle = new TownKnowledgeStore();
    final TownQuestsHandle questsHandle = new TownQuestsHandle();
    final TownRoomsHandle roomsHandle = new TownRoomsHandle();
    final TownMessages messages = new TownMessages();
    public final TownFlagMenus menus = new TownFlagMenus();
    final TownPossibleWork possibleWork = new TownPossibleWork();
    final TownVillagerHandle villagerHandle = new TownVillagerHandle();
    private final TownWorldInteraction world = new TownWorldInteraction();
    @Nullable
    private Supplier<Boolean> debugTask;
    private boolean debugMode;

    @NotNull
    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap) {
        if (!ForgeCapabilities.ITEM_HANDLER.equals(cap)) {
            return super.getCapability(cap);
        }
        return this.itemHandler.cast();
    }

    public static void logStoredData(TownFlagBlockEntity entity, CompoundTag tTag) {
        List<String> qss = entity.getAllQuests().stream().map(Quest::toShortString).toList();
        QT.FLAG_LOGGER.info("Town UUID: {}", (Object)entity.getUUID());
        QT.FLAG_LOGGER.info("Quests:\n{}", (Object)Strings.join(qss, (char)'\n'));
        QT.FLAG_LOGGER.info("Villagers:\n{}", (Object)Strings.join(entity.getVillagers(), (char)'\n'));
        QT.FLAG_LOGGER.info("Villager Jobs:\n{}", (Object)Strings.join(entity.getVillagerHandle().getJobs(), (char)'\n'));
        QT.FLAG_LOGGER.info("Room Recipes:\n{}", (Object)Strings.join(entity.getRoomHandle().getMatches(x -> true), (char)'\n'));
        String prettyJsonString = new GsonBuilder().setPrettyPrinting().create().toJson(JsonParser.parseString((String)tTag.toString()));
        QT.FLAG_LOGGER.info("NBT: {}", (Object)prettyJsonString);
    }

    public static TownFlagBlockEntity getFromPos(Level level, BlockPos flagPos) {
        BlockEntity blockEntity = level.m_7702_(flagPos);
        if (blockEntity instanceof TownFlagBlockEntity) {
            TownFlagBlockEntity tfbe = (TownFlagBlockEntity)blockEntity;
            return tfbe;
        }
        return null;
    }

    public TownHealingHandle getHealingHandle() {
        return this.healing;
    }

    @Override
    public NoMCEconomics getEconomicsHandle() {
        return this.economics;
    }

    @Override
    public int getBlocksOfProgress() {
        return this.bopCount;
    }

    public static void staticInitialize() {
        initPairs = TownFlagTileData.initialize();
    }

    @Override
    public TownPossibleWork getPossibleWork() {
        return this.possibleWork;
    }

    public TownFlagBlockEntity(BlockPos p_155229_, BlockState p_155230_) {
        super((BlockEntityType)TilesInit.TOWN_FLAG.get(), p_155229_, p_155230_);
        this.initializer = new TownFlagInitializationImpl(this);
    }

    public static void tick(Level level, BlockPos blockEntityPos, BlockState state, TownFlagBlockEntity e) {
        CompoundTag tag;
        boolean stateChanged;
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel sl = (ServerLevel)level;
        if (!e.initializers.isEmpty()) {
            QT.FLAG_LOGGER.info("Running initializer ({} left) @ {}", (Object)(e.initializers.size() - 1), (Object)e.m_58899_());
            Function initr = (Function)e.initializers.remove();
            if (!((Boolean)initr.apply(e)).booleanValue()) {
                e.initializers.add(initr);
            }
            return;
        }
        e.villagerHandle.entities().stream().filter(v -> v instanceof VisitorMobEntity).map(v -> (VisitorMobEntity)v).findFirst().ifPresent(v -> {
            if (!TownFlagBlockEntity.isMissingCompletableQuests(e)) {
                e.ticksWithoutQuests = 0;
                return;
            }
            if (e.ticksWithoutQuests < 500) {
                ++e.ticksWithoutQuests;
                return;
            }
            QT.FLAG_LOGGER.debug("No quests found. Adding a batch for {}", (Object)v.getVUID());
            e.questsHandle.addBatchOfRandomQuestsForVisitor(v.getVUID());
            e.m_6596_();
            e.ticksWithoutQuests = 0;
        });
        Player nearestPlayer = level.m_5788_((double)blockEntityPos.m_123341_(), (double)blockEntityPos.m_123342_(), (double)blockEntityPos.m_123343_(), -1.0, null);
        if (nearestPlayer == null) {
            return;
        }
        double distToPlayer = nearestPlayer.m_20183_().m_123331_((Vec3i)e.f_58858_);
        if (distToPlayer > (double)((Integer)Config.TOWN_TICK_RADIUS.get()).intValue()) {
            if (!e.stopped) {
                QT.FLAG_LOGGER.info("Town flag at {} stopped ticking because closest player is further away than limit {}: {}", (Object)blockEntityPos, Config.TOWN_TICK_RADIUS.get(), (Object)distToPlayer);
                e.subBlocks.parentUnloaded();
            }
            e.stopped = true;
            return;
        }
        e.stopped = false;
        long start = System.currentTimeMillis();
        e.subBlocks.parentTick(sl);
        if (e.debugMode) {
            boolean done;
            if (e.debugTask != null && (done = e.debugTask.get().booleanValue())) {
                e.debugTask = null;
            }
            return;
        }
        Signals.DayTime dayTime = Util.getDayTime((Level)sl);
        Signals signals = Signals.fromDayTime(dayTime);
        if (signals == Signals.MORNING) {
            if (!e.isMorning) {
                e.isMorning = true;
                e.onMorning(Util.getTick(sl));
            }
        } else if (e.isMorning) {
            e.isMorning = false;
        }
        if (!e.mornings.empty()) {
            e.morningTick(e.mornings.pop());
        }
        if (((stateChanged = e.state.tick(e, tag = Compat.getBlockStoredTagData(e), sl)) || e.changed) && e.everScanned) {
            e.writeTownData(tag);
            e.state.putStateOnTile(tag, e.uuid);
            e.changed = false;
            TownFlagBlockEntity.m_155232_((Level)level, (BlockPos)blockEntityPos, (BlockState)state);
        }
        if (stateChanged) {
            e.possibleWork.invalidate();
            e.quests.processItemQuests(TownContainers.getAllStacks(e, e.getServerLevel()));
        }
        e.workHandle.tick(sl);
        e.quests.tick(e);
        e.biomes.tick();
        e.healing.tick();
        e.possibleWork.tick();
        e.roomsHandle.tick(sl, blockEntityPos);
        long gameTime = level.m_46467_();
        long l = gameTime % (Long)Config.FLAG_TICK_INTERVAL.get();
        if (l != 0L) {
            return;
        }
        ImmutableList<MCRoom> allRooms = e.roomsHandle.getAllRoomsIncludingMetaAndFarms();
        e.jobHandle.tick(sl, allRooms, (Long)Config.FLAG_TICK_INTERVAL.get());
        e.jobHandles.forEach((k, v) -> v.tick(sl, allRooms, (Long)Config.FLAG_TICK_INTERVAL.get()));
        e.asapRewards.tick();
        e.pois.tick(sl, blockEntityPos, (int)e.villagerHandle.stream().count());
        if (!(signals != Signals.NIGHT && signals != Signals.EVENING || e.getVillagerHandle().entities().isEmpty())) {
            AdvancementsInit.VISITOR_TRIGGER.triggerForNearestPlayer(sl, VisitorTrigger.Triggers.FirstNightFall, e.m_58899_());
        }
        e.villagerHandle.tick(Util.getTick(sl), signals);
        if (e.economics.tick() && e.economics.getAggregatedItems(null).stream().anyMatch(v -> v.timesNeeded() > 4)) {
            AdvancementsInit.VISITOR_TRIGGER.triggerForNearestPlayer(sl, VisitorTrigger.Triggers.FirstUnmetNeeds, e.m_58899_());
        }
        e.everScanned = true;
        TownFlagBlockEntity.profileTick(e, start);
    }

    private static boolean isMissingCompletableQuests(TownFlagBlockEntity e) {
        ImmutableList<AbstractMap.SimpleEntry<MCQuest, MCReward>> all = e.questsHandle.getAllQuestsWithRewards();
        if (all.stream().anyMatch(v -> !((MCQuest)v.getKey()).isComplete())) {
            return false;
        }
        return !e.morningRewards.children.stream().anyMatch(MCReward::addsQuestsWhenApplied);
    }

    private void morningTick(Long newTime) {
        this.assignedFarmers.clear();
        for (MCReward r : this.morningRewards.popChildren()) {
            this.asapRewards.push(r);
        }
        this.m_6596_();
        this.villagerHandle.handleMorning();
        this.roomsHandle.handleMorning();
        Compat.getBlockStoredTagData(this).m_128356_(TownFlagState.NBT_TIME_WARP_REFERENCE_TICK, newTime.longValue());
    }

    private static void profileTick(TownFlagBlockEntity e, long start) {
        if ((Integer)Config.TICK_SAMPLING_RATE.get() > 0) {
            long end = System.currentTimeMillis();
            e.times.add((int)(end - start));
            if (e.times.size() > (Integer)Config.TICK_SAMPLING_RATE.get()) {
                QT.PROFILE_LOGGER.debug("Average tick length: {}", (Object)e.times.stream().mapToInt(Integer::intValue).average().getAsDouble());
                e.times.clear();
            }
        }
    }

    public void m_6596_() {
        if (this.isInitialized()) {
            super.m_6596_();
            this.changed = true;
            this.possibleWork.invalidate();
        }
    }

    public CompoundTag serializeNBT() {
        return super.serializeNBT();
    }

    public void deserializeNBT(CompoundTag nbt) {
        super.deserializeNBT(nbt);
    }

    protected void m_183515_(@NotNull CompoundTag tag) {
        super.m_183515_(tag);
    }

    public void m_142466_(@NotNull CompoundTag tag) {
        super.m_142466_(tag);
        TownFlagBlockEntity.loadNextTick(this.initializers);
    }

    private static void loadNextTick(Queue<Function<TownFlagBlockEntity, Boolean>> initializers) {
        initializers.add(t -> {
            TownFlagBlockEntity.logStoredData(t, Compat.getBlockStoredTagData(t));
            return true;
        });
        initPairs.forEach((key, pair) -> initializers.add(t -> {
            CompoundTag cTag;
            CompoundTag tag = Compat.getBlockStoredTagData(t);
            if (tag.m_128441_(key) && !(cTag = tag.m_128469_(key)).m_128456_()) {
                return pair.fromTag().apply(cTag, (TownFlagBlockEntity)t);
            }
            QT.FLAG_LOGGER.info("No data for {}. Skipping deserialization.", key);
            return true;
        }));
    }

    public void writeTownData(CompoundTag tag) {
        if (this.f_58857_ == null) {
            return;
        }
        if (this.f_58857_.m_5776_()) {
            tag.m_128359_("side", "client");
            return;
        }
        tag.m_128359_("side", "server");
        TownFlagTileData.write(Util.getTick(this.getServerLevel()), tag, this.initializer);
    }

    public CompoundTag m_5995_() {
        CompoundTag tag = super.m_5995_();
        if (this.isInitialized()) {
            this.writeTownData(tag);
        }
        return tag;
    }

    @Nullable
    public Packet<ClientGamePacketListener> m_58483_() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    public void onLoad() {
        super.onLoad();
        Level level = this.f_58857_;
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel sl = (ServerLevel)level;
        this.initializeFreshFlag(false);
    }

    public void initializeFreshFlag(boolean fullInit) {
        this.grantAdvancementOnApproach();
        if (fullInit) {
            TownFlagBlockEntity.loadNextTick(this.initializers);
        } else {
            initPairs.forEach((k, v) -> v.onFlagPlace().accept(this));
        }
        this.initializers.add(t -> {
            t.messages.initialize(t.getServerLevel());
            return true;
        });
        this.initializers.add(t -> {
            t.possibleWork.initialize((TownFlagBlockEntity)t);
            return true;
        });
        this.initializers.add(t -> {
            t.biomes.initialize((TownFlagBlockEntity)t);
            return true;
        });
        this.initializers.add(t -> {
            t.world.init((TownFlagBlockEntity)t);
            return true;
        });
        this.initializers.add(t -> {
            if (!this.isInitializedQuests) {
                t.setUpQuestsForNewlyPlacedFlag();
            }
            t.pois.setListener((TownPois.Listener)t);
            t.workHandle.addChangeListener(c -> {
                this.updateWorkersAfterRequestChange();
                this.m_6596_();
            });
            this.f_58857_.m_7260_(this.m_58899_(), this.m_58900_(), this.m_58900_(), 2);
            if (!this.f_58857_.m_5776_()) {
                TownFlags.register(this.uuid, t);
            }
            return true;
        });
    }

    private void updateWorkersAfterRequestChange() {
        WorksBehaviour.TownData td = this.getTownData();
        this.villagerHandle.stream().filter(v -> v instanceof VisitorMobEntity).map(v -> (VisitorMobEntity)v).filter(e -> {
            for (WorkRequest r : this.workHandle.getRequestedResults()) {
                if (!ServerJobsRegistry.canSatisfy(td, e.getJobId(), r.asIngredient()) || !e.getStatusForServer().isBusy()) continue;
                return false;
            }
            return true;
        }).forEach(e -> this.villagerHandle.changeJobForVillager(e.m_20148_(), WorkSeekerJob.getIDForRoot(e.getJobId()), false));
    }

    @Override
    public ServerLevel getServerLevel() {
        Level level = this.m_58904_();
        if (level instanceof ServerLevel) {
            ServerLevel sl = (ServerLevel)level;
            return sl;
        }
        return null;
    }

    @Override
    public BlockPos getTownFlagBasePos() {
        return this.m_58899_();
    }

    @Override
    public void addMorningReward(MCReward ev) {
        this.morningRewards.add(ev);
        this.m_6596_();
    }

    @Override
    public void addImmediateReward(MCReward r) {
        this.asapRewards.push(r);
        this.m_6596_();
    }

    private void grantAdvancementOnApproach() {
        MinecraftForge.EVENT_BUS.addListener(event -> {
            Entity patt23750$temp = event.getEntity();
            if (patt23750$temp instanceof ServerPlayer) {
                ServerPlayer sp = (ServerPlayer)patt23750$temp;
                double v = event.getEntity().m_20275_((double)this.f_58858_.m_123341_() + 0.5, (double)this.f_58858_.m_123342_() + 0.5, (double)this.f_58858_.m_123343_() + 0.5);
                if (v < 100.0) {
                    AdvancementsInit.APPROACH_TOWN_TRIGGER.trigger(sp, ApproachTownTrigger.Triggers.FirstVisit);
                }
            }
        });
    }

    @Override
    public KnowledgeHolder<ResourceLocation, MCHeldItem, MCTownItem> getKnowledgeHandle() {
        return this.knowledgeHandle;
    }

    @Override
    public QuestsHolder getQuestHandle() {
        return this.questsHandle;
    }

    @Override
    public RoomsHolder getRoomHandle() {
        return this.roomsHandle;
    }

    void setUpQuestsForNewlyPlacedFlag() {
        TownQuests.setUpQuestsForNewlyPlacedFlag(this, this.quests);
        this.isInitializedQuests = true;
        this.m_6596_();
    }

    public ImmutableList<Quest<ResourceLocation, MCRoom>> getAllQuests() {
        return this.quests.getAll();
    }

    public void roomRecipeCreated(MCRoom room, RoomRecipeMatch<MCRoom> match) {
        ServerLevel l = this.getServerLevel();
        this.world.swapBlocks(l, match);
        this.messages.roomRecipeCreated(room, Matches.getTopMatch(this::recipesFromLevel, match));
        BlockPos pos = Positions.ToBlock((Position)room.doorPos, (int)room.yCoord);
        if (match.anyMatch(SpecialQuests.JOB_BOARD)) {
            AdvancementsInit.ROOM_TRIGGER.triggerForNearestPlayer(l, RoomTrigger.Triggers.FirstJobBoard, pos);
        }
        if (match.anyMatch(Questown.ResourceLocation("store_room"))) {
            AdvancementsInit.ROOM_TRIGGER.triggerForNearestPlayer(l, RoomTrigger.Triggers.FirstStoreRoom, pos);
        }
        Matches.runForTopMatch(this::recipesFromLevel, match, r -> this.quests.markQuestAsComplete(room, (ResourceLocation)r));
    }

    private Map<ResourceLocation, RoomRecipe> recipesFromLevel() {
        return RoomRecipes.hydrate(this.getServerLevel().m_7465_(), true);
    }

    public void roomRecipeChanged(MCRoom oldRoom, RoomRecipeMatch<MCRoom> oldMatch, MCRoom newRoom, RoomRecipeMatch<MCRoom> newMatch) {
        ServerLevel l = this.getServerLevel();
        Optional<ResourceLocation> oldMatchID = Matches.getTopMatch(this::recipesFromLevel, oldMatch);
        Optional<ResourceLocation> newMatchID = Matches.getTopMatch(this::recipesFromLevel, newMatch);
        if (oldMatchID.isPresent() && newMatchID.isPresent() && !oldMatchID.equals(newMatchID)) {
            this.messages.roomRecipeChanged(oldMatchID.get(), newMatchID.get(), newRoom);
            this.quests.roomRecipeChanged(oldRoom, oldMatch, newRoom, newMatch);
            TownRooms.addParticles(l, newRoom, (ParticleOptions)ParticleTypes.f_123748_);
        }
        this.m_6596_();
    }

    public void roomRecipeDestroyed(MCRoom roomDoorPos, RoomRecipeMatch<MCRoom> oldRecipeId) {
        ServerLevel l = this.getServerLevel();
        this.messages.roomRecipeDestroyed(roomDoorPos, Matches.getTopMatch(this::recipesFromLevel, oldRecipeId).orElse(null));
        this.quests.roomRecipeDestroyed(roomDoorPos, oldRecipeId);
        TownRooms.addParticles(l, roomDoorPos, (ParticleOptions)ParticleTypes.f_123762_);
        this.m_6596_();
    }

    @Override
    public void addRandomJobQuestForVisitor(UUID visitorUUID) {
        TownQuests.addJobQuest(this, this.quests, VillagerUUID.from(visitorUUID));
        this.m_6596_();
        BlockPos bp = this.m_58899_();
        AdvancementsInit.VISITOR_TRIGGER.triggerForNearestPlayer(this.getServerLevel(), VisitorTrigger.Triggers.FirstJobQuest, bp);
    }

    @Override
    public boolean changeJobForVisitorFromBoard(UUID ownerUUID, JobID currentJob) {
        WorksBehaviour.TownData td;
        VisitorMobEntity villager = this.villagerHandle.getEntity(ownerUUID);
        if (villager == null) {
            return true;
        }
        float damagePercent = this.villagerHandle.getDamagePercent(ownerUUID);
        if (damagePercent > 0.0f && this.f_58857_.m_213780_().m_188501_() < damagePercent) {
            this.villagerHandle.changeJobForVillager(ownerUUID, ResterWork.getIdForRoot(currentJob.rootId()), false);
            return true;
        }
        if (this.villagerHandle.hasBlockOfProgress(ownerUUID)) {
            MCHeldItem bop = MCHeldItem.fromTown((Item)ItemsInit.BLOCK_OF_PROGRESS.get());
            villager.tryGiveItem(bop, InventoryFullStrategy.REMOVE_FROM_WORLD);
            JobID depositor = BOPDepositorWork.getIdForRoot(currentJob.rootId());
            this.villagerHandle.changeJobForVillager(ownerUUID, depositor, false);
            return true;
        }
        Predicate<JobID> canFit = p -> ServerJobsRegistry.canFit(this.uuid, p, Util.getDayTime((Level)this.getServerLevel()));
        Predicate<JobID> canAlwaysStart = p -> ServerJobsRegistry.canAlwaysStart(this.uuid, p);
        ImmutableList<WorkRequest> requestedResults = this.workHandle.getRequestedResults();
        JobID work = TownVillagers.chooseFromList(canFit, canAlwaysStart, requestedResults, td = this.getTownData(), this.possibleWork.getFor(villager.getJobId()));
        if (work != null) {
            this.villagerHandle.changeJobForVillager(ownerUUID, work, false);
            return true;
        }
        if (this.preferredBuffer < 100) {
            ++this.preferredBuffer;
            return false;
        }
        this.preferredBuffer = 0;
        work = TownVillagers.getPreferredWork(villager.getJobId(), canFit, canAlwaysStart, requestedResults, td);
        if (work != null) {
            this.villagerHandle.changeJobForVillager(ownerUUID, work, false);
            return true;
        }
        return false;
    }

    public WorksBehaviour.TownData getTownData() {
        return new WorksBehaviour.TownData(prefix -> this.knowledgeHandle.getAllKnownGatherResults(this.biomes.getAllInTown(), (GathererTools.LootTablePrefix)prefix));
    }

    @Override
    @Nullable
    public UUID getRandomVillager() {
        if (this.getVillagers().isEmpty()) {
            return null;
        }
        ImmutableList villagers = ImmutableList.copyOf(this.getVillagers());
        return (UUID)villagers.get(this.getServerLevel().m_213780_().m_188503_(villagers.size()));
    }

    @Override
    public boolean isVillagerMissing(UUID uuid) {
        return !this.getVillagers().contains((Object)uuid);
    }

    @Override
    public Vec3 getVisitorJoinPos() {
        return this.pois.getVisitorJoinPos(this.getServerLevel(), this.m_58899_());
    }

    @Override
    public BlockPos getRandomWanderTarget(BlockPos avoiding) {
        if (!this.isInitialized()) {
            return null;
        }
        ImmutableList<MCRoom> allRooms = this.roomsHandle.getAllRoomsIncludingMetaAndFarms();
        return this.pois.getWanderTarget(this.getServerLevel(), allRooms, (p, r) -> {
            BlockPos pos = Positions.ToBlock((Position)p, (int)r.yCoord);
            double dist = pos.m_123331_((Vec3i)avoiding);
            if (dist > 5.0) {
                QT.FLAG_LOGGER.trace("Target is {} blocks away from {}", (Object)dist, (Object)avoiding);
                return true;
            }
            return false;
        }, (p, r) -> Positions.ToBlock((Position)p, (int)r.yCoord));
    }

    public ImmutableSet<UUID> getVillagers() {
        return ImmutableSet.copyOf((Collection)this.villagerHandle.stream().map(Entity::m_20148_).collect(Collectors.toSet()));
    }

    @Override
    public TownHealingHandle getHealHandle() {
        return this.healing;
    }

    @Override
    @Nullable
    public ContainerTarget<MCContainer, MCTownItem> findMatchingContainer(ContainerTarget.CheckFn<MCTownItem> c) {
        return TownContainers.findMatching(this, c);
    }

    @Override
    public WorkStatusHandle<BlockPos, MCHeldItem> getWorkStatusHandle(@Nullable UUID ownerIDOrNullForGlobal) {
        if (ownerIDOrNullForGlobal == null) {
            return this.jobHandle;
        }
        TownWorkStatusStore jh = this.jobHandles.get(ownerIDOrNullForGlobal);
        if (jh != null) {
            return jh;
        }
        jh = new TownWorkStatusStore();
        this.jobHandles.put(ownerIDOrNullForGlobal, jh);
        return jh;
    }

    @Override
    public WorkHandle getWorkHandle() {
        return this.workHandle;
    }

    @Override
    public Collection<String> getAvailableRootJobs() {
        Set allJobs = ServerJobsRegistry.getAllJobs().stream().map(JobID::rootId).collect(Collectors.toSet());
        Set allFilledJobs = this.villagerHandle.stream().filter(v -> v instanceof VisitorMobEntity).map(v -> (VisitorMobEntity)v).map(VisitorMobEntity::getJobId).map(JobID::rootId).collect(Collectors.toSet());
        Set<String> allNewJobs = allJobs.stream().filter(v -> !allFilledJobs.contains(v)).collect(Collectors.toSet());
        if (allNewJobs.isEmpty()) {
            allNewJobs = allJobs;
        }
        return allNewJobs;
    }

    @Override
    public boolean hasEnoughBeds() {
        long numVillagers = this.villagerHandle.size();
        return this.roomsHandle.hasEnoughBeds(numVillagers);
    }

    @Override
    public boolean isInitialized() {
        return this.isInitializedQuests && this.biomes.isInitialized() && this.initializers.isEmpty();
    }

    public boolean isInitializing() {
        return !this.initializers.isEmpty();
    }

    public ImmutableList<AbstractMap.SimpleEntry<MCQuest, MCReward>> getAllQuestsWithRewards() {
        return this.quests.questBatches.getAllWithRewards();
    }

    void onMorning(long newTime) {
        this.mornings.push(newTime);
    }

    @Override
    public void campfireFound(BlockPos bp) {
        Position pos = Positions.FromBlockPos((BlockPos)bp);
        MCRoom room = new MCRoom(pos, (Collection)ImmutableList.of((Object)InclusiveSpace.from((Position)pos).to(pos)), bp.m_123342_());
        this.quests.markQuestAsComplete(room, SpecialQuests.CAMPFIRE);
    }

    @Override
    public void townGateFound(BlockPos bp) {
        Position pos = Positions.FromBlockPos((BlockPos)bp);
        MCRoom room = new MCRoom(pos, (Collection)ImmutableList.of((Object)InclusiveSpace.from((Position)pos).to(pos)), bp.m_123342_());
        this.quests.markQuestAsComplete(room, SpecialQuests.TOWN_GATE);
    }

    public void assumeStateFromTown(VisitorMobEntity visitorMobEntity, ServerLevel sl) {
        if (!Compat.getBlockStoredTagData(this).m_128441_(TownFlagState.NBT_TOWN_STATE)) {
            QT.FLAG_LOGGER.error("Villager entity exists but town state is missing. This is a bug and may cause unexpected behaviour.");
            return;
        }
        MCTownState state = TownStateSerializer.INSTANCE.load(Compat.getBlockStoredTagData(this).m_128469_(TownFlagState.NBT_TOWN_STATE), sl, bp -> this.pois.getWelcomeMats().contains((Object)bp));
        Optional<TownState.VillagerData> match = state.villagers.stream().filter(v -> v.uuid.equals(visitorMobEntity.m_20148_())).findFirst();
        if (match.isEmpty()) {
            QT.FLAG_LOGGER.error("Villager entity exists but is not present on town state. This is a bug and may cause unexpected behaviour.");
            return;
        }
        this.villagerHandle.register(visitorMobEntity);
        TownState.VillagerData m = match.get();
        visitorMobEntity.initialize(this, m.uuid, m.xPosition, m.yPosition, m.zPosition, m.journal);
    }

    @Override
    public UUID getUUID() {
        return this.uuid;
    }

    public void registerWelcomeMat(BlockPos welcomeMatBlock) {
        this.pois.registerWelcomeMat(welcomeMatBlock);
        this.roomsHandle.registerBlockAsRoom(SpecialQuests.TOWN_GATE, welcomeMatBlock);
        this.m_6596_();
        AdvancementsInit.ROOM_TRIGGER.triggerForNearestPlayer(this.getServerLevel(), RoomTrigger.Triggers.FirstWelcomeMat, welcomeMatBlock);
    }

    public List<BlockPos> getWelcomeMats() {
        return this.pois.getWelcomeMats();
    }

    public void registerJobsBoard(BlockPos matPos) {
        this.workHandle.registerJobBoard(matPos);
        this.m_6596_();
    }

    public void openJobsMenu(ServerPlayer sender, boolean skipStraightToAdd) {
        this.workHandle.openMenuRequested(sender, skipStraightToAdd);
    }

    public void warpTime(int ticks) {
        this.state.warp(this, Compat.getBlockStoredTagData(this), this.getServerLevel(), ticks);
    }

    @Override
    public VillagerHolder getVillagerHandle() {
        return this.villagerHandle;
    }

    public int getY() {
        return this.getTownFlagBasePos().m_123342_();
    }

    public void startDebugTask(Supplier<Boolean> debugTask) {
        if (!this.debugMode) {
            this.messages.startDebugFailed();
            return;
        }
        this.debugTask = debugTask;
    }

    public void toggleDebugMode() {
        this.debugMode = !this.debugMode;
        this.messages.debugToggled(this.debugMode);
    }

    TownFlagInitialization initializer() {
        return this.initializer;
    }

    public FlagTabsEmbedding.FlagInfo getInfo() {
        return new FlagTabsEmbedding.FlagInfo(this.m_58899_(), this.bopCount > 0);
    }

    public void ejectBlockOfProgress(ServerPlayer sender) {
        --this.bopCount;
        this.m_6596_();
        ItemStack v = ((Item)ItemsInit.BLOCK_OF_PROGRESS.get()).m_7968_();
        BlockPos bp = this.getTownFlagBasePos();
        this.messages.broadcastMessage("messages.player.took_bop", sender.m_7755_(), ((Item)ItemsInit.BLOCK_OF_PROGRESS.get()).m_7968_(), Util.getTinyString(bp));
        if (sender.m_150109_().m_36054_(v)) {
            sender.m_150109_().m_6596_();
            sender.f_36095_.m_38946_();
            return;
        }
        bp = bp.m_121945_(Compat.getRandomHorizontal(this.getServerLevel()));
        ItemEntity item = new ItemEntity(this.f_58857_, (double)bp.m_123341_(), (double)bp.m_123342_(), (double)bp.m_123343_(), v);
        this.f_58857_.m_7967_((Entity)item);
    }
}

