/*
 * Decompiled with CFR 0.152.
 */
package ca.bradj.questown.town;

import ca.bradj.questown.core.UtilClean;
import ca.bradj.questown.core.advancements.RoomTrigger;
import ca.bradj.questown.core.advancements.VisitorTrigger;
import ca.bradj.questown.core.init.AdvancementsInit;
import ca.bradj.questown.core.network.EconomicsUpdate;
import ca.bradj.questown.core.network.QuestownNetwork;
import ca.bradj.questown.gui.FlagMenus;
import ca.bradj.questown.gui.FlagTabsEmbedding;
import ca.bradj.questown.gui.MultiStatusMenu;
import ca.bradj.questown.gui.TownBlockofProgressMenu;
import ca.bradj.questown.gui.TownEconomicsMenu;
import ca.bradj.questown.gui.TownQuestsContainer;
import ca.bradj.questown.gui.UIQuest;
import ca.bradj.questown.mc.Compat;
import ca.bradj.questown.mobs.visitor.VisitorMobEntity;
import ca.bradj.questown.town.TownFlagBlockEntity;
import ca.bradj.questown.town.interfaces.TownInterface;
import ca.bradj.questown.town.quests.MCQuest;
import ca.bradj.questown.town.quests.MCReward;
import ca.bradj.questown.town.quests.Quest;
import ca.bradj.roomrecipes.recipes.RecipesInit;
import ca.bradj.roomrecipes.recipes.RoomRecipe;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.AbstractMap;
import java.util.Collection;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.level.Level;
import net.minecraftforge.network.PacketDistributor;
import org.apache.commons.lang3.function.TriFunction;
import org.jetbrains.annotations.NotNull;

public class TownFlagMenus {
    public void showUI(ServerPlayer sender, String type, FlagTabsEmbedding.FlagInfo flagInfo, int blocksOfProgress) {
        Collection<LivingEntity> entities;
        List<UIQuest> uiQuests;
        BlockPos flagPos = flagInfo.flagPos();
        TownFlagBlockEntity flag = (TownFlagBlockEntity)sender.m_9236_().m_7702_(flagPos);
        ImmutableList<AbstractMap.SimpleEntry<MCQuest, MCReward>> quests = flag.getQuestHandle().getAllQuestsWithRewards();
        ImmutableMap showers = ImmutableMap.of((Object)"quests", () -> this.lambda$showUI$2(sender, quests, uiQuests = UIQuest.fromLevel((Level)sender.m_9236_(), quests), flagInfo, flagPos, entities = flag.getVillagerHandle().entities(), flag), (Object)"villagers", () -> TownFlagMenus.openMenu(sender, (TriFunction<Integer, Inventory, Player, AbstractContainerMenu>)((TriFunction)(windowId, inv, p) -> new MultiStatusMenu((int)windowId, flagInfo, () -> this.triggerAdvancement(flagPos, sender.m_9236_()))), uiQuests, flagInfo, entities, flag.getBlocksOfProgress()), (Object)"economics", () -> {
            QuestownNetwork.CHANNEL.send(PacketDistributor.PLAYER.with(() -> sender), (Object)new EconomicsUpdate(flag.getEconomicsHandle().getAggregatedItems(null)));
            TownFlagMenus.openMenu(sender, (TriFunction<Integer, Inventory, Player, AbstractContainerMenu>)((TriFunction)(windowId, inv, p) -> new TownEconomicsMenu((int)windowId, flagInfo)), uiQuests, flagInfo, entities, flag.getBlocksOfProgress());
        }, (Object)"blocks_of_progress", () -> TownFlagMenus.openMenu(sender, (TriFunction<Integer, Inventory, Player, AbstractContainerMenu>)((TriFunction)(windowId, inv, p) -> new TownBlockofProgressMenu((int)windowId, flagInfo, blocksOfProgress)), uiQuests, flagInfo, entities, flag.getBlocksOfProgress()));
        Runnable runnable = (Runnable)showers.get((Object)type);
        if (runnable == null) {
            throw new IllegalArgumentException("Unexpected menu type: \"" + type + "\"");
        }
        runnable.run();
    }

    private void triggerAdvancementForAnyFarms(ServerPlayer p, Collection<? extends Quest<ResourceLocation, ?>> q) {
        List<RoomRecipe> farmRecipes = p.f_19853_.m_7465_().m_44013_(RecipesInit.ROOM).stream().filter(RoomRecipe::isFarmRecipe).toList();
        for (Quest<ResourceLocation, ?> mcQuest : q) {
            if (farmRecipes.stream().noneMatch(z -> z.m_6423_().equals(mcQuest.getWantedId()))) continue;
            AdvancementsInit.VISITOR_TRIGGER.trigger(p, VisitorTrigger.Triggers.FirstFarmQuest);
            return;
        }
    }

    private void triggerAdvancement(BlockPos pos, ServerLevel level) {
        AdvancementsInit.ROOM_TRIGGER.triggerForNearestPlayer(level, RoomTrigger.Triggers.FirstOpenFlagMenu, pos);
    }

    private static void openMenu(ServerPlayer sender, final TriFunction<Integer, Inventory, Player, AbstractContainerMenu> shower, List<UIQuest> quests, FlagTabsEmbedding.FlagInfo flagPos, Iterable<? extends VisitorMobEntity> entities, int bopCount) {
        Compat.openScreen(sender, new MenuProvider(){

            @NotNull
            public Component m_5446_() {
                return Compat.literal("");
            }

            @NotNull
            public AbstractContainerMenu m_7208_(int windowId, @NotNull Inventory inv, @NotNull Player p) {
                return (AbstractContainerMenu)shower.apply((Object)windowId, (Object)inv, (Object)p);
            }
        }, data -> FlagMenus.writeAndLink(data, quests, flagPos, sender, entities, bopCount));
    }

    private /* synthetic */ void lambda$showUI$2(ServerPlayer sender, ImmutableList quests, List uiQuests, FlagTabsEmbedding.FlagInfo flagInfo, BlockPos flagPos, Collection entities, TownInterface flag) {
        this.triggerAdvancementForAnyFarms(sender, (Collection<? extends Quest<ResourceLocation, ?>>)UtilClean.keys(quests));
        TownFlagMenus.openMenu(sender, (TriFunction<Integer, Inventory, Player, AbstractContainerMenu>)((TriFunction)(windowId, inv, p) -> new TownQuestsContainer((int)windowId, uiQuests, flagInfo, () -> this.triggerAdvancement(flagPos, sender.m_9236_()))), uiQuests, flagInfo, entities, flag.getBlocksOfProgress());
    }
}

