/*
 * Decompiled with CFR 0.152.
 */
package ca.bradj.questown.town;

import ca.bradj.questown.QT;
import ca.bradj.questown.items.QTNBT;
import ca.bradj.questown.jobs.declarative.DinerNoTableWork;
import ca.bradj.questown.jobs.declarative.DinerWork;
import ca.bradj.questown.mc.Util;
import ca.bradj.questown.town.InitPair;
import ca.bradj.questown.town.TownFlagBlockEntity;
import ca.bradj.questown.town.TownFlagInitialization;
import ca.bradj.questown.town.TownHealingHandle;
import ca.bradj.questown.town.TownKnowledgeStore;
import ca.bradj.questown.town.TownKnowledgeStoreSerializer;
import ca.bradj.questown.town.TownVillagerHandle;
import ca.bradj.questown.town.TownWorkHandleSerializer;
import ca.bradj.questown.town.WelcomeMatsSerializer;
import ca.bradj.questown.town.interfaces.TownInterface;
import ca.bradj.questown.town.quests.MCQuestBatches;
import ca.bradj.questown.town.rooms.TownRoomsMap;
import ca.bradj.questown.town.rooms.TownRoomsMapSerializer;
import ca.bradj.roomrecipes.adapter.RoomRecipeMatch;
import ca.bradj.roomrecipes.serialization.MCRoom;
import com.google.common.collect.ImmutableMap;
import java.util.Collection;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.NotNull;

public class TownFlagTileData {
    private static final String NBT_QUEST_BATCHES = String.format("%s_quest_batches", "questown");
    private static final String NBT_MORNING_REWARDS = String.format("%s_morning_rewards", "questown");
    private static final String NBT_WELCOME_MATS = String.format("%s_welcome_mats", "questown");
    private static final String NBT_ROOMS = String.format("%s_rooms", "questown");
    private static final String NBT_JOBS = String.format("%s_jobs", "questown");
    private static final String NBT_KNOWLEDGE = String.format("%s_knowledge", "questown");
    private static final String NBT_VILLAGERS = String.format("%s_villagers", "questown");
    private static final String NBT_HEALSPOTS = String.format("%s_heal_spots", "questown");
    private static final String NBT_BLOCKS_OF_PROGRESS_STORED = String.format("%s_bops_stored", "questown");
    private static final String NBT_BLOCK_ROOMS = QTNBT.keyify("block_rooms");

    public static Map<String, InitPair> initialize() {
        ImmutableMap.Builder b = ImmutableMap.builder();
        b.put((Object)NBT_ROOMS, (Object)TownFlagTileData.initRooms());
        b.put((Object)NBT_QUEST_BATCHES, (Object)TownFlagTileData.initQuestBatches());
        b.put((Object)NBT_MORNING_REWARDS, (Object)TownFlagTileData.initMorningRewards());
        b.put((Object)NBT_WELCOME_MATS, (Object)TownFlagTileData.initWelcomeMats());
        b.put((Object)NBT_BLOCK_ROOMS, (Object)TownFlagTileData.initBlockRooms());
        b.put((Object)NBT_JOBS, (Object)TownFlagTileData.initJobs());
        b.put((Object)NBT_KNOWLEDGE, (Object)TownFlagTileData.initKnowledge());
        b.put((Object)NBT_VILLAGERS, (Object)TownFlagTileData.initVillagers());
        b.put((Object)NBT_HEALSPOTS, (Object)TownFlagTileData.initHealSpots());
        b.put((Object)NBT_BLOCKS_OF_PROGRESS_STORED, (Object)TownFlagTileData.initBlocksOfProgress());
        return b.build();
    }

    @NotNull
    private static InitPair initRooms() {
        BiFunction<CompoundTag, TownFlagBlockEntity, Boolean> fromTag = (tag, t) -> {
            TownRoomsMap registeredRooms = t.initializer().getRoomsHandle().getRegisteredRooms();
            TownRoomsMapSerializer.INSTANCE.deserialize((CompoundTag)tag, (TownFlagBlockEntity)t, registeredRooms);
            QT.FLAG_LOGGER.debug("Initialized rooms from {}", tag);
            return true;
        };
        Consumer<TownFlagBlockEntity> onPlace = t -> {
            t.roomsHandle.initializeNew((TownFlagBlockEntity)t);
            QT.FLAG_LOGGER.debug("Initialized rooms for new flag");
        };
        return new InitPair(fromTag, onPlace);
    }

    @NotNull
    private static InitPair initQuestBatches() {
        BiFunction<CompoundTag, TownFlagBlockEntity, Boolean> fromTag = (tag, t) -> {
            t.quests.initialize((TownFlagBlockEntity)t);
            boolean inited = MCQuestBatches.SERIALIZER.deserializeNBT((TownInterface)t, (CompoundTag)tag, t.quests.questBatches);
            if (!inited) {
                t.initializer().setUpQuestsForNewlyPlacedFlag();
            }
            t.initializer().setInitializedQuests(true);
            QT.FLAG_LOGGER.debug("Initialized quests from {}", tag);
            return true;
        };
        Consumer<TownFlagBlockEntity> onPlace = t -> {
            t.quests.initialize((TownFlagBlockEntity)t);
            t.initializer().getQuests().initialize((TownFlagBlockEntity)t);
            QT.FLAG_LOGGER.debug("Initialized quests for new flag");
        };
        return new InitPair(fromTag, onPlace);
    }

    @NotNull
    private static InitPair initMorningRewards() {
        return new InitPair((tag, t) -> {
            t.initializer().getMorningRewards().deserializeNbt((TownInterface)t, (CompoundTag)tag);
            QT.FLAG_LOGGER.debug("Initialized morning rewards from {}", tag);
            return true;
        }, t -> QT.FLAG_LOGGER.debug("Initialized morning rewards for new flag"));
    }

    @NotNull
    private static InitPair initWelcomeMats() {
        BiFunction<CompoundTag, TownFlagBlockEntity, Boolean> fromTag = (tag, t) -> {
            Collection<BlockPos> l = WelcomeMatsSerializer.INSTANCE.deserializeNBT((CompoundTag)tag, "mats");
            l.forEach(t.initializer().getPOIs()::registerWelcomeMat);
            QT.FLAG_LOGGER.debug("Initialized welcome mats from {}", tag);
            return true;
        };
        Consumer<TownFlagBlockEntity> onPlace = t -> QT.FLAG_LOGGER.debug("Initialized welcome mats for new flag");
        return new InitPair(fromTag, onPlace);
    }

    @NotNull
    private static InitPair initBlockRooms() {
        BiFunction<CompoundTag, TownFlagBlockEntity, Boolean> fromTag = (tag, t) -> t.initializer().initBlockRooms((CompoundTag)tag, (TownFlagBlockEntity)t);
        Consumer<TownFlagBlockEntity> onPlace = t -> QT.FLAG_LOGGER.debug("Initialized block rooms for new flag");
        return new InitPair(fromTag, onPlace);
    }

    @NotNull
    private static InitPair initJobs() {
        return new InitPair((tag, t) -> {
            TownWorkHandleSerializer.INSTANCE.deserializeNBT((CompoundTag)tag, t.workHandle);
            QT.FLAG_LOGGER.debug("Initialized jobs from {}", tag);
            return true;
        }, t -> QT.FLAG_LOGGER.debug("Initialized jobs for new flag"));
    }

    @NotNull
    private static InitPair initKnowledge() {
        BiFunction<CompoundTag, TownFlagBlockEntity, Boolean> fromTag = (tag, t) -> {
            TownKnowledgeStore knowledge = t.initializer().getKnowledge();
            if (!knowledge.isInitialized()) {
                return false;
            }
            TownKnowledgeStoreSerializer.INSTANCE.deserializeNBT((CompoundTag)tag, knowledge);
            QT.FLAG_LOGGER.debug("Initialized knowledge from {}", tag);
            return true;
        };
        Consumer<TownFlagBlockEntity> onFlagPlace = t -> {
            t.initializer().getKnowledge().initialize((TownFlagBlockEntity)t);
            QT.FLAG_LOGGER.debug("Initialized knowledge for new flag");
        };
        return new InitPair(fromTag, onFlagPlace);
    }

    @NotNull
    private static InitPair initVillagers() {
        BiFunction<CompoundTag, TownFlagBlockEntity, Boolean> fromTag = (tag, t) -> {
            long currentTick = Util.getTick(t.getServerLevel());
            TownVillagerHandle.SERIALIZER.deserialize((CompoundTag)tag, t.initializer().getVillagers(), currentTick);
            QT.FLAG_LOGGER.debug("Initialized villagers from {}", tag);
            return true;
        };
        Consumer<TownFlagBlockEntity> onPlace = t -> {
            TownVillagerHandle villagerHandle = t.initializer().getVillagers();
            villagerHandle.associate((TownFlagBlockEntity)t);
            villagerHandle.addHungryListener(e -> {
                if (t.getVillagerHandle().isDining(e.m_20148_())) {
                    return;
                }
                if (!t.getVillagerHandle().canDine(e.m_20148_())) {
                    return;
                }
                String rid = e.getJobId().rootId();
                ResourceLocation diningRoom = DinerWork.asWork((String)rid).baseRoom;
                Collection<RoomRecipeMatch<MCRoom>> diningRooms = t.roomsHandle.getRoomsMatching(diningRoom);
                if (diningRooms.isEmpty()) {
                    t.getVillagerHandle().changeJobForVillager(e.m_20148_(), DinerNoTableWork.getIdForRoot(rid), false);
                } else {
                    t.getVillagerHandle().changeJobForVillager(e.m_20148_(), DinerWork.getIdForRoot(rid), false);
                }
            });
            villagerHandle.addStatsListener(s -> t.m_6596_());
            QT.FLAG_LOGGER.debug("Initialized villagers for new flag");
        };
        return new InitPair(fromTag, onPlace);
    }

    private static InitPair initHealSpots() {
        return new InitPair((tag, town) -> {
            TownHealingHandle.SERIALIZER.deserialize((CompoundTag)tag, town.initializer().getHealing());
            QT.FLAG_LOGGER.debug("Initialized healing spots from {}", tag);
            return true;
        }, town -> town.initializer().getHealing().initialize((TownFlagBlockEntity)town));
    }

    private static InitPair initBlocksOfProgress() {
        return new InitPair((tag, town) -> {
            town.initializer().initializeBOP((CompoundTag)tag);
            return true;
        }, town -> {});
    }

    public static void write(Long currentTick, CompoundTag t, TownFlagInitialization flag) {
        TownFlagTileData.write(t, NBT_QUEST_BATCHES, MCQuestBatches.SERIALIZER.serializeNBT(flag.getQuestBatches()));
        TownFlagTileData.write(t, NBT_MORNING_REWARDS, flag.getMorningRewards().serializeNbt());
        TownFlagTileData.write(t, NBT_WELCOME_MATS, WelcomeMatsSerializer.INSTANCE.serializeNBT((Collection<BlockPos>)flag.getPOIs().getWelcomeMats(), "mats"));
        TownFlagTileData.write(t, NBT_ROOMS, TownRoomsMapSerializer.INSTANCE.serializeNBT(flag.getRoomsHandle().getRegisteredRooms()));
        TownFlagTileData.write(t, NBT_JOBS, TownWorkHandleSerializer.INSTANCE.serializeNBT(flag.getWorkHandle()));
        TownFlagTileData.write(t, NBT_KNOWLEDGE, TownKnowledgeStoreSerializer.INSTANCE.serializeNBT(flag.getKnowledge()));
        TownFlagTileData.write(t, NBT_VILLAGERS, TownVillagerHandle.SERIALIZER.serialize(flag.getVillagers(), currentTick));
        TownFlagTileData.write(t, NBT_HEALSPOTS, TownHealingHandle.SERIALIZER.serialize(flag.getVillagers(), currentTick));
        TownFlagTileData.write(t, NBT_BLOCKS_OF_PROGRESS_STORED, flag.serializeBOP());
        TownFlagTileData.write(t, NBT_BLOCK_ROOMS, flag.serializeBlockRooms());
    }

    private static void write(CompoundTag target, String key, CompoundTag value) {
        target.m_128365_(key, (Tag)value);
    }
}

