/*
 * Decompiled with CFR 0.152.
 */
package ca.bradj.questown.town;

import ca.bradj.questown.QT;
import ca.bradj.questown.core.UtilClean;
import ca.bradj.questown.jobs.JobID;
import ca.bradj.questown.logic.RoomRecipes;
import ca.bradj.questown.mc.Compat;
import ca.bradj.questown.town.quests.MCQuest;
import ca.bradj.questown.town.quests.Quest;
import ca.bradj.roomrecipes.core.space.Position;
import ca.bradj.roomrecipes.serialization.MCRoom;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import org.jetbrains.annotations.Nullable;

public class TownMessages {
    private ServerLevel level;

    public void initialize(ServerLevel t) {
        this.level = t;
    }

    void broadcastMessage(String key, Object ... args) {
        if (this.level == null) {
            QT.FLAG_LOGGER.debug("Skipping message broadcast before TownMessages was initialized: {} {}", (Object)key, (Object)args);
            return;
        }
        QT.FLAG_LOGGER.info("Broadcasting message: {} {}", (Object)key, (Object)args);
        for (ServerPlayer p : this.level.m_7654_().m_6846_().m_11314_()) {
            p.m_5661_((Component)Compat.translatable(key, args), false);
        }
    }

    public void roomRecipeCreated(MCRoom roomDoorPos, Optional<ResourceLocation> match) {
        this.broadcastMessage("messages.building.recipe_created", RoomRecipes.getName(match), roomDoorPos.getDoorPos().getUIString());
    }

    public void roomRecipeChanged(ResourceLocation oldMatchID, ResourceLocation newMatchID, MCRoom newRoom) {
        this.broadcastMessage("messages.building.room_changed", Compat.translatable("room." + oldMatchID.m_135815_()), Compat.translatable("room." + newMatchID.m_135815_()), newRoom.getDoorPos().getUIString());
    }

    public void roomRecipeDestroyed(MCRoom roomDoorPos, @Nullable ResourceLocation oldRecipeId) {
        this.broadcastMessage("messages.building.room_destroyed", RoomRecipes.getName(Optional.ofNullable(oldRecipeId)), roomDoorPos.getDoorPos().getUIString());
    }

    public void questCompleted(MCQuest quest) {
        Component name = RoomRecipes.getName((ResourceLocation)quest.getWantedId());
        if (quest.getType() == Quest.QuestType.ITEM) {
            name = Compat.translatable("menu.common.quantity", Compat.getItemName((ResourceLocation)quest.getWantedId()), quest.getCountNeeded());
        }
        this.broadcastMessage("messages.town_flag.quest_completed", name);
    }

    public void questLost(MCQuest quest) {
        Component name = RoomRecipes.getName((ResourceLocation)quest.getWantedId());
        if (quest.getType() == Quest.QuestType.ITEM) {
            name = Compat.translatable("menu.common.quantity", Compat.getItemName((ResourceLocation)quest.getWantedId()), quest.getCountNeeded());
        }
        this.broadcastMessage("messages.town_flag.quest_lost", name);
    }

    public void jobChanged(JobID jobID, UUID visitorUUID) {
        this.broadcastMessage("messages.jobs.changed", jobID.toNiceString(), UtilClean.truncateMiddle(visitorUUID));
    }

    public void startDebugFailed() {
        this.broadcastMessage("First you must enabled debug mode on the flag via the /qtdebug <POS> command", new Object[0]);
    }

    public void debugToggled(boolean debugMode) {
        this.broadcastMessage("message.debug_mode", debugMode ? "enabled" : "disabled");
    }

    public void batchRemoved() {
        this.broadcastMessage("messages.town_flag.quest_batch_removed_1", new Object[0]);
        this.broadcastMessage("messages.town_flag.quest_batch_removed_2", new Object[0]);
    }

    public void roomCreated(@Nullable ResourceLocation recipe, Position doorPos) {
        if (recipe == null) {
            this.broadcastMessage("messages.building.room_created", doorPos.getUIString());
        } else {
            this.broadcastMessage("messages.building.specific_room_created", RoomRecipes.getName(recipe), doorPos.getUIString());
        }
    }

    public void roomSizeChanged(@Nullable ResourceLocation recipe, Position doorPos) {
        this.broadcastMessage("messages.building.room_size_changed", RoomRecipes.getName(Optional.ofNullable(recipe)), doorPos.getUIString());
    }

    public void roomDestroyed(@Nullable ResourceLocation recipe, Position doorPos) {
        this.broadcastMessage("messages.building.room_destroyed", RoomRecipes.getName(Optional.ofNullable(recipe)), doorPos.getUIString());
    }
}

