/*
 * Decompiled with CFR 0.152.
 */
package ca.bradj.questown.town;

import ca.bradj.questown.QT;
import ca.bradj.questown.blocks.JobBlock;
import ca.bradj.questown.core.Config;
import ca.bradj.questown.core.UtilClean;
import ca.bradj.questown.gui.Ingredients;
import ca.bradj.questown.integration.minecraft.MCContainer;
import ca.bradj.questown.integration.minecraft.MCHeldItem;
import ca.bradj.questown.integration.minecraft.MCTownItem;
import ca.bradj.questown.jobs.Containers;
import ca.bradj.questown.jobs.DeclarativeJob;
import ca.bradj.questown.jobs.Job;
import ca.bradj.questown.jobs.JobBlockTestContext;
import ca.bradj.questown.jobs.JobID;
import ca.bradj.questown.jobs.Jobs;
import ca.bradj.questown.jobs.ServerJobsRegistry;
import ca.bradj.questown.jobs.Work;
import ca.bradj.questown.jobs.Works;
import ca.bradj.questown.jobs.declarative.WithReason;
import ca.bradj.questown.jobs.leaver.ContainerTarget;
import ca.bradj.questown.jobs.production.ProductionStatus;
import ca.bradj.questown.logic.PredicateCollection;
import ca.bradj.questown.mc.Compat;
import ca.bradj.questown.mc.Util;
import ca.bradj.questown.mobs.visitor.VisitorMobEntity;
import ca.bradj.questown.town.NoMCEconomics;
import ca.bradj.questown.town.TownContainers;
import ca.bradj.questown.town.TownFlagBlockEntity;
import ca.bradj.questown.town.UnsafeTown;
import ca.bradj.questown.town.interfaces.VillagerHolder;
import ca.bradj.questown.town.interfaces.WorkStatusHandle;
import ca.bradj.roomrecipes.adapter.RoomRecipeMatch;
import ca.bradj.roomrecipes.serialization.MCRoom;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.function.Supplier;
import java.util.stream.Stream;
import joptsimple.internal.Strings;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;

public class TownPossibleWork {
    private final UnsafeTown town = new UnsafeTown(this.getClass());
    private final Map<String, List<JobID>> preselectedJobs = new HashMap<String, List<JobID>>();
    private boolean shouldRecompute = true;
    private int buffer;

    public void initialize(TownFlagBlockEntity serverLevel) {
        this.town.initialize(serverLevel);
    }

    public void tick() {
        if (!this.shouldRecompute) {
            return;
        }
        ++this.buffer;
        int freq = ((Long)Config.WORK_PRECOMPUTE_FREQUENCY.get()).intValue();
        this.buffer %= freq;
        if (this.buffer != 0) {
            return;
        }
        TownFlagBlockEntity t = this.town.getUnsafe();
        Stream<String> roots = t.getVillagerHandle().getJobs().stream().map(JobID::rootId);
        ImmutableSet<Map.Entry<JobID, Supplier<Work>>> rjs = Works.regularJobs();
        roots.forEach(root -> {
            List<JobPossibility> unfilteredJobs = TownPossibleWork.getJobsSortedByPossibility(root, rjs, t);
            QT.FLAG_LOGGER.debug("Possible jobs for root {}: [{}]", root, (Object)Strings.join(unfilteredJobs.stream().map(JobPossibility::toString).toList(), (String)","));
            List<JobPossibility> jobs = unfilteredJobs.stream().filter(v -> (Double)v.score.value > (Double)Config.PREFERRED_JOB_ACCEPTANCE.get()).toList();
            if (jobs.isEmpty()) {
                jobs = unfilteredJobs.stream().filter(v -> (Double)v.score.value > (Double)Config.MIN_JOB_ACCEPTANCE.get()).toList();
            }
            ImmutableList preselected = (ImmutableList)jobs.stream().map(v -> v.jobID).collect(ImmutableList.toImmutableList());
            this.preselectedJobs.put((String)root, (List<JobID>)preselected);
            if (jobs.isEmpty()) {
                this.registerUnmetNeeds((String)root);
            }
            QT.FLAG_LOGGER.debug("Prepared for {}: [{}]", root, (Object)Strings.join(preselected.stream().map(JobID::jobId).toList(), (String)","));
        });
        this.shouldRecompute = false;
    }

    private void registerUnmetNeeds(String root) {
        try {
            ServerLevel sl = this.town.getServerLevelUnsafe();
            long tick = Util.getTick(sl);
            VillagerHolder vh = this.town.getUnsafe().getVillagerHandle();
            Work work = ServerJobsRegistry.getRandomWork(sl, root, vh::isUnlocked);
            NoMCEconomics econ = this.town.getUnsafe().getEconomicsHandle();
            vh.entities().stream().map(v -> (VisitorMobEntity)v).filter(v -> root.equals(v.getJobId().rootId())).forEach(villager -> this.registerUnmetNed(work, econ, tick, villager.m_20148_()));
        }
        catch (Exception e) {
            QT.FLAG_LOGGER.error("Failed to register unmet needs for root: {}", (Object)root, (Object)e);
        }
    }

    private void registerUnmetNed(Work work, NoMCEconomics econ, long tick, UUID uuid) {
        DeclarativeJob x = (DeclarativeJob)work.jobFunc.apply(uuid);
        Ingredient xx = (Ingredient)x.initialIngredients.get((Object)0);
        if (xx == null && (xx = (Ingredient)x.initialTools.get((Object)0)) == null) {
            return;
        }
        econ.registerUnmetNeed(tick, uuid, Ingredients.toString(xx));
    }

    private static List<JobPossibility> getJobsSortedByPossibility(String root, ImmutableSet<Map.Entry<JobID, Supplier<Work>>> allJobs, TownFlagBlockEntity t) {
        List<Map.Entry> e = allJobs.stream().filter(v -> root.equals(((JobID)v.getKey()).rootId())).toList();
        ImmutableList.Builder b = ImmutableList.builder();
        for (Map.Entry w : e) {
            b.add((Object)new JobPossibility((JobID)w.getKey(), TownPossibleWork.getWorkPercentPossible(t, w)));
        }
        return b.build();
    }

    private static WithReason<Double> getWorkPercentPossible(TownFlagBlockEntity t, Map.Entry<JobID, Supplier<Work>> w) {
        Work work = w.getValue().get();
        Job j = (Job)work.jobFunc.apply(UUID.randomUUID());
        if (!(j instanceof DeclarativeJob)) {
            return WithReason.always(0.0, "Unsupported job class " + j.getClass().getName(), new Object[0]);
        }
        DeclarativeJob dj = (DeclarativeJob)j;
        if (!ServerJobsRegistry.canFit(null, j.getId(), Util.getDayTime((Level)t.getServerLevel()))) {
            QT.FLAG_LOGGER.trace("Villager will not do {} because there is not enough time left in the day", (Object)j.getId().toNiceString());
            return WithReason.always(0.0, "Not enough time left in the day", new Object[0]);
        }
        WithReason<Integer> hps = TownPossibleWork.getHighestPossibleState(t, dj);
        double v = (double)((Integer)hps.value).intValue() / (double)dj.getMaxState();
        float shuffler = (float)Compat.nextRandomInt(t.getServerLevel(), 100) / 10000.0f;
        return WithReason.always(v + (double)shuffler, "Highest possible job state: " + String.valueOf(hps) + " (out of " + dj.getMaxState() + ", with randomizer " + shuffler + ")", new Object[0]);
    }

    private static WithReason<Integer> getHighestPossibleState(TownFlagBlockEntity t, DeclarativeJob dj) {
        int ii;
        int i;
        if (dj.specialGlobalRules.contains((Object)"always_consider")) {
            return WithReason.always(dj.getMaxState(), "Special rule ALWAYS_CONSIDER present", new Object[0]);
        }
        boolean townHasJobSite = false;
        ServerLevel sl = (ServerLevel)Preconditions.checkNotNull((Object)t.getServerLevel());
        for (i = 0; i < dj.getMaxState(); ++i) {
            Collection<RoomRecipeMatch<MCRoom>> rooms;
            Object roomsWS;
            ii = i;
            WorkStatusHandle<BlockPos, MCHeldItem> ws = t.getWorkStatusHandle(null);
            ProductionStatus s = ProductionStatus.fromJobBlockStatus(ii);
            if (UtilClean.getOrDefaultCollection(dj.specialRules, s, ImmutableList.of()).contains((Object)"claim_spot") || (roomsWS = Jobs.roomsWithState(rooms = t.getRoomHandle().getRoomsMatching(dj.location().baseRoom()), bp -> TownPossibleWork.isJobBlock(t, dj, bp, sl), bp -> Integer.valueOf(ii).equals(JobBlock.getState(ws::getJobBlockState, bp)))).isEmpty()) continue;
            townHasJobSite = true;
            break;
        }
        if (!townHasJobSite) {
            return WithReason.always(0, "Town lacks required job site (or descendant) of: " + String.valueOf(dj.location().baseRoom()), new Object[0]);
        }
        for (i = 0; i < dj.getMaxState(); ++i) {
            ii = i;
            boolean townHasIngredient = true;
            PredicateCollection<MCHeldItem, MCHeldItem> ing = dj.getChecks().getIngredientsForStep(ii);
            if (ing != null) {
                townHasIngredient = false;
                List<ContainerTarget<MCContainer, MCTownItem>> foundContainer = Containers.get(t, r -> true, bp -> TownPossibleWork.isJobBlock(t, dj, bp, sl), js -> dj.location().baseRoom().equals(js), false);
                for (ContainerTarget containerTarget : foundContainer) {
                    if (!containerTarget.hasItem(zzz -> ing.test(MCHeldItem.fromTown(zzz)))) continue;
                    townHasIngredient = true;
                    break;
                }
            }
            boolean townHasTool = true;
            PredicateCollection<MCTownItem, ?> tool = dj.getChecks().getToolsForStep(ii);
            if (tool != null) {
                townHasTool = false;
                @Nullable ContainerTarget<MCContainer, MCTownItem> containerTarget = t.findMatchingContainer(tool::test);
                if (containerTarget != null) {
                    townHasTool = true;
                }
            }
            if (townHasIngredient && townHasTool) continue;
            int n = Math.max(0, i - 1);
            return WithReason.always(n, "Lacking " + (townHasIngredient ? "" : "ingredients ") + (townHasTool ? "" : "tools ") + "for job state " + ii + "/" + dj.getMaxState(), new Object[0]);
        }
        return WithReason.always(dj.getMaxState(), "All ingredients and tools available for all job states", new Object[0]);
    }

    private static boolean isJobBlock(TownFlagBlockEntity t, DeclarativeJob dj, BlockPos bp, ServerLevel sl) {
        return dj.location().isJobBlock().test(new JobBlockTestContext(sl, Util.info(sl), bp, ImmutableList::of, TownPossibleWork.unique(t), false, false));
    }

    private static Supplier<? extends Collection<Item>> unique(TownFlagBlockEntity t) {
        return () -> TownContainers.getUniqueItems(t);
    }

    public ImmutableList<JobID> getFor(JobID jobId) {
        return UtilClean.getOrDefaultCollection(this.preselectedJobs, jobId.rootId(), ImmutableList.of());
    }

    public void invalidate() {
        this.shouldRecompute = true;
    }

    private record JobPossibility(JobID jobID, WithReason<Double> score) {
        @Override
        public String toString() {
            return "JobPossibility{jobID=" + String.valueOf(this.jobID) + ", score=" + String.valueOf(this.score) + "}";
        }
    }
}

