/*
 * Decompiled with CFR 0.152.
 */
package ca.bradj.questown.town;

import ca.bradj.questown.QT;
import ca.bradj.questown.blocks.RoomBlock;
import ca.bradj.questown.blocks.entity.BlockAsRoomEntity;
import ca.bradj.questown.core.Config;
import ca.bradj.questown.core.VillagerUUID;
import ca.bradj.questown.integration.minecraft.MCTownItem;
import ca.bradj.questown.jobs.ServerJobsRegistry;
import ca.bradj.questown.logic.RoomRecipes;
import ca.bradj.questown.mc.Compat;
import ca.bradj.questown.roomrecipes.Matches;
import ca.bradj.questown.town.NoMCEconomics;
import ca.bradj.questown.town.TownFlagBlockEntity;
import ca.bradj.questown.town.UnsafeTown;
import ca.bradj.questown.town.interfaces.TownInterface;
import ca.bradj.questown.town.quests.MCDelayedReward;
import ca.bradj.questown.town.quests.MCInstantReward;
import ca.bradj.questown.town.quests.MCQuest;
import ca.bradj.questown.town.quests.MCQuestBatch;
import ca.bradj.questown.town.quests.MCQuestBatches;
import ca.bradj.questown.town.quests.MCReward;
import ca.bradj.questown.town.quests.MCRewardList;
import ca.bradj.questown.town.quests.PendingReward;
import ca.bradj.questown.town.quests.Quest;
import ca.bradj.questown.town.quests.QuestBatch;
import ca.bradj.questown.town.quests.QuestBatchSeed;
import ca.bradj.questown.town.quests.QuestBatches;
import ca.bradj.questown.town.quests.RoomNeed;
import ca.bradj.questown.town.rewards.AddBatchOfRandomQuestsForVisitorReward;
import ca.bradj.questown.town.rewards.AddItemQuestReward;
import ca.bradj.questown.town.rewards.AddRandomUpgradeQuest;
import ca.bradj.questown.town.rewards.ChangeJobReward;
import ca.bradj.questown.town.rewards.SpawnVisitorReward;
import ca.bradj.questown.town.special.SpecialQuests;
import ca.bradj.roomrecipes.adapter.RoomRecipeMatch;
import ca.bradj.roomrecipes.recipes.ActiveRecipes;
import ca.bradj.roomrecipes.recipes.RecipesInit;
import ca.bradj.roomrecipes.recipes.RoomRecipe;
import ca.bradj.roomrecipes.serialization.MCRoom;
import com.google.common.base.Predicates;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Stack;
import java.util.UUID;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import joptsimple.internal.Strings;
import net.minecraft.core.NonNullList;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.projectile.FireworkRocketEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TownQuests
implements QuestBatch.ChangeListener<MCQuest>,
ActiveRecipes.ChangeListener<MCRoom, RoomRecipeMatch<MCRoom>> {
    private static final QuestBatches.Tracker<ResourceLocation, MCTownItem, MCQuest> TRACKER = new QuestBatches.Tracker<ResourceLocation, MCTownItem, MCQuest>(){

        @Override
        public int addCount(Map<ResourceLocation, Integer> map, MCTownItem stack) {
            return map.merge(Compat.getItemId(stack.get()), stack.toMCItemStack().m_41613_(), Integer::sum);
        }

        @Override
        public void removeCount(Map<ResourceLocation, Integer> map, MCQuest mcQuest) {
            map.merge((ResourceLocation)mcQuest.getWantedId(), -mcQuest.getCountNeeded(), Integer::sum);
        }
    };
    @Nullable
    private QuestBatchSeed pendingQuests = null;
    private final Stack<PendingReward> questRequests = new Stack();
    final MCQuestBatches questBatches = new MCQuestBatches(MCQuestBatch::new);
    private final UnsafeTown town = new UnsafeTown(this.getClass());
    boolean playerDiscardedLastBatch;

    TownQuests() {
        this.questBatches.addChangeListener(this);
    }

    public static void setUpQuestsForNewlyPlacedFlag(TownInterface town, TownQuests quests) {
        MCRewardList reward = TownQuests.defaultQuestCompletionRewards(town);
        MCQuestBatch fireQuest = new MCQuestBatch(null, null, new MCDelayedReward(town, reward));
        fireQuest.addNewQuest(null, SpecialQuests.CAMPFIRE);
        quests.questBatches.add(fireQuest);
    }

    @NotNull
    public static MCRewardList defaultQuestCompletionRewards(TownInterface town) {
        UUID nextVisitorUUID = UUID.randomUUID();
        if (town.getVillagerHandle().size() == 1L) {
            return new MCRewardList(town, new SpawnVisitorReward(town, nextVisitorUUID), new AddItemQuestReward(town, Compat.getItemId(Items.f_42410_), 10));
        }
        MCRewardList newVisitor = new MCRewardList(town, new SpawnVisitorReward(town, nextVisitorUUID), new AddBatchOfRandomQuestsForVisitorReward(town, nextVisitorUUID));
        if (town.getQuestHandle().getVillagersWithQuests().isEmpty()) {
            return newVisitor;
        }
        UUID randomVillager = town.getRandomVillager();
        if (Compat.getRandomBool(town.getServerLevel()) && randomVillager != null) {
            return new MCRewardList(town, new AddRandomUpgradeQuest(town, randomVillager));
        }
        return newVisitor;
    }

    public static void addUpgradeQuest(TownInterface town, TownQuests quests, VillagerUUID visitorUUID) {
        MCRewardList reward = TownQuests.defaultQuestCompletionRewards(town);
        List<MCQuest> doneAndMaybeAlreadyUpgraded = quests.getAllForVillager(visitorUUID).stream().filter(Quest::isComplete).toList();
        List<MCQuest> doneAndReadyForFirstUpgrade = doneAndMaybeAlreadyUpgraded.stream().filter(v -> v.fromRecipeID().isEmpty()).toList();
        List<MCQuest> villagerQuests = doneAndReadyForFirstUpgrade;
        if (villagerQuests.isEmpty()) {
            villagerQuests = doneAndMaybeAlreadyUpgraded;
        }
        if (villagerQuests.isEmpty()) {
            QT.QUESTS_LOGGER.error("No upgrade paths could be determined because no quests have been completed yet for {}", (Object)visitorUUID);
            QT.QUESTS_LOGGER.info("Skipping generation. The flag entity will generate a random batch instead.");
            return;
        }
        ImmutableList upgradableQuests = Compat.shuffle(villagerQuests.iterator(), town.getServerLevel());
        for (MCQuest upgradable : upgradableQuests) {
            ResourceLocation upgradeFrom = (ResourceLocation)upgradable.getWantedId();
            ResourceLocation upgradeRecipe = TownQuests.getUpgradeRecipe((Level)town.getServerLevel(), upgradeFrom);
            if (upgradeRecipe == null) {
                QT.QUESTS_LOGGER.debug("No upgrade recipe found for {}. Skipping.", (Object)upgradeFrom);
                continue;
            }
            MCQuestBatch upgradeQuest = new MCQuestBatch(UUID.randomUUID(), visitorUUID, new MCDelayedReward(town, reward));
            upgradeQuest.addNewUpgradeQuest(visitorUUID, upgradeFrom, upgradeRecipe);
            quests.questBatches.add(upgradeQuest);
            return;
        }
        QT.QUESTS_LOGGER.info("No upgrade paths could be determined.");
        QT.QUESTS_LOGGER.info("Skipping generation. The flag entity will generate a random batch instead.");
    }

    public static void addJobQuest(TownFlagBlockEntity town, TownQuests quests, VillagerUUID visitorUUID) {
        ImmutableList jobs = ImmutableList.copyOf(town.getAvailableRootJobs());
        int jobIdx = Compat.getRandomInt(town.getServerLevel(), jobs.size());
        String job = (String)jobs.get(jobIdx);
        MCRewardList reward = new MCRewardList((TownInterface)town, new ChangeJobReward(town, VillagerUUID.get(visitorUUID), job), new AddBatchOfRandomQuestsForVisitorReward(town, town.getRandomVillager()));
        MCQuestBatch jobQuest = new MCQuestBatch(UUID.randomUUID(), visitorUUID, new MCInstantReward(town, reward));
        jobQuest.addNewQuest(visitorUUID, ServerJobsRegistry.getRoomForJobRootId(town.getServerLevel(), job));
        if (!town.getWorkHandle().hasAtLeastOneBoard()) {
            jobQuest.addNewQuest(visitorUUID, SpecialQuests.JOB_BOARD);
        }
        quests.questBatches.add(jobQuest);
    }

    @Nullable
    private static ResourceLocation getUpgradeRecipe(Level level, ResourceLocation fromRecipeId) {
        Optional<RoomRecipe> fromRecipe = RoomRecipes.getById(level, fromRecipeId);
        if (fromRecipe.isEmpty()) {
            return null;
        }
        NonNullList fromIngredients = fromRecipe.get().m_7527_();
        List<RoomRecipe> all = RoomRecipes.getAllRecipes(level);
        ImmutableList.Builder possibleUpgrades = ImmutableList.builder();
        for (RoomRecipe aRecipe : all) {
            List<List<String>> fromIng;
            List<List<String>> toIng = TownQuests.getItemKeyStrings((NonNullList<Ingredient>)aRecipe.m_7527_());
            if (toIng.equals(fromIng = TownQuests.getItemKeyStrings((NonNullList<Ingredient>)fromIngredients)) || !RoomRecipes.containsAllTags(fromIng, toIng)) continue;
            possibleUpgrades.add((Object)aRecipe.m_6423_());
        }
        ImmutableList upgrades = possibleUpgrades.build();
        if (upgrades.isEmpty()) {
            return null;
        }
        return (ResourceLocation)upgrades.get(level.m_213780_().m_188503_(upgrades.size()));
    }

    @NotNull
    private static List<List<String>> getItemKeyStrings(NonNullList<Ingredient> ing) {
        return ing.stream().map(v -> Arrays.stream(v.m_43908_()).map(ItemStack::m_41720_).map(arg_0 -> ((IForgeRegistry)ForgeRegistries.ITEMS).getKey(arg_0)).filter(Objects::nonNull).map(ResourceLocation::toString).toList()).toList();
    }

    public static void addRandomBatchForVisitor(TownInterface town, TownQuests quests, @Nullable VillagerUUID visitorUUID) {
        @NotNull MCRewardList reward = TownQuests.defaultQuestCompletionRewards(town);
        quests.questRequests.add(new PendingReward(visitorUUID, reward));
    }

    public static void addItemQuest(TownFlagBlockEntity t, TownQuests quests, ResourceLocation itemId, int count) {
        @NotNull MCRewardList reward = TownQuests.defaultQuestCompletionRewards(t);
        MCQuestBatch batch = new MCQuestBatch(null, null, new MCDelayedReward(t, reward));
        batch.addItemQuest(null, itemId, count);
        quests.addBatch(batch);
    }

    public static ImmutableSet<UUID> getVillagers(TownQuests quests) {
        return ImmutableSet.copyOf((Collection)quests.questBatches.getAllBatches().stream().map(MCQuestBatch::getOwner).map(VillagerUUID::get).filter(Objects::nonNull).collect(Collectors.toSet()));
    }

    public void tick(TownInterface town) {
        ServerLevel level = town.getServerLevel();
        int size = TownQuests.getVillagers(this).size();
        if (this.playerDiscardedLastBatch) {
            --size;
        }
        int targetItemWeight = (Integer)Config.MIN_WEIGHT_PER_QUEST_BATCH.get() + (Integer)Config.QUEST_BATCH_VILLAGER_BOOST_FACTOR.get() * (size + 2) / 2;
        if (this.pendingQuests == null) {
            QT.QUESTS_LOGGER.debug("Preparing quest batch with target weight: {}", (Object)targetItemWeight);
            this.pendingQuests = new QuestBatchSeed(level, UUID.randomUUID(), targetItemWeight);
        }
        QuestBatchSeed pop = this.pendingQuests;
        this.pendingQuests = null;
        boolean canGrowMore = pop.grow(town::hasEnoughBeds, () -> this.getNeededRooms(town.getEconomicsHandle()).stream().filter(v -> TownQuests.isNotSpecial((ResourceLocation)v.id())).toList(), () -> {
            List<RoomRecipe> rs = level.m_7465_().m_44013_(RecipesInit.ROOM).stream().filter(v -> TownQuests.isNotSpecial(v.m_6423_())).toList();
            ArrayList<RoomRecipe> recipes = new ArrayList<RoomRecipe>(rs);
            for (Supplier<RoomBlock> roomBlockSupplier : BlockAsRoomEntity.ALL) {
                recipes.add(roomBlockSupplier.get().asRecipe());
            }
            List<ResourceLocation> ids = recipes.stream().map(RoomRecipe::m_6423_).toList();
            return ids;
        });
        if (canGrowMore) {
            QT.QUESTS_LOGGER.debug("Batch after growth is: ({}/{})[{}]", (Object)pop.getCostSoFar(), (Object)targetItemWeight, (Object)Strings.join(((MCQuestBatch)pop.get()).getAll().stream().map(Quest::getWantedId).map(ResourceLocation::toString).toList(), (String)", "));
        }
        if (canGrowMore) {
            if (!this.questRequests.isEmpty()) {
                QT.QUESTS_LOGGER.warn("Quest batch was not ready when requested");
            }
            this.pendingQuests = pop;
            return;
        }
        if (!this.questRequests.isEmpty()) {
            PendingReward pr = this.questRequests.pop();
            MCDelayedReward rw = new MCDelayedReward(town, pr.reward());
            MCQuestBatch q = pop.get(rw, pr.owner());
            this.questBatches.add(q);
            QT.QUESTS_LOGGER.debug("Precompiled quest batch was given to {}: {}", (Object)pr.owner(), (Object)q.toNiceString());
            this.playerDiscardedLastBatch = false;
            return;
        }
        this.pendingQuests = pop;
    }

    private static boolean isNotSpecial(ResourceLocation id) {
        if (SpecialQuests.FARM.equals((Object)id)) {
            return true;
        }
        return !SpecialQuests.SPECIAL_QUESTS.containsKey(id);
    }

    private ImmutableList<RoomNeed<ResourceLocation>> getNeededRooms(NoMCEconomics economicsHandle) {
        ImmutableList.Builder b = ImmutableList.builder();
        for (RoomNeed<String> v : economicsHandle.getAggregatedRooms()) {
            b.add(new RoomNeed<ResourceLocation>(new ResourceLocation(v.id()), v.timesNeeded(), v.timesNeeded()));
        }
        return b.build();
    }

    public void markQuestAsComplete(MCRoom room, ResourceLocation q) {
        this.questBatches.markRecipeAsComplete(room, q);
    }

    public void markAsConverted(MCRoom room, ResourceLocation oldRecipeID, ResourceLocation newRecipeID) {
        this.questBatches.markRecipeAsConverted(room, oldRecipeID, newRecipeID);
    }

    public void markQuestAsLost(MCRoom oldRoom, ResourceLocation recipeID) {
        this.questBatches.markRecipeAsLost(oldRoom, recipeID);
    }

    @Override
    public void questCompleted(MCQuest quest) {
        @NotNull TownFlagBlockEntity t = this.town.getUnsafe();
        t.messages.questCompleted(quest);
        t.m_6596_();
        FireworkRocketEntity firework = new FireworkRocketEntity((Level)this.town.getServerLevelUnsafe(), (double)t.m_58899_().m_123341_(), (double)(t.m_58899_().m_123342_() + 10), (double)t.m_58899_().m_123343_(), new ItemStack((ItemLike)Items.f_42688_.m_7968_().m_41720_(), 3));
        this.town.getServerLevelUnsafe().m_7967_((Entity)firework);
    }

    @Override
    public void questLost(MCQuest quest) {
        @NotNull TownFlagBlockEntity t = this.town.getUnsafe();
        t.messages.questLost(quest);
        t.m_6596_();
    }

    @Override
    public void questBatchCompleted(QuestBatch<?, ?, ?, ?> quest) {
        this.town.getUnsafe().m_6596_();
        String completionMessage = quest.getCompletionMessage();
        if (completionMessage == null || completionMessage.isBlank()) {
            return;
        }
        this.town.getUnsafe().messages.broadcastMessage(completionMessage, new Object[0]);
    }

    public ImmutableList<Quest<ResourceLocation, MCRoom>> getAll() {
        return ImmutableList.copyOf(this.questBatches.getAll().stream().map(v -> v).toList());
    }

    public ImmutableMap<Quest<ResourceLocation, MCRoom>, MCReward> getAllWithRewards() {
        ImmutableMap.Builder b = ImmutableMap.builder();
        this.questBatches.getAllWithRewards().forEach(arg_0 -> ((ImmutableMap.Builder)b).put(arg_0));
        return b.build();
    }

    public Collection<MCQuest> getAllForVillager(VillagerUUID uuid) {
        return this.questBatches.getAllBatches().stream().filter(b -> uuid.equals(b.getOwner())).flatMap(v -> v.getAll().stream()).toList();
    }

    public List<AbstractMap.SimpleEntry<MCQuest, MCReward>> getAllForVillagerWithRewards(UUID uuid) {
        return this.questBatches.getAllForVillagerWithRewards(uuid);
    }

    public void addBatch(MCQuestBatch batch) {
        this.questBatches.add(batch);
    }

    public Collection<MCQuestBatch> getBatches() {
        return this.questBatches.getAllBatches();
    }

    public boolean canBeUpgraded(ResourceLocation fromRecipeID, ResourceLocation toRecipeID) {
        ImmutableList<Quest<ResourceLocation, MCRoom>> all = this.getAll();
        return all.stream().filter(Predicates.not(Quest::isComplete)).anyMatch(TownQuests.matchesToUpgrade(fromRecipeID, toRecipeID));
    }

    @NotNull
    private static Predicate<Quest<ResourceLocation, MCRoom>> matchesToUpgrade(ResourceLocation from, ResourceLocation to) {
        return v -> ((ResourceLocation)v.getWantedId()).equals((Object)to) && v.fromRecipeID().map(z -> z.equals((Object)from)).orElse(false) != false;
    }

    public void changeRoomOnly(MCRoom oldRoom, MCRoom newRoom) {
        this.questBatches.changeRoomOnly(oldRoom, newRoom);
    }

    public boolean alreadyRequested(ResourceLocation resourceLocation) {
        return this.getAll().stream().map(Quest::getWantedId).anyMatch(v -> v.equals((Object)resourceLocation));
    }

    public void roomRecipeCreated(MCRoom room, RoomRecipeMatch<MCRoom> match) {
        ServerLevel l = this.town.getServerLevelUnsafe();
        Matches.runForTopMatch(this::recipesFromLevel, match, r -> this.markQuestAsComplete(room, (ResourceLocation)r));
    }

    private Map<ResourceLocation, RoomRecipe> recipesFromLevel() {
        return RoomRecipes.hydrate(this.town.getServerLevelUnsafe().m_7465_(), true);
    }

    public void roomRecipeChanged(MCRoom oldRoom, RoomRecipeMatch<MCRoom> oldMatch, MCRoom newRoom, RoomRecipeMatch<MCRoom> newMatch) {
        Optional<ResourceLocation> oldMatchID = Matches.getTopMatch(this::recipesFromLevel, oldMatch);
        Optional<ResourceLocation> newMatchID = Matches.getTopMatch(this::recipesFromLevel, newMatch);
        if (oldMatchID.isEmpty() && newMatchID.isPresent()) {
            this.markQuestAsComplete(newRoom, newMatchID.get());
            return;
        }
        if (oldMatchID.equals(newMatchID) && !oldRoom.equals((Object)newRoom)) {
            this.changeRoomOnly(oldRoom, newRoom);
        }
        if (!oldMatchID.equals(newMatchID) && oldMatchID.isPresent() && newMatchID.isPresent()) {
            if (this.canBeUpgraded(oldMatchID.get(), newMatchID.get())) {
                this.markAsConverted(newRoom, oldMatchID.get(), newMatchID.get());
            } else {
                this.markQuestAsLost(oldRoom, oldMatchID.get());
                this.markQuestAsComplete(newRoom, newMatchID.get());
            }
        }
    }

    public void roomRecipeDestroyed(MCRoom room, RoomRecipeMatch<MCRoom> oldMatch) {
        Matches.runForTopMatch(this::recipesFromLevel, oldMatch, rl -> this.markQuestAsLost(room, (ResourceLocation)rl));
    }

    public void initialize(TownFlagBlockEntity t) {
        this.town.initialize(t);
    }

    public void processItemQuests(ImmutableList<MCTownItem> allStacks) {
        this.questBatches.processItemQuests(allStacks, this::questMatchesStack, TRACKER);
    }

    private boolean questMatchesStack(ResourceLocation wantedId, MCTownItem stack) {
        return wantedId.equals((Object)Compat.getItemId(stack.get()));
    }
}

