/*
 * Decompiled with CFR 0.152.
 */
package ca.bradj.questown.town;

import ca.bradj.questown.QT;
import ca.bradj.questown.core.VillagerUUID;
import ca.bradj.questown.core.advancements.RoomTrigger;
import ca.bradj.questown.core.init.AdvancementsInit;
import ca.bradj.questown.gui.FlagMenus;
import ca.bradj.questown.gui.TownQuestsContainer;
import ca.bradj.questown.gui.TownRemoveQuestsContainer;
import ca.bradj.questown.gui.UIQuest;
import ca.bradj.questown.mc.Compat;
import ca.bradj.questown.town.TownFlagBlockEntity;
import ca.bradj.questown.town.TownQuests;
import ca.bradj.questown.town.UnsafeTown;
import ca.bradj.questown.town.interfaces.QuestsHolder;
import ca.bradj.questown.town.quests.MCQuest;
import ca.bradj.questown.town.quests.MCQuestBatch;
import ca.bradj.questown.town.quests.MCReward;
import ca.bradj.questown.town.rewards.AddBatchOfRandomQuestsForVisitorReward;
import ca.bradj.questown.town.rewards.AddRandomUpgradeQuest;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.util.AbstractMap;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TownQuestsHandle
implements QuestsHolder {
    private UnsafeTown town = new UnsafeTown(TownQuestsHandle.class);

    public void initialize(TownFlagBlockEntity t) {
        this.town.initialize(t);
    }

    @NotNull
    private TownFlagBlockEntity unsafeGetTown() {
        return this.town.getUnsafe();
    }

    @Override
    public void requestRemovalOfQuestAtIndex(UUID batchID, ServerPlayer sender, boolean promptUser) {
        if (promptUser) {
            Optional<MCQuestBatch> first = this.unsafeGetTown().quests.questBatches.getAllBatches().stream().filter(v -> batchID.equals(v.getBatchUUID())).findFirst();
            if (first.isEmpty()) {
                QT.QUESTS_LOGGER.error("Received request to remove non-existent batch. Doing nothing. [{}]", (Object)batchID);
                return;
            }
            this.showConfirmUI(sender, first.get());
        } else {
            this.doRemove(batchID, sender);
        }
    }

    @Override
    public void showQuestsUI(final ServerPlayer player) {
        final @NotNull TownFlagBlockEntity t = this.unsafeGetTown();
        ImmutableList<AbstractMap.SimpleEntry<MCQuest, MCReward>> aQ = this.unsafeGetTown().getAllQuestsWithRewards();
        final List<UIQuest> quests = UIQuest.fromLevel((Level)t.getServerLevel(), aQ);
        Collection<LivingEntity> entities = t.getVillagerHandle().entities();
        Compat.openScreen(player, new MenuProvider(){

            @NotNull
            public Component m_5446_() {
                return Compat.literal("");
            }

            @NotNull
            public AbstractContainerMenu m_7208_(int windowId, @NotNull Inventory inv, @NotNull Player p) {
                return new TownQuestsContainer(windowId, quests, t.getInfo(), () -> this.triggerAdvancement(player, t));
            }

            private void triggerAdvancement(ServerPlayer player2, @NotNull TownFlagBlockEntity t2) {
                if (t2.getVillagerHandle().entities().isEmpty()) {
                    return;
                }
                AdvancementsInit.ROOM_TRIGGER.triggerForNearestPlayer(player2.m_9236_(), RoomTrigger.Triggers.FirstOpenFlagMenu, t2.m_58899_());
            }
        }, data -> FlagMenus.writeAndLink(data, quests, t.getInfo(), player, entities, t.bopCount));
    }

    @Override
    public List<AbstractMap.SimpleEntry<MCQuest, MCReward>> getQuestsWithRewardsForVillager(UUID uuid) {
        return this.unsafeGetTown().quests.getAllForVillagerWithRewards(uuid);
    }

    @Override
    public ImmutableSet<UUID> getVillagersWithQuests() {
        return TownQuests.getVillagers(this.unsafeGetTown().quests);
    }

    @Override
    public Collection<MCQuest> getQuestsForVillager(UUID uuid) {
        return this.unsafeGetTown().quests.getAllForVillager(VillagerUUID.from(uuid));
    }

    @Override
    public void addBatchOfRandomQuestsForVisitor(@Nullable VillagerUUID visitorUUID) {
        TownFlagBlockEntity t = this.unsafeGetTown();
        TownQuests.addRandomBatchForVisitor(t, t.quests, visitorUUID);
        t.m_6596_();
    }

    @Override
    public void addRandomUpgradeQuestForVisitor(UUID visitorUUID) {
        TownFlagBlockEntity t = this.unsafeGetTown();
        TownQuests.addUpgradeQuest(t, t.quests, VillagerUUID.from(visitorUUID));
        t.m_6596_();
    }

    @Override
    public void addItemQuest(ResourceLocation itemId, int count) {
        TownFlagBlockEntity t = this.unsafeGetTown();
        TownQuests.addItemQuest(t, t.quests, itemId, count);
    }

    @Override
    public Collection<MCQuestBatch> getAllBatchesForVillager(UUID uuid) {
        @NotNull TownFlagBlockEntity t = this.unsafeGetTown();
        return t.quests.getBatches().stream().filter(v -> uuid.equals(v.getOwner())).toList();
    }

    private void showConfirmUI(ServerPlayer sp, final MCQuestBatch batch) {
        final TownFlagBlockEntity t = this.unsafeGetTown();
        final List<UIQuest> quests = UIQuest.fromLevel(sp.m_9236_(), batch);
        Compat.openScreen(sp, new MenuProvider(){

            @NotNull
            public Component m_5446_() {
                return Compat.literal("");
            }

            @NotNull
            public AbstractContainerMenu m_7208_(int windowId, @NotNull Inventory inv, @NotNull Player p) {
                return new TownRemoveQuestsContainer(windowId, quests, t.getTownFlagBasePos(), batch.getBatchUUID());
            }
        }, data -> TownRemoveQuestsContainer.write(data, quests, t.getTownFlagBasePos(), batch.getBatchUUID()));
    }

    private void doRemove(UUID batchID, ServerPlayer sender) {
        @NotNull TownFlagBlockEntity t = this.unsafeGetTown();
        for (MCQuestBatch b : t.quests.getBatches()) {
            if (!batchID.equals(b.getBatchUUID())) continue;
            if (t.quests.questBatches.decline(b)) {
                t.quests.playerDiscardedLastBatch = true;
                QT.QUESTS_LOGGER.debug("Quest batch removed: {}", (Object)b);
                this.addReplacementQuestBatch(t, b);
                t.m_6596_();
                if (!t.getAllQuests().isEmpty()) {
                    this.showQuestsUI(sender);
                } else {
                    sender.m_6915_();
                }
                t.messages.batchRemoved();
            }
            return;
        }
    }

    private void addReplacementQuestBatch(@NotNull TownFlagBlockEntity t, MCQuestBatch b) {
        if (Compat.getRandomBool(t.getServerLevel())) {
            t.addMorningReward(new AddBatchOfRandomQuestsForVisitorReward(t, null));
            return;
        }
        if (b.getOwner() != null) {
            t.addMorningReward(new AddRandomUpgradeQuest(t, VillagerUUID.get(b.getOwner())));
            return;
        }
        QT.QUESTS_LOGGER.error("Quest batch owner was null, assigning next batch to someone else.");
        UUID owner = t.getRandomVillager();
        if (owner != null) {
            t.addMorningReward(new AddRandomUpgradeQuest(t, owner));
            return;
        }
        QT.QUESTS_LOGGER.error("No villagers to assign next upgrade quest batch to, falling back to randdom");
        t.addMorningReward(new AddBatchOfRandomQuestsForVisitorReward(t, null));
    }

    @Override
    public ImmutableList<AbstractMap.SimpleEntry<MCQuest, MCReward>> getAllQuestsWithRewards() {
        return this.unsafeGetTown().getAllQuestsWithRewards();
    }
}

