/*
 * Decompiled with CFR 0.152.
 */
package ca.bradj.questown.town;

import ca.bradj.questown.QT;
import ca.bradj.questown.Questown;
import ca.bradj.questown.blocks.PlateBlock;
import ca.bradj.questown.blocks.RoomBlock;
import ca.bradj.questown.blocks.entity.BlockAsRoomEntity;
import ca.bradj.questown.core.Config;
import ca.bradj.questown.core.UtilClean;
import ca.bradj.questown.roomrecipes.Matches;
import ca.bradj.questown.roomrecipes.Spaces;
import ca.bradj.questown.town.TownFlagBlockEntity;
import ca.bradj.questown.town.UnsafeTown;
import ca.bradj.questown.town.WallDetection;
import ca.bradj.questown.town.interfaces.RoomsHolder;
import ca.bradj.questown.town.interfaces.TownInterface;
import ca.bradj.questown.town.rooms.MultiLevelRoomDetector;
import ca.bradj.questown.town.rooms.TownPosition;
import ca.bradj.questown.town.rooms.TownRoomsMap;
import ca.bradj.questown.town.special.SpecialQuests;
import ca.bradj.roomrecipes.adapter.Positions;
import ca.bradj.roomrecipes.adapter.RoomRecipeMatch;
import ca.bradj.roomrecipes.adapter.RoomRecipeMatches;
import ca.bradj.roomrecipes.core.space.Position;
import ca.bradj.roomrecipes.logic.LevelRoomDetector;
import ca.bradj.roomrecipes.recipes.ActiveRecipes;
import ca.bradj.roomrecipes.recipes.RecipeDetection;
import ca.bradj.roomrecipes.serialization.MCRoom;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Stream;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BedBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TownRoomsHandle
implements RoomsHolder,
Supplier<TownFlagBlockEntity> {
    private final TownRoomsMap roomsMap = new TownRoomsMap();
    private final UnsafeTown town = new UnsafeTown(TownRoomsHandle.class);
    @Nullable
    private MCRoom flagMetaRoom;
    private final Map<ResourceLocation, List<BlockPos>> roomBlocks = new HashMap<ResourceLocation, List<BlockPos>>();

    public void initializeNew(TownFlagBlockEntity t) {
        this.town.initialize(t);
        this.flagMetaRoom = Spaces.metaRoomAround(t.m_58899_(), 2);
        this.roomsMap.initializeNew(t);
        this.roomsMap.addRecipeListener(t.quests);
        this.roomsMap.addRecipeListener(t);
    }

    @Override
    public Collection<RoomRecipeMatch<MCRoom>> getRoomsMatching(ResourceLocation recipeId) {
        @NotNull TownFlagBlockEntity t = this.town.getUnsafe();
        Optional<ResourceLocation> blockRoom = BlockAsRoomEntity.ALL.stream().map(Supplier::get).map(RoomBlock::getRoomId).filter(arg_0 -> ((ResourceLocation)recipeId).equals(arg_0)).findFirst();
        if (blockRoom.isPresent()) {
            return this.getBlockMetaRooms(t, blockRoom.get());
        }
        if (SpecialQuests.TOWN_GATE.equals((Object)recipeId)) {
            return this.getWelcomeMatMetaRooms(t);
        }
        if (SpecialQuests.TOWN_FLAG.equals((Object)recipeId)) {
            return ImmutableList.of(this.getFlagMetaRoom(t));
        }
        if (SpecialQuests.FARM.equals((Object)recipeId)) {
            return this.roomsMap.getFarms().stream().map(v -> {
                Function<BlockPos, BlockState> getBs = bp -> TownRoomsHandle.getServerLevel(this.town.getUnsafe()).m_8055_(bp);
                ImmutableMap b = RecipeDetection.getBlocksInRoomV2(bp -> ((BlockState)getBs.apply((BlockPos)bp)).m_60734_(), (MCRoom)new MCRoom(v.getDoorPos(), (Collection)v.getSpaces(), v.yCoord), (boolean)false);
                return new RoomRecipeMatch(v, ImmutableList.of((Object)recipeId), (Iterable)b.entrySet());
            }).toList();
        }
        return this.roomsMap.getRoomsMatching(recipeId);
    }

    @Override
    public void registerBlockAsRoom(ResourceLocation blockId, BlockPos clickedPos) {
        UtilClean.addOrInitialize(this.roomBlocks, blockId, clickedPos, ArrayList::new);
        QT.FLAG_LOGGER.debug("Registered block-room at {}: {}", (Object)clickedPos, (Object)blockId);
        TownFlagBlockEntity t = this.town.getUnsafe();
        t.subBlocks.register(clickedPos);
        MCRoom room = Spaces.metaRoomAround(clickedPos, (Integer)Config.META_ROOM_DIAMETER.get());
        ImmutableMap blocks = RecipeDetection.getBlocksInRoom((Level)this.town.getServerLevelUnsafe(), (MCRoom)room, (boolean)false);
        t.roomRecipeCreated(room, (RoomRecipeMatch<MCRoom>)new RoomRecipeMatches((Object)room, ImmutableList.of((Object)blockId), blocks.entrySet()));
        t.m_6596_();
    }

    private Collection<RoomRecipeMatch<MCRoom>> getBlockMetaRooms(@NotNull TownFlagBlockEntity t, @Nullable ResourceLocation resourceLocation) {
        ImmutableList.Builder b = ImmutableList.builder();
        Stream<Object> e = this.roomBlocks.entrySet().stream();
        if (resourceLocation != null) {
            List<BlockPos> blocksInRoom = UtilClean.getOrDefault(this.roomBlocks, resourceLocation, ImmutableList.of());
            e = blocksInRoom.stream().map(pos -> Map.entry(resourceLocation, ImmutableList.of((Object)pos)));
        }
        e.forEach(ee -> {
            for (BlockPos p : (List)ee.getValue()) {
                MCRoom mcRoom = Spaces.metaRoomAround(p, (Integer)Config.META_ROOM_DIAMETER.get());
                ImmutableMap blocksInRoom = RecipeDetection.getBlocksInRoom((Level)TownRoomsHandle.getServerLevel(t), (MCRoom)mcRoom, (boolean)false);
                b.add((Object)new RoomRecipeMatch((Object)mcRoom, ImmutableList.of((Object)((ResourceLocation)ee.getKey())), (Iterable)blocksInRoom.entrySet()));
            }
        });
        return b.build();
    }

    private RoomRecipeMatch<MCRoom> getFlagMetaRoom(TownFlagBlockEntity t) {
        MCRoom mcRoom = Spaces.metaRoomAround(t.getTownFlagBasePos(), (Integer)Config.META_ROOM_DIAMETER.get());
        ImmutableMap blocksInRoom = RecipeDetection.getBlocksInRoom((Level)TownRoomsHandle.getServerLevel(t), (MCRoom)mcRoom, (boolean)false);
        ResourceLocation questId = SpecialQuests.TOWN_FLAG;
        return new RoomRecipeMatch((Object)mcRoom, ImmutableList.of((Object)questId), (Iterable)blocksInRoom.entrySet());
    }

    @NotNull
    private static ServerLevel getServerLevel(TownFlagBlockEntity t) {
        return t.getServerLevel();
    }

    @NotNull
    private List<RoomRecipeMatch<MCRoom>> getWelcomeMatMetaRooms(@NotNull TownFlagBlockEntity t) {
        Function<MCRoom, ImmutableMap> fn = room -> RecipeDetection.getBlocksInRoom((Level)TownRoomsHandle.getServerLevel(t), (MCRoom)room, (boolean)false);
        return t.getWelcomeMats().stream().map(p -> Spaces.metaRoomAround(p, (Integer)Config.META_ROOM_DIAMETER.get())).map(v -> new RoomRecipeMatch(v, ImmutableList.of((Object)SpecialQuests.TOWN_GATE), (Iterable)((ImmutableMap)fn.apply((MCRoom)v)).entrySet())).toList();
    }

    @Override
    public TownFlagBlockEntity get() {
        return this.town.getUnsafe();
    }

    public TownRoomsMap getRegisteredRooms() {
        return this.roomsMap;
    }

    void tick(ServerLevel sl, BlockPos flagPos) {
        this.roomsMap.tick(sl, flagPos);
    }

    public ImmutableList<MCRoom> getAllRoomsIncludingMetaAndFarms() {
        ImmutableList.Builder b = ImmutableList.builder();
        b.addAll(this.roomsMap.getAllRooms());
        b.addAll(this.roomsMap.getFarms());
        assert (this.flagMetaRoom != null);
        b.add((Object)this.flagMetaRoom);
        @NotNull TownFlagBlockEntity t = this.town.getUnsafe();
        this.getWelcomeMatMetaRooms(t).forEach(v -> b.add((Object)((MCRoom)v.room)));
        this.getBlockMetaRooms(t, null).forEach(v -> b.add((Object)((MCRoom)v.room)));
        return b.build();
    }

    @Override
    public Collection<MCRoom> getFarms() {
        return this.roomsMap.getFarms();
    }

    @Override
    public Collection<BlockPos> findMatchedRecipeBlocks(TownInterface.MatchRecipe mr) {
        ImmutableList.Builder b = ImmutableList.builder();
        for (RoomRecipeMatch<MCRoom> i : this.roomsMap.getAllMatches(x -> true)) {
            for (Map.Entry j : i.getContainedBlocks().entrySet()) {
                if (!mr.doesMatch((Block)j.getValue())) continue;
                b.add((Object)((BlockPos)j.getKey()));
            }
        }
        return b.build();
    }

    boolean hasEnoughBeds(long numVillagers) {
        long beds = this.roomsMap.getAllMatches(v -> true).stream().flatMap(v -> v.getContainedBlocks().values().stream()).filter(v -> Ingredient.m_204132_((TagKey)ItemTags.f_13146_).test(new ItemStack((ItemLike)v.m_5456_()))).count();
        if (beds == 0L && numVillagers == 0L) {
            return false;
        }
        return beds / 2L >= numVillagers;
    }

    @Override
    public Collection<RoomRecipeMatch<MCRoom>> getMatches(Predicate<RoomRecipeMatch<MCRoom>> include) {
        return this.roomsMap.getAllMatches(include);
    }

    @Override
    public void registerDoor(BlockPos clickedPos) {
        @NotNull TownFlagBlockEntity t = this.town.getUnsafe();
        this.roomsMap.registerDoor(Positions.FromBlockPos((BlockPos)clickedPos), clickedPos.m_123342_() - t.getY());
        t.m_6596_();
    }

    @Override
    public void deregisterDoor(RoomsHolder.Deregistration d) {
        @NotNull TownFlagBlockEntity t = this.town.getUnsafe();
        Position doorPos = Positions.FromBlockPos((BlockPos)d.doorPos());
        this.roomsMap.deRegisterDoor(doorPos, d.doorPos().m_123342_() - t.getY(), d.reason());
        t.m_6596_();
    }

    @Override
    public Supplier<Boolean> getDebugTaskForAllDoors() {
        @NotNull TownFlagBlockEntity t = this.town.getUnsafe();
        ImmutableSet<TownPosition> registeredDoors = t.getRoomHandle().getAllRegisteredDoors();
        HashMap<Integer, Collection<Position>> doorsAtLevel = new HashMap<Integer, Collection<Position>>();
        registeredDoors.forEach(dp -> doorsAtLevel.computeIfAbsent(dp.scanLevel, k -> new ArrayList()).add(dp.toPosition()));
        HashMap<Integer, ActiveRecipes<MCRoom, RoomRecipeMatch<MCRoom>>> recipesAtLevel = new HashMap<Integer, ActiveRecipes<MCRoom, RoomRecipeMatch<MCRoom>>>();
        doorsAtLevel.keySet().forEach(scanLevel -> {
            ActiveRecipes value = new ActiveRecipes();
            value.addChangeListener((ActiveRecipes.ChangeListener)new ActiveRecipes.ChangeListener<MCRoom, RoomRecipeMatch<MCRoom>>(){

                public void roomRecipeCreated(MCRoom room, RoomRecipeMatch<MCRoom> mcRoomRoomRecipeMatch) {
                }

                public void roomRecipeChanged(MCRoom room, RoomRecipeMatch<MCRoom> mcRoomRoomRecipeMatch, MCRoom room1, RoomRecipeMatch<MCRoom> key1) {
                }

                public void roomRecipeDestroyed(MCRoom room, RoomRecipeMatch<MCRoom> mcRoomRoomRecipeMatch) {
                }
            });
            recipesAtLevel.put((Integer)scanLevel, (ActiveRecipes<MCRoom, RoomRecipeMatch<MCRoom>>)value);
        });
        HashMap artSink = new HashMap();
        MultiLevelRoomDetector ptr = TownRoomsHandle.initMLRD(t, recipesAtLevel, doorsAtLevel);
        ptr.setArtSink(artSink::put);
        return () -> {
            boolean done = ptr.proceed(i -> null);
            if (!done) {
                return false;
            }
            HashMap<TownPosition, Result> results = new HashMap<TownPosition, Result>();
            artSink.forEach((scanLevel, arts) -> {
                arts.forEach((k, v) -> results.compute(new TownPosition(k.x, k.z, (int)scanLevel), (pos, cur) -> cur == null ? new Result((String)v, "NONE", "NONE") : new Result((String)v, cur.recipe, cur.room)));
                ((ActiveRecipes)recipesAtLevel.get(scanLevel)).entrySet().forEach(k -> results.compute(new TownPosition(((MCRoom)k.getKey()).doorPos.x, ((MCRoom)k.getKey()).doorPos.z, (int)scanLevel), (pos, cur) -> {
                    String rec = Matches.toString((RoomRecipeMatch<MCRoom>)((RoomRecipeMatch)k.getValue()));
                    String rom = ((MCRoom)((RoomRecipeMatch)k.getValue()).room).getSpace().toString();
                    return cur == null ? new Result("NONE", rom, rec) : new Result(cur.debugArt, rom, rec);
                }));
            });
            results.forEach((k, v) -> QT.FLAG_LOGGER.debug("At {} found recipe {} in room {} after scan:\n{}", (Object)k.toPosition().getUIString(), (Object)v.recipe, (Object)v.room, (Object)v.debugArt));
            return true;
        };
    }

    public void handleMorning() {
        this.resetDiningRooms();
        this.resetBedrooms();
    }

    private void resetDiningRooms() {
        Collection<RoomRecipeMatch<MCRoom>> diningRooms = this.getMatches(m -> m.anyMatch(Questown.ResourceLocation("dining_room")));
        for (RoomRecipeMatch<MCRoom> diningRoom : diningRooms) {
            for (Map.Entry e : diningRoom.getContainedBlocks().entrySet()) {
                if (!(e.getValue() instanceof PlateBlock)) continue;
                QT.FLAG_LOGGER.debug("Resetting plate claim and state at {}", e.getKey());
                this.town.getUnsafe().jobHandle.clearClaim((BlockPos)e.getKey());
                this.town.getUnsafe().jobHandle.clearState((BlockPos)e.getKey());
            }
        }
    }

    private void resetBedrooms() {
        Collection<RoomRecipeMatch<MCRoom>> rooms = this.getMatches(m -> m.anyMatch(Questown.ResourceLocation("bedroom")));
        for (RoomRecipeMatch<MCRoom> room : rooms) {
            for (Map.Entry e : room.getContainedBlocks().entrySet()) {
                Object v = e.getValue();
                if (!(v instanceof BedBlock)) continue;
                BedBlock bb = (BedBlock)v;
                ServerLevel sl = this.town.getServerLevelUnsafe();
                BlockState oldBs = sl.m_8055_((BlockPos)e.getKey());
                BlockState newBs = (BlockState)oldBs.m_61124_((Property)BedBlock.f_49441_, (Comparable)Boolean.valueOf(false));
                List list = sl.m_6443_(LivingEntity.class, new AABB((BlockPos)e.getKey()), LivingEntity::m_5803_);
                sl.m_46597_((BlockPos)e.getKey(), newBs);
                for (LivingEntity villager : list) {
                    villager.m_5796_();
                }
            }
        }
    }

    public ImmutableList<BlockPos> blockRooms() {
        return (ImmutableList)this.roomBlocks.values().stream().flatMap(Collection::stream).collect(ImmutableList.toImmutableList());
    }

    @NotNull
    private static MultiLevelRoomDetector initMLRD(@NotNull TownFlagBlockEntity t, Map<Integer, ActiveRecipes<MCRoom, RoomRecipeMatch<MCRoom>>> recipesAtLevel, Map<Integer, Collection<Position>> doorsAtLevel) {
        int townY = t.m_58899_().m_123342_();
        return new MultiLevelRoomDetector(TownRoomsHandle.getServerLevel(t), t.getY(), p -> WallDetection.IsWall(TownRoomsHandle.getServerLevel(t), p.toPosition(), townY + p.scanLevel), p -> WallDetection.IsDoor(TownRoomsHandle.getServerLevel(t), p.toPosition(), townY + p.scanLevel), (scanLevel, newRooms) -> {}, recipesAtLevel::get, doorsAtLevel, true);
    }

    @Override
    public Supplier<Boolean> getDebugTaskForDoor(BlockPos clickedPos) {
        @NotNull TownFlagBlockEntity t = this.town.getUnsafe();
        LinkedBlockingQueue flightRecorder = new LinkedBlockingQueue();
        Position clickedRRPos = Positions.FromBlockPos((BlockPos)clickedPos);
        LevelRoomDetector d = new LevelRoomDetector((Collection)ImmutableList.of((Object)clickedRRPos), ((Integer)Config.MAX_ROOM_DIMENSION.get()).intValue(), ((Integer)Config.MAX_ROOM_SCAN_ITERATIONS.get()).intValue(), p -> WallDetection.IsWall(TownRoomsHandle.getServerLevel(t), p, clickedPos.m_123342_()), true, flightRecorder::add);
        return () -> {
            @Nullable ImmutableMap done = d.proceed();
            if (done == null) {
                return false;
            }
            flightRecorder.forEach(arg_0 -> ((Logger)QT.FLAG_LOGGER).debug(arg_0));
            d.getDebugArt(true).forEach((k, v) -> QT.FLAG_LOGGER.debug("Art for {}\n{}", (Object)k.getUIString(), v));
            Optional room = (Optional)UtilClean.getOrDefault(done, clickedRRPos, Optional.empty());
            QT.FLAG_LOGGER.debug("Room is {}", (Object)room);
            room.ifPresent(r -> {
                Optional<RoomRecipeMatches<MCRoom>> recipe = t.getRoomHandle().computeRecipe(new MCRoom(r.getDoorPos(), (Collection)r.getSpaces(), clickedPos.m_123342_()));
                QT.FLAG_LOGGER.debug("Recipe is {}", recipe);
            });
            if (!t.getRoomHandle().isDoorRegistered(clickedPos)) {
                QT.FLAG_LOGGER.warn("{} is not registered as a door", (Object)clickedPos);
            }
            return true;
        };
    }

    @Override
    public boolean isDoorRegistered(BlockPos clickedPos) {
        @NotNull TownFlagBlockEntity t = this.town.getUnsafe();
        return this.roomsMap.isDoorRegistered(Positions.FromBlockPos((BlockPos)clickedPos), clickedPos.m_123342_() - t.getY());
    }

    @Override
    public Optional<RoomRecipeMatches<MCRoom>> computeRecipe(MCRoom r) {
        @NotNull TownFlagBlockEntity t = this.town.getUnsafe();
        return this.roomsMap.computeRecipe(TownRoomsHandle.getServerLevel(t), r);
    }

    @Override
    public ImmutableSet<TownPosition> getAllRegisteredDoors() {
        return this.roomsMap.getAllRegisteredDoors();
    }

    @Override
    public void registerFenceGate(BlockPos clickedPos) {
        @NotNull TownFlagBlockEntity t = this.town.getUnsafe();
        this.roomsMap.registerFenceGate(Positions.FromBlockPos((BlockPos)clickedPos), clickedPos.m_123342_() - t.getY());
        t.m_6596_();
    }

    private record Result(String debugArt, String room, String recipe) {
    }
}

