/*
 * Decompiled with CFR 0.152.
 */
package ca.bradj.questown.town;

import ca.bradj.questown.blocks.HospitalBedBlock;
import ca.bradj.questown.town.TownFlagBlockEntity;
import ca.bradj.questown.town.VillagerBedsHandle;
import ca.bradj.questown.town.interfaces.RoomsHolder;
import ca.bradj.questown.town.interfaces.TownInterface;
import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.GlobalPos;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.block.BedBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BedPart;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;

public class TownVillagerBedsHandle {
    private final VillagerBedsHandle<BlockPos, LivingEntity, TownInterface> delegate = new VillagerBedsHandle<BlockPos, LivingEntity, TownInterface>(TownVillagerBedsHandle::getAllBedHeads, TownVillagerBedsHandle::getHealingFactor, TownVillagerBedsHandle::getDamageTicksLeft, TownVillagerBedsHandle::getDistance, v -> v.m_20148_().toString());

    private static double getDistance(LivingEntity e, BlockPos pos) {
        return e.m_20238_(Vec3.m_82512_((Vec3i)pos));
    }

    private static Integer getDamageTicksLeft(TownInterface townInterface, LivingEntity uuid) {
        return townInterface.getVillagerHandle().getDamageTicksLeft(uuid.m_20148_());
    }

    private static Double getHealingFactor(TownInterface townInterface, BlockPos pos) {
        return townInterface.getHealHandle().getHealFactor(pos);
    }

    private static Collection<BlockPos> getAllBedHeads(@NotNull TownInterface town) {
        RoomsHolder rooms = town.getRoomHandle();
        Collection<BlockPos> beds = rooms.findMatchedRecipeBlocks(i -> i instanceof BedBlock || i instanceof HospitalBedBlock);
        return beds.stream().filter(bp -> TownVillagerBedsHandle.isHead(town, bp)).toList();
    }

    private static boolean isHead(TownInterface town, BlockPos i) {
        BlockState blockState = town.getServerLevel().m_8055_(i);
        if (blockState.m_60795_()) {
            return false;
        }
        if (!blockState.m_61138_((Property)BlockStateProperties.f_61391_)) {
            return false;
        }
        BedPart value = (BedPart)blockState.m_61143_((Property)BlockStateProperties.f_61391_);
        return BedPart.HEAD.equals((Object)value);
    }

    public void tick(TownFlagBlockEntity town, ImmutableList<LivingEntity> entities) {
        this.delegate.tick(town, (Collection<LivingEntity>)entities);
    }

    public void claim(LivingEntity uuid, TownFlagBlockEntity town) {
        this.delegate.claim(uuid, town);
    }

    public Optional<GlobalPos> getBestBed(TownInterface town, LivingEntity ent) {
        BlockPos bestBed = this.delegate.getBestBed(ent);
        if (bestBed == null) {
            return Optional.empty();
        }
        return Optional.of(GlobalPos.m_122643_((ResourceKey)town.getServerLevel().m_46472_(), (BlockPos)bestBed));
    }
}

