/*
 * Decompiled with CFR 0.152.
 */
package ca.bradj.questown.town;

import ca.bradj.questown.jobs.JobID;
import ca.bradj.questown.town.Effect;
import ca.bradj.questown.town.TownVillagerHandle;
import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.function.BiConsumer;
import java.util.function.Function;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;

public class TownVillagerHandlerSerializer {
    private static final String NBT_FULLNESS = "fullness";
    private static final String NBT_EXP = "experience";
    private static final String NBT_LEVELS = "level";
    private static final String NBT_MOOD = "mood";
    private static final String NBT_MOOD_EFFECTS = "mood_effects";
    private static final String NBT_VILLAGER_ID = "villager_uuid";
    private static final String NBT_UNLOCKED_JOBS = "unlocked_jobs";
    private static final String NBT_JOBS_KNOWN_TO_EXIST = "jobs_known_to_exist";
    private static final String NBT_JOB_ID = "job_id";
    private static final String NBT_VALUE = "value";
    private static final String NBT_DURATION = "duration";
    private static final String NBT_DAMAGE = "damage";

    public void deserialize(CompoundTag compound, TownVillagerHandle villagerHandle, long currentTick) {
        Function<Tag, Integer> simpleInt = t -> ((CompoundTag)t).m_128451_(NBT_VALUE);
        ImmutableMap<UUID, Integer> fullness = this.deserializeMap(compound, NBT_FULLNESS, simpleInt);
        ImmutableMap<UUID, ImmutableList> moodEffects = this.deserializeMap(compound, NBT_MOOD_EFFECTS, t -> {
            ListTag effects = ((CompoundTag)t).m_128437_(NBT_MOOD_EFFECTS, 10);
            ImmutableList.Builder b2 = ImmutableList.builder();
            effects.forEach(meTag -> b2.add((Object)new Effect(new ResourceLocation(((CompoundTag)meTag).m_128461_(NBT_VALUE)), currentTick + ((CompoundTag)meTag).m_128454_(NBT_DURATION))));
            return b2.build();
        });
        ImmutableMap<UUID, Integer> damage = this.deserializeMap(compound, NBT_DAMAGE, simpleInt);
        ImmutableMap<UUID, ImmutableList> unlockedJobs = this.deserializeMap(compound, NBT_UNLOCKED_JOBS, t -> {
            ListTag jobs = ((CompoundTag)t).m_128437_(NBT_VALUE, 10);
            List<JobID> list = jobs.stream().map(v -> JobID.fromTag((CompoundTag)v)).toList();
            return ImmutableList.copyOf(list);
        });
        ImmutableMap<UUID, ImmutableMap> knownJobs = this.deserializeMap(compound, NBT_VALUE, ttt -> {
            ImmutableMap.Builder bbb = ImmutableMap.builder();
            ListTag l = ((CompoundTag)ttt).m_128437_(NBT_VALUE, 10);
            l.forEach(tttt -> {
                CompoundTag jobId = ((CompoundTag)tttt).m_128469_(NBT_JOB_ID);
                ListTag jobz = ((CompoundTag)tttt).m_128437_(NBT_VALUE, 10);
                ImmutableList.Builder jb = ImmutableList.builder();
                jobz.forEach(j -> jb.add((Object)JobID.fromTag((CompoundTag)j)));
                bbb.put((Object)JobID.fromTag(jobId), (Object)jb.build());
            });
            return bbb.build();
        });
        ImmutableMap<UUID, Integer> experience = this.deserializeMap(compound, NBT_EXP, simpleInt);
        ImmutableMap<UUID, Integer> level = this.deserializeMap(compound, NBT_LEVELS, simpleInt);
        villagerHandle.initialize((Map<UUID, Integer>)fullness, (Map<UUID, ? extends ImmutableCollection<Effect>>)moodEffects, (Map<UUID, Integer>)damage, (Map<UUID, ? extends ImmutableCollection<JobID>>)unlockedJobs, (Map<UUID, ? extends Map<JobID, ? extends ImmutableCollection<JobID>>>)knownJobs, experience, level);
    }

    private <X> ImmutableMap<UUID, X> deserializeMap(CompoundTag compound, String tagId, Function<Tag, X> fn) {
        ImmutableMap.Builder mb = ImmutableMap.builder();
        ListTag fullnessPairs = compound.m_128437_(tagId, 10);
        fullnessPairs.forEach(tag -> {
            UUID uuid = ((CompoundTag)tag).m_128342_(NBT_VILLAGER_ID);
            mb.put((Object)uuid, fn.apply((Tag)tag));
        });
        return mb.build();
    }

    private <K, X> ImmutableMap<K, X> deserializeMap(CompoundTag compound, String tagId, Function<Tag, X> fn, Function<Tag, K> keyFn) {
        ImmutableMap.Builder mb = ImmutableMap.builder();
        ListTag fullnessPairs = compound.m_128437_(tagId, 10);
        fullnessPairs.forEach(tag -> {
            Object uuid = keyFn.apply((Tag)tag);
            mb.put(uuid, fn.apply((Tag)tag));
        });
        return mb.build();
    }

    public CompoundTag serialize(TownVillagerHandle villagerHandle, long currentTick) {
        BiConsumer<CompoundTag, Integer> simpleInt = (t, v) -> t.m_128405_(NBT_VALUE, v.intValue());
        CompoundTag compound = new CompoundTag();
        this.serializeMap(compound, NBT_FULLNESS, villagerHandle.fullness, simpleInt);
        this.serializeMap(compound, NBT_MOOD_EFFECTS, (Map)villagerHandle.moods.getEffects(), (BiConsumer)(t, v) -> {
            ListTag effectsList = new ListTag();
            v.forEach(effect -> {
                CompoundTag effectTag = new CompoundTag();
                effectTag.m_128359_(NBT_VALUE, effect.effect().toString());
                effectTag.m_128356_(NBT_DURATION, Math.max(effect.untilTick() - currentTick, 0L));
                effectsList.add((Object)effectTag);
            });
            t.m_128365_(NBT_MOOD_EFFECTS, (Tag)effectsList);
        });
        this.serializeMap(compound, NBT_DAMAGE, villagerHandle.damage, simpleInt);
        this.serializeMap(compound, NBT_EXP, villagerHandle.experience, simpleInt);
        this.serializeMap(compound, NBT_LEVELS, villagerHandle.levels, simpleInt);
        this.serializeMap(compound, NBT_UNLOCKED_JOBS, (Map)villagerHandle.getUnlockedJobs(), (BiConsumer)(t, j) -> t.m_128365_(NBT_VALUE, JobID.toTag(j)));
        BiConsumer<CompoundTag, Map> bc = (compoundTag, jobIDSetMap) -> {
            CompoundTag compound1 = new CompoundTag();
            this.serializeMap(compound1, NBT_VALUE, (Map)jobIDSetMap, this::serializeJobIdsValue, (t, k) -> t.m_128365_(NBT_JOB_ID, JobID.toTag(k)));
            compoundTag.m_128365_(NBT_VALUE, (Tag)compound1);
        };
        this.serializeMap(compound, NBT_JOBS_KNOWN_TO_EXIST, villagerHandle.learning.jobsKnownToExist, bc);
        return compound;
    }

    private void serializeJobIdsValue(CompoundTag compoundTag, Collection<JobID> jobIDS) {
        compoundTag.m_128365_(NBT_VALUE, JobID.toTag(jobIDS));
    }

    private <X> void serializeMap(CompoundTag compound, String id, Map<UUID, X> fullnessMap, BiConsumer<CompoundTag, ? super X> writer) {
        this.serializeMap(compound, id, fullnessMap, writer, (t, uuid) -> t.m_128362_(NBT_VILLAGER_ID, uuid));
    }

    private <K, X> void serializeMap(CompoundTag compound, String id, Map<K, X> fullnessMap, BiConsumer<CompoundTag, ? super X> writer, BiConsumer<CompoundTag, K> writeKey) {
        ListTag pairs = new ListTag();
        fullnessMap.forEach((uuid, value) -> {
            CompoundTag tag = new CompoundTag();
            writer.accept(tag, (Object)value);
            writeKey.accept(tag, uuid);
            pairs.add((Object)tag);
        });
        compound.m_128365_(id, (Tag)pairs);
    }
}

