/*
 * Decompiled with CFR 0.152.
 */
package ca.bradj.questown.town;

import ca.bradj.questown.QT;
import ca.bradj.questown.core.Config;
import ca.bradj.questown.core.Pair;
import ca.bradj.questown.core.UtilClean;
import ca.bradj.questown.jobs.JobID;
import ca.bradj.questown.jobs.Jobs;
import ca.bradj.questown.jobs.ServerJobsRegistry;
import ca.bradj.questown.mc.Compat;
import ca.bradj.questown.town.TownFlagBlockEntity;
import ca.bradj.questown.town.UnsafeTown;
import ca.bradj.questown.town.VillagerLearningHandle;
import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import net.minecraft.world.entity.LivingEntity;

public class TownVillagerLearningHandle {
    final Map<UUID, HashSet<JobID>> unlockedJobs = new HashMap<UUID, HashSet<JobID>>();
    final Map<UUID, Map<JobID, Set<JobID>>> jobsKnownToExist = new HashMap<UUID, Map<JobID, Set<JobID>>>();
    private final UnsafeTown town = new UnsafeTown(TownVillagerLearningHandle.class);
    private final VillagerLearningHandle<JobID> delegate = new VillagerLearningHandle<JobID>(ServerJobsRegistry::getAllJobs, v -> Compat.shuffle(v, this.town.getServerLevelUnsafe()), (p, c) -> ServerJobsRegistry.isParentOf(p, c), j -> true, (Integer)Config.JOB_TREE_GROWTH.get());
    private long lastTicked;
    private long lastComputed;

    public void associate(TownFlagBlockEntity t) {
        this.town.initialize(t);
    }

    public void tick(ImmutableList<LivingEntity> livingEntities, long currentTick) {
        this.lastTicked = currentTick;
        if (currentTick % 20L != 0L) {
            return;
        }
        this.lastComputed = currentTick;
        ImmutableSet<JobID> representativeJobs = ServerJobsRegistry.getAllJobs();
        boolean changed = this.delegate.tick((Collection<JobID>)representativeJobs);
        if (!changed) {
            return;
        }
        for (Map.Entry pc : this.delegate.getNextJobAwarenesses().entrySet()) {
            QT.FLAG_LOGGER.debug("Computed next awareness for {}: {}", (Object)((JobID)pc.getKey()).toNiceString(), (Object)Jobs.getNiceString((ImmutableList<JobID>)((ImmutableList)pc.getValue())));
        }
    }

    public void initialize(Map<UUID, ? extends ImmutableCollection<JobID>> unlockedJobs, Map<UUID, ? extends Map<JobID, ? extends ImmutableCollection<JobID>>> jobsKnownToExist) {
        for (Map.Entry<UUID, ? extends ImmutableCollection<JobID>> entry : unlockedJobs.entrySet()) {
            UtilClean.addAllOrInitialize(this.unlockedJobs, entry.getKey(), new HashSet((Collection)entry.getValue()), HashSet::new);
        }
        for (Map.Entry<UUID, Object> entry : jobsKnownToExist.entrySet()) {
            HashMap m = new HashMap();
            for (Map.Entry uj : ((Map)entry.getValue()).entrySet()) {
                m.put((JobID)uj.getKey(), new HashSet((Collection)uj.getValue()));
            }
            this.jobsKnownToExist.put(entry.getKey(), m);
        }
    }

    public ImmutableMap<UUID, ImmutableSet<JobID>> getUnlockedJobs() {
        return UtilClean.copyMapOfSets(this.unlockedJobs);
    }

    public ImmutableSet<JobID> getChildJobsKnownToExist(JobID parent) {
        ImmutableSet.Builder b = ImmutableSet.builder();
        for (Map.Entry<UUID, Map<JobID, Set<JobID>>> kjs : this.jobsKnownToExist.entrySet()) {
            Map<JobID, Set<JobID>> villagerKnown = kjs.getValue();
            ImmutableList<JobID> known = UtilClean.getOrDefaultCollectionByKeyPredicate(villagerKnown, parent::sameRoot, ImmutableList.of());
            b.addAll(known);
        }
        return b.build();
    }

    public ImmutableSet<JobID> getPrecomputedNextKnowledge(JobID parent) {
        return ImmutableSet.copyOf(this.delegate.getNextJobAwareness(parent));
    }

    public ImmutableMap<UUID, ImmutableMap<JobID, ImmutableSet<JobID>>> getChildJobsKnownToExist() {
        ImmutableMap.Builder b3 = ImmutableMap.builder();
        for (Map.Entry<UUID, Map<JobID, Set<JobID>>> kjs : this.jobsKnownToExist.entrySet()) {
            ImmutableSet.Builder b = ImmutableSet.builder();
            Map<JobID, Set<JobID>> villagerKnown = kjs.getValue();
            ImmutableMap.Builder b2 = ImmutableMap.builder();
            for (Map.Entry<JobID, Set<JobID>> eee : villagerKnown.entrySet()) {
                b2.put((Object)eee.getKey(), (Object)ImmutableSet.copyOf((Collection)eee.getValue()));
            }
            b3.put((Object)kjs.getKey(), (Object)b2.build());
        }
        return b3.build();
    }

    public void unlockJob(UUID villagerUUID, JobID id) {
        UtilClean.addOrInitialize(this.unlockedJobs, villagerUUID, id, HashSet::new);
    }

    public void registerAsKnown(UUID contributingVillager, JobID parentJob, Collection<JobID> jobsKnownToExist) {
        for (JobID jobID : jobsKnownToExist) {
            this.registerAsKnown(contributingVillager, parentJob, jobID);
        }
    }

    public void registerAsKnown(UUID contributingVillager, JobID parentJob, JobID jobsKnownToExist) {
        HashMap<JobID, Set<JobID>> villagerKnown = new HashMap<JobID, Set<JobID>>(UtilClean.getOrDefault(this.jobsKnownToExist, contributingVillager, ImmutableMap.of()));
        UtilClean.addOrInitialize(villagerKnown, parentJob, jobsKnownToExist, HashSet::new);
        this.jobsKnownToExist.put(contributingVillager, villagerKnown);
        QT.FLAG_LOGGER.debug("Registering as known: {}->{} via {}", (Object)parentJob.toNiceString(), (Object)jobsKnownToExist.toNiceString(), (Object)contributingVillager);
    }

    public void requestKnowledge(UUID uuid, ImmutableList<JobID> defaultWork) {
        ImmutableList.Builder b = ImmutableList.builder();
        for (JobID jobID : defaultWork) {
            Map<JobID, Set<JobID>> jk2e = UtilClean.getOrDefault(this.jobsKnownToExist, uuid, ImmutableMap.of());
            if (jk2e.containsKey(jobID)) continue;
            b.add((Object)jobID);
        }
        this.delegate.requestKnowledge((Collection<JobID>)b.build(), (ImmutableList<Pair<JOB_ID, JOB_ID>> knowledge) -> {
            for (Pair jobIDJobIDPair : knowledge) {
                this.registerAsKnown(uuid, (JobID)jobIDJobIDPair.a(), (JobID)jobIDJobIDPair.b());
            }
        });
    }

    public boolean isUnlocked(JobID jobID) {
        for (HashSet<JobID> value : this.unlockedJobs.values()) {
            for (JobID id : value) {
                if (!jobID.equals(id)) continue;
                return true;
            }
        }
        return false;
    }
}

