/*
 * Decompiled with CFR 0.152.
 */
package ca.bradj.questown.town;

import ca.bradj.questown.QT;
import ca.bradj.questown.core.Config;
import ca.bradj.questown.items.EffectMetaItem;
import ca.bradj.questown.town.Effect;
import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.NotNull;

public class TownVillagerMoods {
    static Map<ResourceLocation, Integer> buffs;
    private static boolean staticInitialized;
    private final Map<UUID, ImmutableList<Effect>> moodEffects = new HashMap<UUID, ImmutableList<Effect>>();
    private final Map<UUID, Integer> mood = new HashMap<UUID, Integer>();
    private long moodTick = (Long)Config.MOOD_TICK_INTERVAL.get();

    static void staticInitialize() {
        ImmutableMap.Builder b = ImmutableMap.builder();
        b.put((Object)EffectMetaItem.MoodEffects.COMFORTABLE_EATING, (Object)5);
        b.put((Object)EffectMetaItem.MoodEffects.UNCOMFORTABLE_EATING, (Object)-5);
        b.put((Object)EffectMetaItem.MoodEffects.ATE_RAW_FOOD, (Object)-10);
        buffs = b.build();
        staticInitialized = true;
    }

    public static int compute(Collection<Effect> effects) {
        Integer neutral = (Integer)Config.NEUTRAL_MOOD.get();
        Integer computed = effects.stream().map(Effect::effect).map(buffs::get).reduce(Integer::sum).orElse(neutral);
        return Math.max(Math.min(neutral + computed, 100), 0);
    }

    public void tick(long currentTick) {
        if (!staticInitialized) {
            throw new IllegalStateException("Moods registry not initialized");
        }
        --this.moodTick;
        if (this.moodTick > 0L) {
            return;
        }
        this.moodTick = (Long)Config.MOOD_TICK_INTERVAL.get();
        this.moodEffects.forEach((uuid, effects) -> this.mood.put((UUID)uuid, TownVillagerMoods.compute((Collection<Effect>)effects)));
        this.moodEffects.keySet().forEach(i -> this.moodEffects.computeIfPresent((UUID)i, (uuid, effects) -> TownVillagerMoods.removeExpired(currentTick, (ImmutableList<Effect>)effects)));
    }

    @NotNull
    private static ImmutableList<Effect> removeExpired(long currentTick, ImmutableList<Effect> effects) {
        ImmutableList.Builder b = ImmutableList.builder();
        effects.stream().filter(v -> v.untilTick() >= currentTick).forEach(arg_0 -> ((ImmutableList.Builder)b).add(arg_0));
        return b.build();
    }

    public float getMood(UUID uuid) {
        return (float)this.mood.getOrDefault(uuid, (Integer)Config.NEUTRAL_MOOD.get()).intValue() / 100.0f;
    }

    public void tryApplyEffect(ResourceLocation effect, Long expireOnTick, UUID uuid) {
        ImmutableList<Effect> current = this.moodEffects.getOrDefault(uuid, (ImmutableList<Effect>)ImmutableList.of());
        ImmutableList.Builder b = ImmutableList.builder();
        b.addAll(current);
        if (buffs.containsKey(effect)) {
            Effect e = new Effect(effect, expireOnTick);
            b.add((Object)e);
            QT.VILLAGER_LOGGER.debug("Effect has been applied to {}: {}", (Object)uuid, (Object)e);
        }
        this.moodEffects.put(uuid, (ImmutableList<Effect>)b.build());
    }

    public void initialize(Map<UUID, ? extends ImmutableCollection<Effect>> moodEffects) {
        if (!this.moodEffects.isEmpty()) {
            throw new IllegalStateException("Attempting to initialize already active mood effects");
        }
        moodEffects.forEach((k, v) -> this.moodEffects.put((UUID)k, (ImmutableList<Effect>)ImmutableList.copyOf((Collection)v)));
    }

    public ImmutableMap<UUID, ImmutableList<Effect>> getEffects() {
        return ImmutableMap.copyOf(this.moodEffects);
    }

    static {
        staticInitialized = false;
    }
}

