/*
 * Decompiled with CFR 0.152.
 */
package ca.bradj.questown.town;

import ca.bradj.questown.QT;
import ca.bradj.questown.blocks.JobBoardBlock;
import ca.bradj.questown.blocks.OpenMenuListener;
import ca.bradj.questown.blocks.TownFlagSubBlocks;
import ca.bradj.questown.gui.AddWorkContainer;
import ca.bradj.questown.gui.TownWorkContainer;
import ca.bradj.questown.gui.UIWork;
import ca.bradj.questown.jobs.ServerJobsRegistry;
import ca.bradj.questown.jobs.WorksBehaviour;
import ca.bradj.questown.jobs.requests.WorkRequest;
import ca.bradj.questown.mc.Compat;
import ca.bradj.questown.town.TownFlagBlockEntity;
import ca.bradj.questown.town.WorkHandle;
import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Stack;
import java.util.function.Consumer;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TownWorkHandle
implements WorkHandle,
OpenMenuListener {
    final Collection<WorkRequest> requestedResults = new ArrayList<WorkRequest>();
    private final Stack<Consumer<ServerLevel>> nextTick = new Stack();
    final ArrayList<BlockPos> jobBoards = new ArrayList();
    private final List<Consumer<Change>> listeners = new ArrayList<Consumer<Change>>();
    private final BlockPos parentPos;
    private final TownFlagSubBlocks subBlocks;

    public TownWorkHandle(TownFlagSubBlocks subBlocks, BlockPos parentPos) {
        this.parentPos = parentPos;
        this.subBlocks = subBlocks;
    }

    public void registerJobBoard(BlockPos matPos) {
        this.nextTick.add(sl -> {
            BlockState bs = sl.m_8055_(matPos);
            Block patt2306$temp = bs.m_60734_();
            if (!(patt2306$temp instanceof JobBoardBlock)) {
                QT.FLAG_LOGGER.error("Registered job board was not found in world at {}", (Object)matPos);
                return;
            }
            JobBoardBlock jbb = (JobBoardBlock)patt2306$temp;
            BlockEntity p = sl.m_7702_(this.parentPos);
            if (!(p instanceof TownFlagBlockEntity)) {
                QT.FLAG_LOGGER.error("No flag found at work handle parent pos");
                return;
            }
            TownFlagBlockEntity parent = (TownFlagBlockEntity)p;
            TownWorkHandle self = parent.workHandle;
            self.jobBoards.add(matPos);
            jbb.addOpenMenuListener(self);
            this.subBlocks.register(matPos);
        });
    }

    @Override
    public boolean hasAtLeastOneBoard() {
        return !this.jobBoards.isEmpty();
    }

    @Override
    public void openMenuRequested(ServerPlayer sp, final boolean skipToAdd) {
        BlockEntity p = sp.m_9236_().m_7702_(this.parentPos);
        if (!(p instanceof TownFlagBlockEntity)) {
            QT.FLAG_LOGGER.error("No flag found at work handle parent pos");
            return;
        }
        TownFlagBlockEntity parent = (TownFlagBlockEntity)p;
        final BlockPos flagPos = parent.getTownFlagBasePos();
        WorksBehaviour.TownData td = parent.getTownData();
        final ImmutableSet<Ingredient> allOutputs = ServerJobsRegistry.getAllOutputs(td);
        Compat.openScreen(sp, new MenuProvider(){

            @NotNull
            public Component m_5446_() {
                return Compat.literal("");
            }

            @NotNull
            public AbstractContainerMenu m_7208_(int windowId, @NotNull Inventory inv, @NotNull Player p) {
                AddWorkContainer r = new AddWorkContainer(windowId, (Collection<Ingredient>)allOutputs, flagPos);
                return new TownWorkContainer(windowId, TownWorkHandle.this.requestedResults.stream().map(UIWork::new).toList(), r, flagPos, skipToAdd);
            }
        }, data -> {
            AddWorkContainer.writeWorkResults((ImmutableCollection<Ingredient>)allOutputs, data);
            AddWorkContainer.writeFlagPosition(flagPos, data);
            TownWorkContainer.writeWork(this.requestedResults, data);
            TownWorkContainer.writeFlagPosition(flagPos, data);
            data.writeBoolean(skipToAdd);
        });
    }

    public ImmutableList<WorkRequest> getRequestedResults() {
        return ImmutableList.copyOf(this.requestedResults);
    }

    @Override
    public void requestWork(Item requested) {
        WorkRequest e = WorkRequest.of(requested);
        this.requestWork(e);
    }

    @Override
    public void requestWork(WorkRequest e) {
        this.requestedResults.add(e);
        this.listeners.forEach(l -> l.accept(new Change(null)));
        QT.FLAG_LOGGER.debug("Request added to job board: {}", (Object)e);
    }

    @Override
    public void removeWorkRequest(WorkRequest of) {
        this.requestedResults.remove(of);
        this.listeners.forEach(l -> l.accept(new Change(of)));
        QT.FLAG_LOGGER.debug("Request removed from job board: {}", (Object)of);
    }

    public void tick(ServerLevel sl) {
        if (this.nextTick.isEmpty()) {
            return;
        }
        this.nextTick.pop().accept(sl);
    }

    public void addChangeListener(Consumer<Change> o) {
        this.listeners.add(o);
    }

    public record Change(@Nullable WorkRequest removed) {
    }
}

