/*
 * Decompiled with CFR 0.152.
 */
package ca.bradj.questown.town;

import ca.bradj.questown.QT;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.function.Function;
import org.jetbrains.annotations.NotNull;

public class VillagerBedsHandle<POS, ENT, TOWN> {
    private final Map<POS, ENT> claimedBeds = new HashMap<POS, ENT>();
    private final Map<String, POS> assignedBeds = new HashMap<String, POS>();
    private final Function<TOWN, Collection<POS>> getAllBedHeads;
    private final BiFunction<TOWN, POS, Double> getHealingFactor;
    private final BiFunction<TOWN, ENT, Integer> getDamageTicksLeft;
    private final BiFunction<ENT, POS, Double> getDistance;
    private final Function<ENT, String> keyify;

    public VillagerBedsHandle(Function<TOWN, Collection<POS>> getAllBedHeads, BiFunction<TOWN, POS, Double> getHealingFactor, BiFunction<TOWN, ENT, Integer> getDamageTicksLeft, BiFunction<ENT, POS, Double> getDistance, Function<ENT, String> keyify) {
        this.getAllBedHeads = getAllBedHeads;
        this.getHealingFactor = getHealingFactor;
        this.getDamageTicksLeft = getDamageTicksLeft;
        this.getDistance = getDistance;
        this.keyify = keyify;
    }

    public void claim(ENT uuid, @NotNull TOWN town) {
        Collection<POS> beds = this.getAllBedHeads.apply(town);
        for (POS bed : beds) {
            if (this.claimedBeds.containsKey(bed) && uuid.equals(this.claimedBeds.get(bed))) continue;
            this.claimedBeds.put(bed, uuid);
            break;
        }
    }

    public void tick(TOWN town, Collection<ENT> villagers) {
        List<HealingBed<POS>> bedsLeftToAssign = this.getBedHeadsSortedByHealingDesc(town);
        ImmutableList<ENT> villagersByMostDamaged = this.copyVillagersAndSortByDamagedDesc(town, villagers);
        villagersByMostDamaged.forEach(v -> {
            ImmutableList<POS> bestBedsForVillager = this.getBestBedsForVillager((ENT)v, (Collection<HealingBed<POS>>)ImmutableList.copyOf((Collection)bedsLeftToAssign));
            Iterator iterator = bestBedsForVillager.iterator();
            if (iterator.hasNext()) {
                Object p = iterator.next();
                if (!p.equals(this.assignedBeds.get(this.keyify.apply(v)))) {
                    QT.FLAG_LOGGER.debug("Villager bed set to {} for {}", p, v);
                }
                this.assignedBeds.put(this.keyify.apply(v), p);
                bedsLeftToAssign.removeIf(z -> z.pos.equals(p));
                return;
            }
        });
    }

    private ImmutableList<POS> getBestBedsForVillager(ENT entity, Collection<HealingBed<POS>> all) {
        ArrayList<HealingBed<POS>> bedsLeftToAssign = new ArrayList<HealingBed<POS>>(all);
        bedsLeftToAssign.sort(Comparator.comparingDouble(a -> this.getDistance.apply(entity, a.pos) / Math.pow(a.factor, 2.0)));
        return ImmutableList.copyOf(bedsLeftToAssign.stream().map(v -> v.pos).toList());
    }

    private ImmutableList<ENT> copyVillagersAndSortByDamagedDesc(TOWN town, Collection<ENT> villagers) {
        ArrayList<ENT> out = new ArrayList<ENT>(villagers);
        out.sort(Comparator.comparingDouble(v -> -this.getDamageTicksLeft.apply(town, v).intValue()));
        return ImmutableList.copyOf(out);
    }

    private List<HealingBed<POS>> getBedHeadsSortedByHealingDesc(TOWN town) {
        Collection<POS> all = this.getAllBedHeads.apply(town);
        Function<Object, HealingBed> hf = v -> new HealingBed<Object>(v, this.getHealingFactor.apply(town, v));
        ArrayList<HealingBed<POS>> bedsLeftToAssign = new ArrayList<HealingBed<POS>>(all.stream().map(hf).toList());
        bedsLeftToAssign.sort(Comparator.comparingDouble(a -> a.factor));
        return bedsLeftToAssign;
    }

    public POS getBestBed(ENT villager1) {
        return this.assignedBeds.get(this.keyify.apply(villager1));
    }

    private record HealingBed<POS>(POS pos, Double factor) {
    }
}

