/*
 * Decompiled with CFR 0.152.
 */
package ca.bradj.questown.town.quests;

import ca.bradj.questown.core.Config;
import ca.bradj.questown.town.quests.RoomNeed;
import java.util.Collection;
import java.util.UUID;
import java.util.function.Supplier;

public abstract class AbstractQuestGarden<BATCH, ROOM_ID> {
    private final int idealTicks;
    private final int maxTicks;
    private int costSoFar;
    private int ticksSoFar;
    private int maxCost;
    BATCH batch = this.getEmptyBatch();

    public int getCostSoFar() {
        return this.costSoFar;
    }

    protected AbstractQuestGarden(int idealTicks, int maxTicks, int maxCost) {
        this.idealTicks = idealTicks;
        this.maxTicks = maxTicks;
        this.maxCost = maxCost;
    }

    protected abstract BATCH getEmptyBatch();

    protected abstract ROOM_ID getRandomRoom(Collection<ROOM_ID> var1);

    public boolean grow(Supplier<Boolean> hasEnoughBeds, Supplier<Collection<RoomNeed<ROOM_ID>>> neededRooms, Supplier<Collection<ROOM_ID>> allRecipes) {
        if (this.costSoFar >= this.maxCost) {
            return false;
        }
        ++this.ticksSoFar;
        if (this.isOvergrown()) {
            return false;
        }
        boolean added = this.doGrow(hasEnoughBeds, neededRooms, allRecipes);
        if (this.ticksSoFar > this.maxTicks) {
            return false;
        }
        return added;
    }

    protected abstract boolean isOvergrown();

    private boolean doGrow(Supplier<Boolean> hasEnoughBeds, Supplier<Collection<RoomNeed<ROOM_ID>>> neededRooms, Supplier<Collection<ROOM_ID>> allRecipes) {
        if (hasEnoughBeds.get().booleanValue() || this.hasBedAlready(this.batch)) {
            Collection<RoomNeed<ROOM_ID>> nr = neededRooms.get();
            if (nr.isEmpty()) {
                ROOM_ID randomRoom = this.getRandomRoom(allRecipes.get());
                if (this.shouldSkip(randomRoom)) {
                    return true;
                }
                this.addAndRecord(randomRoom);
                return true;
            }
            if (nr.size() == 1) {
                ROOM_ID id = nr.iterator().next().id();
                this.addAndRecord(id);
                return true;
            }
            Object randomNeededRoom = this.getRandomRoom(nr.stream().map(RoomNeed::id).toList());
            this.addAndRecord(randomNeededRoom);
            return true;
        }
        this.addBedQuest(null, this.batch);
        this.costSoFar += this.getBedCost();
        return true;
    }

    private void addAndRecord(ROOM_ID randomRoom) {
        this.addQuest(this.batch, randomRoom);
        int cost = this.getCost(randomRoom);
        if (AbstractQuestGarden.notValid(cost)) {
            return;
        }
        this.costSoFar += cost;
    }

    protected abstract boolean hasBedAlready(BATCH var1);

    private boolean shouldSkip(ROOM_ID id) {
        int newCost = this.getCost(id);
        if (AbstractQuestGarden.notValid(newCost)) {
            return true;
        }
        if (this.questAlreadyRequested(this.batch, id)) {
            newCost = (int)((double)newCost * (Double)Config.DUPLICATE_QUEST_COST_FACTOR.get());
        }
        if (this.ticksSoFar < this.idealTicks && (float)newCost < (float)this.maxCost / 4.0f) {
            return true;
        }
        if (newCost > this.maxCost / 2) {
            return true;
        }
        return newCost > this.maxCost - this.costSoFar;
    }

    private static boolean notValid(int newCost) {
        return Integer.MAX_VALUE == newCost || newCost < 0;
    }

    protected abstract boolean questAlreadyRequested(BATCH var1, ROOM_ID var2);

    protected abstract int getBedCost();

    protected abstract int getCost(ROOM_ID var1);

    protected abstract void addQuest(BATCH var1, ROOM_ID var2);

    protected abstract void addBedQuest(UUID var1, BATCH var2);

    public BATCH get() {
        return this.batch;
    }
}

