/*
 * Decompiled with CFR 0.152.
 */
package ca.bradj.questown.town.quests;

import ca.bradj.questown.QT;
import ca.bradj.questown.core.VillagerUUID;
import ca.bradj.questown.core.init.RewardsInit;
import ca.bradj.questown.town.interfaces.TownInterface;
import ca.bradj.questown.town.quests.MCQuest;
import ca.bradj.questown.town.quests.MCReward;
import ca.bradj.questown.town.quests.Quest;
import ca.bradj.questown.town.quests.QuestBatch;
import ca.bradj.questown.town.rewards.RewardType;
import ca.bradj.questown.town.special.SpecialQuests;
import ca.bradj.roomrecipes.serialization.MCRoom;
import com.google.common.collect.ImmutableList;
import java.util.UUID;
import joptsimple.internal.Strings;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MCQuestBatch
extends QuestBatch<ResourceLocation, MCRoom, MCQuest, MCReward> {
    public static final Serializer SERIALIZER = new Serializer();
    private VillagerUUID owner;

    MCQuestBatch() {
        this(null, null, null);
    }

    public MCQuestBatch(final UUID batchUUID, @Nullable VillagerUUID owner, @NotNull MCReward reward) {
        super(new Quest.QuestFactory<ResourceLocation, MCRoom, MCQuest>(){

            @Override
            public MCQuest newQuest(@Nullable UUID ownerID, ResourceLocation recipeId) {
                return MCQuest.standalone(batchUUID, VillagerUUID.from(ownerID), recipeId);
            }

            @Override
            public MCQuest newUpgradeQuest(@Nullable UUID ownerID, ResourceLocation oldRecipeId, ResourceLocation newRecipeId) {
                return MCQuest.upgrade(batchUUID, VillagerUUID.from(ownerID), oldRecipeId, newRecipeId);
            }

            @Override
            public MCQuest newItemQuest(@Nullable UUID ownerId, ResourceLocation itemId, int count) {
                return MCQuest.item(batchUUID, VillagerUUID.from(ownerId), itemId, count);
            }

            @Override
            public MCQuest completed(@Nullable MCRoom room, MCQuest input) {
                return input.completed(room);
            }

            @Override
            public MCQuest lost(MCQuest foundQuest) {
                return foundQuest.lost();
            }
        }, reward, batchUUID);
        this.owner = owner;
    }

    public VillagerUUID getOwner() {
        return this.owner;
    }

    @Override
    public void assignTo(@NotNull VillagerUUID owner) {
        this.owner = owner;
        super.assignTo(owner);
    }

    public String toNiceString() {
        return String.format("%s from [%s]", ((MCReward)this.reward).toNiceString(), Strings.join(this.getAll().stream().map(Quest::toShortString).toList(), (String)","));
    }

    @Override
    public String getCompletionMessage() {
        if (((MCReward)this.reward).contains((RewardType)RewardsInit.VISITOR.get())) {
            return "dialog.visitors.instruction.sleep_visitors";
        }
        return null;
    }

    public static class Serializer {
        private static final String NBT_NUM_QUESTS = "num_quests";
        private static final String NBT_QUESTS = "quests";
        private static final String NBT_REWARD = "reward";
        private static final String NBT_OWNER_UUID = "owner_uuid";
        private static final String NBT_BATCH_UUID = "batch_uuid";

        public CompoundTag serializeNBT(MCQuestBatch quests) {
            CompoundTag ct = new CompoundTag();
            if (quests.getOwner() != null) {
                quests.getOwner().writeToNBT(ct, NBT_OWNER_UUID);
            }
            ImmutableList aqs = quests.getAll();
            ct.m_128405_(NBT_NUM_QUESTS, aqs.size());
            ListTag aq = new ListTag();
            for (MCQuest q : aqs) {
                aq.add((Object)MCQuest.SERIALIZER.serializeNBT(q));
            }
            ct.m_128365_(NBT_QUESTS, (Tag)aq);
            ct.m_128365_(NBT_REWARD, MCReward.SERIALIZER.serializeNBT((MCReward)quests.reward));
            if (quests.getBatchUUID() != null) {
                ct.m_128362_(NBT_BATCH_UUID, quests.getBatchUUID());
            }
            return ct;
        }

        public MCQuestBatch deserializeNBT(TownInterface entity, CompoundTag nbt) {
            MCQuestBatch quests = new MCQuestBatch();
            if (nbt.m_128441_(NBT_OWNER_UUID)) {
                quests.owner = VillagerUUID.fromNBT(nbt, NBT_OWNER_UUID);
            }
            ImmutableList.Builder aqs = ImmutableList.builder();
            int num = nbt.m_128451_(NBT_NUM_QUESTS);
            ListTag aq = nbt.m_128437_(NBT_QUESTS, 10);
            for (int i = 0; i < num; ++i) {
                CompoundTag tag = aq.m_128728_(i);
                MCQuest q = MCQuest.SERIALIZER.deserializeNBT(tag);
                aqs.add((Object)q);
            }
            ImmutableList allQuests = aqs.build();
            UUID batchUUID = Serializer.backwardsCompatibleBatchUUIDLoader(nbt, (ImmutableList<MCQuest>)allQuests);
            MCReward reward = MCReward.SERIALIZER.deserializeNBT(entity, nbt.m_128469_(NBT_REWARD));
            quests.initialize(batchUUID, allQuests, reward);
            return quests;
        }

        @Nullable
        private static UUID backwardsCompatibleBatchUUIDLoader(CompoundTag nbt, ImmutableList<MCQuest> allQuests) {
            UUID batchUUID = null;
            if (nbt.m_128441_(NBT_BATCH_UUID)) {
                batchUUID = nbt.m_128342_(NBT_BATCH_UUID);
            }
            if (batchUUID == null) {
                if (allQuests.size() == 1 && SpecialQuests.isSpecialQuest((ResourceLocation)((MCQuest)allQuests.get(0)).getWantedId())) {
                    return null;
                }
                batchUUID = UUID.randomUUID();
                QT.QUESTS_LOGGER.warn("[Backwards Compatibility] Generating UUID for quest batch with missing UUID: {}", (Object)batchUUID);
            }
            return batchUUID;
        }
    }
}

