/*
 * Decompiled with CFR 0.152.
 */
package ca.bradj.questown.town.quests;

import ca.bradj.questown.QT;
import ca.bradj.questown.core.init.RewardsInit;
import ca.bradj.questown.town.interfaces.TownInterface;
import ca.bradj.questown.town.quests.MCReward;
import ca.bradj.questown.town.quests.MCRewardContainer;
import ca.bradj.questown.town.quests.Reward;
import ca.bradj.questown.town.rewards.RewardType;
import com.google.common.collect.ImmutableList;
import java.util.Collection;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import org.jetbrains.annotations.NotNull;

public class MCRewardList
extends MCReward
implements MCRewardContainer {
    public static final String ID = "list";
    private static final String NBT_CHILDREN = "children";
    public ImmutableList<MCReward> children;

    public MCRewardList(RewardType<? extends MCReward> rType, TownInterface town, MCReward ... children) {
        super(rType);
        this.children = ImmutableList.copyOf((Object[])children);
    }

    public MCRewardList(TownInterface town, Collection<? extends MCReward> children) {
        this((RewardType)RewardsInit.LIST.get(), town, children.toArray(new MCReward[0]));
    }

    public MCRewardList(TownInterface town, MCReward ... children) {
        this((RewardType)RewardsInit.LIST.get(), town, children);
    }

    @Override
    @NotNull
    protected Reward.RewardApplier getApplier() {
        return () -> {
            QT.QUESTS_LOGGER.debug("Applying quests: {}", this.getChildren());
            for (Reward reward : this.getChildren()) {
                reward.claim();
            }
        };
    }

    @Override
    public boolean addsQuestsWhenApplied() {
        return this.children.stream().anyMatch(MCReward::addsQuestsWhenApplied);
    }

    @Override
    protected CompoundTag serializeNbt() {
        CompoundTag tag = new CompoundTag();
        ListTag cs = new ListTag();
        for (MCReward r : this.getChildren()) {
            cs.add((Object)MCReward.SERIALIZER.serializeNBT(r));
        }
        tag.m_128365_(NBT_CHILDREN, (Tag)cs);
        return tag;
    }

    @Override
    protected void deserializeNbt(TownInterface entity, CompoundTag tag) {
        ImmutableList cz;
        if (this.getChildren() != null && this.getChildren().size() > 0) {
            throw new IllegalStateException("Already initialized");
        }
        ListTag l = tag.m_128437_(NBT_CHILDREN, 10);
        ImmutableList.Builder b = ImmutableList.builder();
        for (int i = 0; i < l.size(); ++i) {
            b.add((Object)MCReward.SERIALIZER.deserializeNBT(entity, l.m_128728_(i)));
        }
        this.children = cz = b.build();
        this.initializeChildren();
    }

    protected void initializeChildren() {
    }

    public Collection<MCReward> getChildren() {
        return this.children;
    }

    @Override
    public Collection<MCReward> getContainedRewards() {
        return ImmutableList.copyOf(this.children);
    }

    public String toString() {
        return "MCRewardList{children=" + String.join((CharSequence)", ", this.children.stream().map(Object::toString).toList()) + "}";
    }

    @Override
    public String toNiceString() {
        return "MCRewardList{children=" + String.join((CharSequence)", ", this.children.stream().map(MCReward::toNiceString).toList()) + "}";
    }

    @Override
    public boolean contains(@NotNull RewardType<?> reward) {
        return this.children.stream().anyMatch(v -> v.contains(reward));
    }
}

