/*
 * Decompiled with CFR 0.152.
 */
package ca.bradj.questown.town.quests;

import ca.bradj.questown.town.interfaces.TownInterface;
import ca.bradj.questown.town.quests.MCQuestBatch;
import ca.bradj.questown.town.quests.MCReward;
import ca.bradj.questown.town.quests.Quest;
import ca.bradj.questown.town.quests.QuestBatchSeed;
import com.google.common.collect.ImmutableList;
import java.util.Collection;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;

public class PendingQuestsSerializer {
    public static final PendingQuestsSerializer INSTANCE = new PendingQuestsSerializer();
    private static final String NBT_NUM_BATCHES = "num_batches";
    private static final String NBT_BATCHES = "batches";
    private static final String NBT_WEIGHT_THRESHOLD = "weight_threshold";

    public CompoundTag serializeNBT(Collection<QuestBatchSeed> batches) {
        CompoundTag ct = new CompoundTag();
        ct.m_128405_(NBT_NUM_BATCHES, batches.size());
        ListTag aq = new ListTag();
        for (QuestBatchSeed q : batches) {
            MCQuestBatch asBatch = new MCQuestBatch(((MCQuestBatch)q.batch).getBatchUUID(), ((MCQuestBatch)q.batch).getOwner(), (MCReward)((MCQuestBatch)q.batch).getReward());
            ((MCQuestBatch)q.batch).getAll().forEach(v -> asBatch.addNewQuest(v.getUUID(), (ResourceLocation)v.getWantedId()));
            CompoundTag tag = MCQuestBatch.SERIALIZER.serializeNBT(asBatch);
            tag.m_128405_(NBT_WEIGHT_THRESHOLD, q.targetItemWeight);
            aq.add((Object)tag);
        }
        ct.m_128365_(NBT_BATCHES, (Tag)aq);
        return ct;
    }

    public Collection<QuestBatchSeed> deserializeNBT(TownInterface town, CompoundTag nbt) {
        ImmutableList.Builder aqs = ImmutableList.builder();
        int num = nbt.m_128451_(NBT_NUM_BATCHES);
        ListTag aq = nbt.m_128437_(NBT_BATCHES, 10);
        for (int i = 0; i < num; ++i) {
            CompoundTag tag = aq.m_128728_(i);
            MCQuestBatch b = MCQuestBatch.SERIALIZER.deserializeNBT(town, tag);
            int threshold = tag.m_128451_(NBT_WEIGHT_THRESHOLD);
            QuestBatchSeed pendingQuests = new QuestBatchSeed(town.getServerLevel(), b.getBatchUUID(), threshold);
            for (Quest q : b.getAll()) {
                ((MCQuestBatch)pendingQuests.batch).addNewQuest(q.getUUID(), (ResourceLocation)q.getWantedId());
            }
            aqs.add((Object)pendingQuests);
        }
        return aqs.build();
    }
}

