/*
 * Decompiled with CFR 0.152.
 */
package ca.bradj.questown.town.quests;

import ca.bradj.questown.core.VillagerUUID;
import ca.bradj.roomrecipes.core.Room;
import ca.bradj.roomrecipes.core.space.Position;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nullable;

public class Quest<KEY, ROOM extends Room> {
    final UUID selfUUID = UUID.randomUUID();
    @Nullable
    protected VillagerUUID ownerUUID;
    protected UUID batchUUID;
    protected KEY recipeId;
    protected QuestStatus status;
    @Nullable
    protected ROOM completedOn;
    private QuestType type;
    private int count;
    @Nullable
    KEY fromRecipeID;

    Quest() {
        this(null, null, null, null, null, 1);
    }

    public String toString() {
        return "Quest{selfUUID=" + String.valueOf(this.selfUUID) + "ownerUUID=" + String.valueOf(this.ownerUUID) + ", recipeId=" + String.valueOf(this.recipeId) + ", status=" + String.valueOf((Object)this.status) + ", completedOn=" + String.valueOf(this.completedOn) + ", fromRecipeID=" + String.valueOf(this.fromRecipeID) + "}";
    }

    public String toShortString() {
        Position doorPos = null;
        if (this.completedOn != null) {
            doorPos = ((Room)this.completedOn).doorPos;
        }
        return String.format("Quest{id=%s, owner=%s, on=%s, from=%s", this.recipeId, this.ownerUUID, doorPos, this.fromRecipeID);
    }

    protected Quest(UUID batchUUID, @Nullable VillagerUUID ownerId, KEY recipe, @Nullable KEY oldRecipe, QuestType questType, int count) {
        this.batchUUID = batchUUID;
        this.ownerUUID = ownerId;
        this.recipeId = recipe;
        this.status = QuestStatus.ACTIVE;
        this.fromRecipeID = oldRecipe;
        this.type = questType;
        this.count = count;
    }

    public KEY getWantedId() {
        return this.recipeId;
    }

    public boolean isComplete() {
        return QuestStatus.COMPLETED.equals((Object)this.status);
    }

    public QuestStatus getStatus() {
        return this.status;
    }

    public VillagerUUID getUUID() {
        return this.ownerUUID;
    }

    public void initialize(VillagerUUID uuid, QuestType type, int count, KEY recipeId, QuestStatus status, @Nullable ROOM completedOn, @Nullable KEY fromRecipeID) {
        this.ownerUUID = uuid;
        this.type = type;
        this.count = count;
        this.recipeId = recipeId;
        this.status = status;
        this.completedOn = completedOn;
        this.fromRecipeID = fromRecipeID;
    }

    public Optional<KEY> fromRecipeID() {
        return Optional.ofNullable(this.fromRecipeID);
    }

    public UUID getBatchUUID() {
        return this.batchUUID;
    }

    public QuestType getType() {
        return this.type;
    }

    public int getCountNeeded() {
        return this.count;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Quest quest = (Quest)o;
        return Quest.equals(false, this, quest);
    }

    public static <Q extends Quest<?, ?>> boolean equals(boolean ignoreSelfUUID, Q one, Q another) {
        boolean eqUUID = Objects.equals(one.selfUUID, another.selfUUID);
        if (!eqUUID && !ignoreSelfUUID) {
            return false;
        }
        return Objects.equals(one.ownerUUID, another.ownerUUID) && Objects.equals(one.batchUUID, another.batchUUID) && Objects.equals(one.recipeId, another.recipeId) && one.status == another.status && Objects.equals(one.completedOn, another.completedOn) && Objects.equals(one.fromRecipeID, another.fromRecipeID);
    }

    public int hashCode() {
        return Quest.hashCode(false, this);
    }

    public static int hashCode(boolean ignoreOwnUUID, Quest<?, ?> q) {
        UUID sUU = q.selfUUID;
        if (ignoreOwnUUID) {
            sUU = null;
        }
        return Objects.hash(new Object[]{sUU, q.ownerUUID, q.batchUUID, q.recipeId, q.status, q.completedOn, q.fromRecipeID});
    }

    public static enum QuestType {
        ITEM,
        ROOM,
        UNKNOWN;

    }

    public static enum QuestStatus {
        UNSET(""),
        ACTIVE("active"),
        COMPLETED("completed"),
        LOST("lost");

        private final String str;

        private QuestStatus(String str) {
            this.str = str;
        }

        public static QuestStatus fromString(String status) {
            return switch (status) {
                case "active" -> ACTIVE;
                case "completed" -> COMPLETED;
                case "lost" -> LOST;
                default -> throw new IllegalStateException("Unexpected status: " + status);
            };
        }

        public String asString() {
            return this.str;
        }
    }

    static interface QuestFactory<KEY, ROOM extends Room, QUEST extends Quest<KEY, ROOM>> {
        public QUEST newQuest(@Nullable UUID var1, KEY var2);

        public QUEST newUpgradeQuest(@Nullable UUID var1, KEY var2, KEY var3);

        public QUEST newItemQuest(@Nullable UUID var1, KEY var2, int var3);

        public QUEST completed(ROOM var1, QUEST var2);

        public QUEST lost(QUEST var1);
    }
}

