/*
 * Decompiled with CFR 0.152.
 */
package ca.bradj.questown.town.quests;

import ca.bradj.questown.QT;
import ca.bradj.questown.blocks.RoomBlock;
import ca.bradj.questown.blocks.entity.BlockAsRoomEntity;
import ca.bradj.questown.core.Config;
import ca.bradj.questown.core.VillagerUUID;
import ca.bradj.questown.gui.Ingredients;
import ca.bradj.questown.logic.RoomRecipes;
import ca.bradj.questown.town.quests.AbstractQuestGarden;
import ca.bradj.questown.town.quests.MCQuest;
import ca.bradj.questown.town.quests.MCQuestBatch;
import ca.bradj.questown.town.quests.MCReward;
import ca.bradj.questown.town.special.SpecialQuests;
import ca.bradj.roomrecipes.recipes.RoomRecipe;
import com.google.common.collect.ImmutableList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.core.NonNullList;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.ItemTags;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;

public class QuestBatchSeed
extends AbstractQuestGarden<MCQuestBatch, ResourceLocation> {
    private final ServerLevel level;
    int targetItemWeight;
    int attempts = 0;
    private static final Map<ResourceLocation, Integer> cachedCosts = new HashMap<ResourceLocation, Integer>();

    public MCQuestBatch get(MCReward rw, VillagerUUID owner) {
        ((MCQuestBatch)this.batch).setReward(rw);
        ((MCQuestBatch)this.batch).assignTo(owner);
        return (MCQuestBatch)this.batch;
    }

    public QuestBatchSeed(ServerLevel level, UUID batchUUID, int targetItemWeight) {
        super((Integer)Config.IDEAL_QUEST_THRESHOLD_TICKS.get(), (Integer)Config.QUEST_GENERATION_MAX_TICKS.get(), targetItemWeight);
        this.level = level;
        this.batch = new MCQuestBatch(batchUUID, null, null);
    }

    @Override
    protected MCQuestBatch getEmptyBatch() {
        return new MCQuestBatch();
    }

    @Override
    protected ResourceLocation getRandomRoom(Collection<ResourceLocation> rooms) {
        return (ResourceLocation)ImmutableList.copyOf(rooms).get(this.level.m_213780_().m_188503_(rooms.size()));
    }

    @Override
    protected boolean hasBedAlready(MCQuestBatch mcQuestBatch) {
        return mcQuestBatch.getAll().stream().anyMatch(v -> this.hasBeds(this.level, (MCQuest)v));
    }

    private boolean hasBeds(ServerLevel level, MCQuest quest) {
        Map<ResourceLocation, RoomRecipe> rr = RoomRecipes.hydrate(level.m_7465_(), true);
        NonNullList roomIngredients = rr.get(quest.getWantedId()).m_7527_();
        return roomIngredients.stream().anyMatch(this::isBed);
    }

    private boolean isBed(Ingredient ing) {
        String tag = Ingredients.getTag(ing);
        if (tag != null) {
            return ItemTags.f_13146_.f_203868_().equals((Object)new ResourceLocation(tag));
        }
        return Arrays.stream(ing.m_43908_()).anyMatch(v -> v.m_204117_(ItemTags.f_13146_));
    }

    @Override
    protected boolean questAlreadyRequested(MCQuestBatch mcQuestBatch, ResourceLocation id) {
        return ((MCQuestBatch)this.batch).getAll().stream().anyMatch(v -> id.equals(v.getWantedId()));
    }

    @Override
    protected int getBedCost() {
        return QuestBatchSeed.computeQuestCost(this::recipesFromLevel, SpecialQuests.BEDROOM, Integer.MAX_VALUE);
    }

    @Override
    protected int getCost(ResourceLocation randomRoom) {
        return QuestBatchSeed.computeQuestCost(this::recipesFromLevel, randomRoom, Integer.MAX_VALUE);
    }

    @Override
    protected void addQuest(MCQuestBatch mcQuestBatch, ResourceLocation next) {
        mcQuestBatch.addNewQuest(null, next);
    }

    @Override
    protected void addBedQuest(UUID ownerUUID, MCQuestBatch mcQuestBatch) {
        this.addQuest(mcQuestBatch, SpecialQuests.BEDROOM);
    }

    private Map<ResourceLocation, RoomRecipe> recipesFromLevel() {
        return RoomRecipes.hydrate(this.level.m_7465_(), false);
    }

    public static int computeQuestCost(Supplier<Map<ResourceLocation, RoomRecipe>> recipes, ResourceLocation qID, int stopAt) {
        if (cachedCosts.containsKey(qID)) {
            return cachedCosts.get(qID);
        }
        HashMap<ResourceLocation, RoomRecipe> hydrated = new HashMap<ResourceLocation, RoomRecipe>(recipes.get());
        QuestBatchSeed.addBlockRooms(hydrated);
        if (!hydrated.containsKey(qID)) {
            throw new IllegalStateException("No recipe found for ID " + String.valueOf(qID));
        }
        int recipeWeight = RoomRecipes.getRecipeWeight((RoomRecipe)hydrated.get(qID), stopAt);
        if (recipeWeight == 0) {
            QT.QUESTS_LOGGER.warn("Recipe weight is 0. This is probably a bug: {}", (Object)qID);
        }
        cachedCosts.put(qID, recipeWeight);
        return recipeWeight;
    }

    private static void addBlockRooms(Map<ResourceLocation, RoomRecipe> hydrated) {
        for (Supplier<RoomBlock> e : BlockAsRoomEntity.ALL) {
            RoomBlock roomBlock = e.get();
            if (roomBlock.m_5456_().equals(Items.f_41852_)) {
                String m = "Invalid initialization detected. RoomBlock's item seems unregistered: ";
                throw new IllegalStateException(m + roomBlock.getId());
            }
            ResourceLocation rID = RoomBlock.getRoomId(roomBlock);
            Ingredient ingr = Ingredient.m_43929_((ItemLike[])new ItemLike[]{roomBlock.m_5456_()});
            hydrated.put(rID, new RoomRecipe(rID, NonNullList.m_122780_((int)1, (Object)ingr), 1, false));
        }
    }

    @Override
    protected boolean isOvergrown() {
        boolean isOvergrown;
        boolean bl = isOvergrown = ((MCQuestBatch)this.batch).size() > 50;
        if (isOvergrown) {
            QT.logBug("Quest batch overgrown: {}", this.batch);
            for (MCQuest q : ((MCQuestBatch)this.batch).getAll()) {
                QT.QUESTS_LOGGER.debug(" - Quest: {} [Cost: {}]", q.getWantedId(), (Object)QuestBatchSeed.computeQuestCost(this::recipesFromLevel, (ResourceLocation)q.getWantedId(), Integer.MAX_VALUE));
            }
        }
        return isOvergrown;
    }

    public String toString() {
        return "PendingQuests{batch=" + String.valueOf(this.batch) + ", targetItemWeight=" + this.targetItemWeight + ", attempts=" + this.attempts + "}";
    }
}

