/*
 * Decompiled with CFR 0.152.
 */
package ca.bradj.questown.town.quests;

import ca.bradj.questown.QT;
import ca.bradj.questown.Questown;
import ca.bradj.questown.core.VillagerUUID;
import ca.bradj.questown.town.quests.Quest;
import ca.bradj.questown.town.quests.QuestBatch;
import ca.bradj.questown.town.quests.Reward;
import ca.bradj.roomrecipes.core.Room;
import com.google.common.collect.ImmutableList;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.function.BiPredicate;
import java.util.stream.Collectors;
import org.apache.logging.log4j.Marker;
import org.apache.logging.log4j.MarkerManager;
import org.jetbrains.annotations.Nullable;

public class QuestBatches<KEY, ROOM extends Room, QUEST extends Quest<KEY, ROOM>, REWARD extends Reward, BATCH extends QuestBatch<KEY, ROOM, QUEST, REWARD>>
implements QuestBatch.ChangeListener<QUEST> {
    private static final Marker marker = MarkerManager.getMarker((String)"Batches");
    protected final List<BATCH> batches = new ArrayList<BATCH>();
    private final Factory<BATCH, REWARD> factory;
    private QuestBatch.ChangeListener<QUEST> changeListener = new QuestBatch.ChangeListener<QUEST>(){

        @Override
        public void questCompleted(QUEST quest) {
        }

        @Override
        public void questBatchCompleted(QuestBatch<?, ?, ?, ?> quest) {
        }

        @Override
        public void questLost(QUEST quest) {
        }
    };

    public boolean decline(BATCH b) {
        return this.batches.remove(b);
    }

    public <ITEM_KEY, ITEM> void processItemQuests(ImmutableList<ITEM> allStacks, BiPredicate<KEY, ITEM> questMatchesStack, Tracker<ITEM_KEY, ITEM, QUEST> tracker) {
        List stacksToFind = this.getAll().stream().filter(v -> v.getType() == Quest.QuestType.ITEM).collect(Collectors.toCollection(ArrayList::new));
        if (stacksToFind.isEmpty()) {
            return;
        }
        HashMap itemCounts = new HashMap();
        for (Object stack : allStacks) {
            int result;
            Optional<Quest> quest = stacksToFind.stream().filter(v -> questMatchesStack.test(v.getWantedId(), stack)).findFirst();
            if (quest.isEmpty() || (result = tracker.addCount(itemCounts, stack)) < quest.get().getCountNeeded()) continue;
            this.markRecipeAsComplete(null, quest.get().getWantedId());
            stacksToFind.remove(quest.get());
            if (stacksToFind.isEmpty()) {
                return;
            }
            tracker.removeCount(itemCounts, quest.get());
        }
    }

    public QuestBatches(Factory<BATCH, REWARD> factory) {
        this.factory = factory;
    }

    public void initialize(VillagerProvider<ROOM> villagers, ImmutableList<BATCH> bs) {
        if (!this.batches.isEmpty()) {
            Questown.LOGGER.error("QuestBatches were initialized twice :(");
        }
        ImmutableList<BATCH> list = this.filterOutDuplicateCompletion(villagers, bs);
        this.batches.addAll((Collection<BATCH>)list);
        for (QuestBatch b : this.batches) {
            b.addChangeListener(this);
        }
    }

    private ImmutableList<BATCH> filterOutDuplicateCompletion(VillagerProvider villagers, ImmutableList<BATCH> bs) {
        Set completedQuests = bs.stream().flatMap(v -> v.getAll().stream()).filter(Quest::isComplete).peek(q -> {
            q.ownerUUID = QuestBatches.coerceUUID(villagers, q.getUUID());
        }).peek(q -> {
            q.ownerUUID = QuestBatches.coerceUUID(villagers, q.getUUID());
        }).map(IdIgnoring::new).collect(Collectors.toSet());
        ImmutableList.Builder bld = ImmutableList.builder();
        bs.forEach(v -> {
            VillagerUUID owner = QuestBatches.coerceUUID(villagers, v.getUUID());
            Object e = this.emptyBatch(v.getBatchUUID(), owner, v.reward);
            ImmutableList.Builder eqb = ImmutableList.builder();
            v.getAll().forEach(q -> {
                if (q.getType() == Quest.QuestType.ITEM) {
                    e.addItemQuest(owner, q.getWantedId(), q.getCountNeeded());
                } else {
                    e.addNewQuest(owner, q.getWantedId());
                }
                IdIgnoring<Quest> iq = new IdIgnoring<Quest>((Quest)q);
                if (completedQuests.contains(iq)) {
                    e.markRecipeAsComplete(q.completedOn, q.getWantedId());
                    completedQuests.remove(iq);
                }
                eqb.add(q);
            });
            bld.add(e);
        });
        return bld.build();
    }

    @Nullable
    private static <KEY, ROOM extends Room, QUEST extends Quest<KEY, ROOM>, REWARD extends Reward, BATCH extends QuestBatch<KEY, ROOM, QUEST, REWARD>> VillagerUUID coerceUUID(VillagerProvider villagers, @Nullable VillagerUUID owner) {
        if (owner != null && villagers.isVillagerMissing(VillagerUUID.get(owner))) {
            VillagerUUID newOwner = VillagerUUID.from(villagers.getRandomVillager());
            if (newOwner == null) {
                QT.LOGGER.warn("Could not repair quest belonging to {} because no other villagers exist", (Object)owner);
            } else {
                QT.LOGGER.warn("Replacing missing villager {} with {}", (Object)owner, (Object)newOwner);
                owner = newOwner;
            }
        }
        return owner;
    }

    private BATCH emptyBatch(UUID batchUUID, VillagerUUID owner, REWARD reward) {
        return (BATCH)((QuestBatch)this.factory.getNew(batchUUID, owner, reward));
    }

    @Override
    public void questCompleted(QUEST quest) {
        this.changeListener.questCompleted(quest);
    }

    @Override
    public void questBatchCompleted(QuestBatch<?, ?, ?, ?> quest) {
        this.changeListener.questBatchCompleted(quest);
    }

    @Override
    public void questLost(QUEST quest) {
        this.changeListener.questLost(quest);
    }

    public void addChangeListener(QuestBatch.ChangeListener<QUEST> listener) {
        this.changeListener = listener;
    }

    public void add(BATCH qb) {
        this.batches.add(qb);
        ((QuestBatch)qb).addChangeListener(this);
    }

    public ImmutableList<QUEST> getAll() {
        return ImmutableList.copyOf(this.batches.stream().flatMap(QuestBatch::stream).toList());
    }

    public void markRecipeAsComplete(@Nullable ROOM room, KEY recipeId) {
        QuestBatch b2;
        for (QuestBatch b2 : this.batches) {
            if (room == null || !b2.getAll().stream().filter(Quest::isComplete).filter(v -> recipeId.equals(v.getWantedId())).anyMatch(v -> room.equals(v.completedOn))) continue;
            QT.QUESTS_LOGGER.debug(marker, "Quest was already marked complete: {} for door {}", recipeId, (Object)((Room)room).doorPos);
            return;
        }
        Iterator<BATCH> iterator = this.batches.iterator();
        while (iterator.hasNext() && !(b2 = (QuestBatch)iterator.next()).markRecipeAsComplete(room, recipeId)) {
        }
    }

    public ImmutableList<AbstractMap.SimpleEntry<QUEST, REWARD>> getAllWithRewards() {
        ImmutableList.Builder b = ImmutableList.builder();
        this.batches.forEach(v -> v.getAll().forEach(z -> b.add(new AbstractMap.SimpleEntry((Quest)z, v.reward))));
        return b.build();
    }

    public List<AbstractMap.SimpleEntry<QUEST, REWARD>> getAllForVillagerWithRewards(UUID uuid) {
        ImmutableList.Builder b = ImmutableList.builder();
        this.batches.stream().filter(v -> v.getAll().stream().allMatch(z -> uuid.equals(z.ownerUUID))).forEach(v -> v.getAll().forEach(z -> b.add(new AbstractMap.SimpleEntry((Quest)z, v.reward))));
        return b.build();
    }

    public void markRecipeAsConverted(ROOM room, KEY oldRecipeID, KEY newRecipeID) {
        ConversionFunc oldQuest = null;
        ConversionFunc newQuest = null;
        for (QuestBatch b : this.batches) {
            Object match;
            if (oldQuest == null && (match = b.findMatch(room, oldRecipeID)) != null) {
                oldQuest = () -> b.markConsumed(match);
            }
            if (newQuest == null && b.canMarkRecipeAsConverted(oldRecipeID, newRecipeID)) {
                newQuest = () -> b.markRecipeAsConverted(room, oldRecipeID, newRecipeID);
            }
            if (oldQuest == null || newQuest == null) continue;
            oldQuest.apply();
            newQuest.apply();
            return;
        }
    }

    public void markRecipeAsLost(ROOM oldRoom, KEY recipeID) {
        for (QuestBatch b : this.batches) {
            if (!b.markRecipeAsLost(oldRoom, recipeID)) continue;
            return;
        }
    }

    public void changeRoomOnly(ROOM oldRoom, ROOM newRoom) {
        for (QuestBatch b : this.batches) {
            b.changeRoomOnly(oldRoom, newRoom);
        }
    }

    public static interface Tracker<ITEM_KEY, ITEM, QUEST> {
        public int addCount(Map<ITEM_KEY, Integer> var1, ITEM var2);

        public void removeCount(Map<ITEM_KEY, Integer> var1, QUEST var2);
    }

    public static interface Factory<BATCH, REWARD> {
        public BATCH getNew(UUID var1, VillagerUUID var2, REWARD var3);
    }

    public static interface VillagerProvider<R extends Room> {
        public UUID getRandomVillager();

        public boolean isVillagerMissing(UUID var1);
    }

    public static interface ConversionFunc {
        public void apply();
    }

    private record IdIgnoring<Q extends Quest<?, ?>>(Q wrapped) {
        @Override
        public int hashCode() {
            int i = Quest.hashCode(true, this.wrapped);
            return i;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            IdIgnoring that = (IdIgnoring)o;
            boolean equals = Quest.equals(true, this.wrapped, that.wrapped);
            return equals;
        }
    }
}

